/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.locking;

import javax.transaction.HeuristicMixedException;
import javax.transaction.HeuristicRollbackException;
import javax.transaction.RollbackException;
import javax.transaction.Synchronization;
import javax.transaction.SystemException;
import javax.transaction.Transaction;
import javax.transaction.xa.XAResource;
import org.neo4j.kernel.impl.locking.AbstractLockService;
import org.neo4j.kernel.impl.locking.Lock;
import org.neo4j.kernel.impl.locking.LockService;
import org.neo4j.kernel.impl.locking.ReentrantLockService;
import org.neo4j.kernel.impl.locking.community.LockManagerImpl;
import org.neo4j.kernel.impl.locking.community.RagManager;

public class LockServiceMicroBenchmark {
    public static void main(String ... args) {
        LockServiceMicroBenchmark.get(Benchmark.class).execute(LockServiceMicroBenchmark.get(Implementation.class));
    }

    static void executeUncontended(Implementation impl, int threadCount, int iterations, int lockCount, boolean reentry) {
        for (int i = 0; i < iterations; ++i) {
            LockService locks = impl.create();
            MeasuringThread[] threads = new MeasuringThread[threadCount];
            for (int nodeId = 0; nodeId < threadCount; ++nodeId) {
                threads[nodeId] = new LockingThread(nodeId, locks, lockCount, reentry);
            }
            LockServiceMicroBenchmark.execute(threads);
        }
    }

    private static void execute(MeasuringThread[] threads) {
        for (MeasuringThread thread : threads) {
            thread.start();
        }
        for (MeasuringThread thread : threads) {
            try {
                thread.join();
            }
            catch (InterruptedException e) {
                throw new RuntimeException(e);
            }
        }
        long minTime = Long.MAX_VALUE;
        long maxTime = 0L;
        long totalTime = 0L;
        double count = 0.0;
        for (MeasuringThread thread : threads) {
            minTime = Math.min(minTime, thread.minTime);
            maxTime = Math.max(maxTime, thread.maxTime);
            totalTime += thread.totalTime;
            count += (double)thread.iterations;
        }
        System.out.printf("min=%dns; max=%.3fus; total=%.3fms; avg=%.3fns%n", minTime, (double)maxTime / 1000.0, (double)totalTime / 1000000.0, (double)totalTime / count);
    }

    static void executeHandover(Implementation impl, int threadCount, int iterations, int lockCount) {
        throw new UnsupportedOperationException("not implemented");
    }

    static <E extends Enum<E>> E get(Class<E> type) {
        try {
            return Enum.valueOf(type, System.getProperty(type.getSimpleName()));
        }
        catch (IllegalArgumentException e) {
            throw new IllegalArgumentException("No such " + type.getSimpleName() + ": " + System.getProperty(type.getSimpleName()));
        }
        catch (NullPointerException e) {
            throw new IllegalArgumentException(type.getSimpleName() + " not specified.");
        }
    }

    private static int cores() {
        return Runtime.getRuntime().availableProcessors();
    }

    private static class AdaptedLockManager
    extends LockManagerImpl
    implements LockService {
        private final ThreadLocal<Transaction> threadMark = new ThreadLocal<Transaction>(){

            @Override
            protected Transaction initialValue() {
                return new ThreadMark();
            }
        };

        AdaptedLockManager() {
            super(new RagManager());
        }

        public Lock acquireNodeLock(long nodeId, LockService.LockType type) {
            AbstractLockService.LockedNode resource = new AbstractLockService.LockedNode(nodeId);
            this.getWriteLock(resource, this.threadMark.get());
            return new WriteRelease(resource);
        }

        static class ThreadMark
        implements Transaction {
            ThreadMark() {
            }

            public void commit() throws HeuristicMixedException, HeuristicRollbackException, RollbackException, SecurityException, SystemException {
                throw new UnsupportedOperationException("not implemented");
            }

            public boolean delistResource(XAResource xaRes, int flag) throws IllegalStateException, SystemException {
                throw new UnsupportedOperationException("not implemented");
            }

            public boolean enlistResource(XAResource xaRes) throws IllegalStateException, RollbackException, SystemException {
                throw new UnsupportedOperationException("not implemented");
            }

            public int getStatus() throws SystemException {
                throw new UnsupportedOperationException("not implemented");
            }

            public void registerSynchronization(Synchronization synch) throws IllegalStateException, RollbackException, SystemException {
                throw new UnsupportedOperationException("not implemented");
            }

            public void rollback() throws IllegalStateException, SystemException {
                throw new UnsupportedOperationException("not implemented");
            }

            public void setRollbackOnly() throws IllegalStateException, SystemException {
                throw new UnsupportedOperationException("not implemented");
            }
        }

        private class WriteRelease
        extends Lock {
            private final AbstractLockService.LockedNode resource;

            WriteRelease(AbstractLockService.LockedNode resource) {
                this.resource = resource;
            }

            public void release() {
                AdaptedLockManager.this.releaseWriteLock(this.resource, AdaptedLockManager.this.threadMark.get());
            }
        }
    }

    static abstract class MeasuringThread
    extends Thread {
        final int iterations;
        long minTime = Long.MAX_VALUE;
        long maxTime;
        long totalTime;

        MeasuringThread(int iterations) {
            this.iterations = iterations;
        }

        @Override
        public final void run() {
            this.init();
            for (int i = 0; i < this.iterations; ++i) {
                this.execute();
            }
        }

        void init() {
        }

        void update(long time) {
            this.minTime = Math.min(this.minTime, time);
            this.maxTime = Math.max(this.maxTime, time);
            this.totalTime += time;
        }

        protected abstract void execute();
    }

    static class LockingThread
    extends MeasuringThread {
        private final LockService locks;
        private final long nodeId;
        private final boolean reentry;

        LockingThread(long nodeId, LockService locks, int lockCount, boolean reentry) {
            super(lockCount);
            this.locks = locks;
            this.nodeId = nodeId;
            this.reentry = reentry;
        }

        @Override
        void init() {
            if (this.reentry) {
                this.locks.acquireNodeLock(this.nodeId, LockService.LockType.WRITE_LOCK);
            }
        }

        @Override
        protected void execute() {
            long time = System.nanoTime();
            Lock lock = this.locks.acquireNodeLock(this.nodeId, LockService.LockType.WRITE_LOCK);
            this.update(System.nanoTime() - time);
            lock.release();
        }
    }

    static enum Implementation {
        LOCK_MANAGER{

            @Override
            LockService create() {
                return new AdaptedLockManager();
            }
        }
        ,
        REENTRANT_LOCK_SERVICE{

            @Override
            LockService create() {
                return new ReentrantLockService();
            }
        };


        abstract LockService create();
    }

    static enum Benchmark {
        UNCONTENDED{

            @Override
            void execute(Implementation impl) {
                int minThreads = Integer.getInteger("minThreads", 1);
                int maxThreads = Integer.getInteger("maxThreads", LockServiceMicroBenchmark.cores() * 2);
                int iterations = Integer.getInteger("iterations", 100);
                int lockCount = Integer.getInteger("lockCount", 100000);
                for (int threads = minThreads; threads <= maxThreads; ++threads) {
                    System.out.printf("=== %s / %s - %s threads ===%n", new Object[]{this, impl, threads});
                    LockServiceMicroBenchmark.executeUncontended(impl, threads, iterations, lockCount, false);
                }
            }
        }
        ,
        REENTRY{

            @Override
            void execute(Implementation impl) {
                int minThreads = Integer.getInteger("minThreads", 1);
                int maxThreads = Integer.getInteger("maxThreads", LockServiceMicroBenchmark.cores() * 2);
                int iterations = Integer.getInteger("iterations", 100);
                int lockCount = Integer.getInteger("lockCount", 100000);
                for (int threads = minThreads; threads <= maxThreads; ++threads) {
                    System.out.printf("=== %s / %s - %s threads ===%n", new Object[]{this, impl, threads});
                    LockServiceMicroBenchmark.executeUncontended(impl, threads, iterations, lockCount, true);
                }
            }
        }
        ,
        HANDOVER{

            @Override
            void execute(Implementation impl) {
                int minThreads = Integer.getInteger("minThreads", 1);
                int maxThreads = Integer.getInteger("maxThreads", LockServiceMicroBenchmark.cores() * 2);
                int iterations = Integer.getInteger("iterations", 100);
                int lockCount = Integer.getInteger("lockCount", 100000);
                for (int threads = minThreads; threads <= maxThreads; ++threads) {
                    System.out.printf("=== %s / %s - %s threads ===%n", new Object[]{this, impl, threads});
                    LockServiceMicroBenchmark.executeHandover(impl, threads, iterations, lockCount);
                }
            }
        };


        abstract void execute(Implementation var1);
    }
}

