/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.pagecache;

import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.Rule;
import org.junit.Test;
import org.neo4j.graphdb.factory.GraphDatabaseSettings;
import org.neo4j.helpers.collection.MapUtil;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.io.pagecache.PageCache;
import org.neo4j.io.pagecache.PageSwapperFactory;
import org.neo4j.io.pagecache.impl.SingleFilePageSwapperFactory;
import org.neo4j.io.pagecache.monitoring.PageCacheMonitor;
import org.neo4j.kernel.configuration.Config;
import org.neo4j.kernel.impl.pagecache.LifecycledPageCache;
import org.neo4j.kernel.impl.util.JobScheduler;
import org.neo4j.kernel.impl.util.Neo4jJobScheduler;
import org.neo4j.kernel.lifecycle.LifeSupport;
import org.neo4j.test.EphemeralFileSystemRule;

public class LifecycledPageCacheTest {
    @Rule
    public EphemeralFileSystemRule fsRule = new EphemeralFileSystemRule();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void shouldUseConfiguredPageSizeAndFitAsManyPagesAsItCan() throws Throwable {
        Config config = new Config();
        config.applyChanges(MapUtil.stringMap((String[])new String[]{GraphDatabaseSettings.mapped_memory_page_size.name(), "4096", GraphDatabaseSettings.mapped_memory_total_size.name(), Integer.toString(65536)}));
        LifeSupport life = new LifeSupport();
        SingleFilePageSwapperFactory swapperFactory = new SingleFilePageSwapperFactory((FileSystemAbstraction)this.fsRule.get());
        Neo4jJobScheduler scheduler = (Neo4jJobScheduler)life.add((Object)new Neo4jJobScheduler());
        PageCache cache = (PageCache)life.add((Object)new LifecycledPageCache((PageSwapperFactory)swapperFactory, (JobScheduler)scheduler, config, PageCacheMonitor.NULL));
        life.start();
        try {
            MatcherAssert.assertThat((Object)cache.pageSize(), (Matcher)CoreMatchers.equalTo((Object)4096));
            MatcherAssert.assertThat((Object)cache.maxCachedPages(), (Matcher)CoreMatchers.equalTo((Object)16));
        }
        finally {
            life.shutdown();
        }
    }
}

