/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.recovery;

import java.io.File;
import org.hamcrest.MatcherAssert;
import org.junit.Rule;
import org.junit.Test;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Transaction;
import org.neo4j.graphdb.mockfs.EphemeralFileSystemAbstraction;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.kernel.impl.store.id.IdGeneratorImpl;
import org.neo4j.kernel.impl.transaction.LogMatchers;
import org.neo4j.kernel.impl.transaction.command.Command;
import org.neo4j.test.EphemeralFileSystemRule;
import org.neo4j.test.TestGraphDatabaseFactory;

public class KernelRecoveryTest {
    @Rule
    public EphemeralFileSystemRule fsRule = new EphemeralFileSystemRule();
    private final File storeDir = new File("dir").getAbsoluteFile();

    @Test
    public void shouldHandleWritesProperlyAfterRecovery() throws Exception {
        EphemeralFileSystemAbstraction fs = this.fsRule.get();
        GraphDatabaseService db = this.newDB(fs);
        long node1 = this.createNode(db);
        EphemeralFileSystemAbstraction crashedFs = fs.snapshot();
        db.shutdown();
        db = this.newDB(crashedFs);
        long node2 = this.createNode(db);
        db.shutdown();
        File logFile = new File(this.storeDir, "neostore.transaction.db.0");
        MatcherAssert.assertThat(LogMatchers.logEntries((FileSystemAbstraction)crashedFs, logFile), LogMatchers.containsExactly(LogMatchers.startEntry(-1, -1), LogMatchers.commandEntry(node1, Command.NodeCommand.class), LogMatchers.commitEntry(2L), LogMatchers.startEntry(-1, -1), LogMatchers.commandEntry(node2, Command.NodeCommand.class), LogMatchers.commitEntry(3L)));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void shouldBeAbleToApplyRecoveredTransactionsEvenIfIdGeneratorOpenedFine() throws Exception {
        EphemeralFileSystemAbstraction fs = this.fsRule.get();
        GraphDatabaseService db = this.newDB(fs);
        long node1 = this.createNode(db);
        long node2 = this.createNode(db);
        this.deleteNode(db, node2);
        EphemeralFileSystemAbstraction crashedFs = fs.snapshot();
        db.shutdown();
        this.repairIdGenerator((FileSystemAbstraction)crashedFs, new File(this.storeDir, "neostore.nodestore.db.id"));
        db = this.newDB(crashedFs);
        try (Transaction tx = db.beginTx();){
            db.getNodeById(node1);
            tx.success();
        }
        finally {
            db.shutdown();
        }
    }

    private void deleteNode(GraphDatabaseService db, long node) {
        try (Transaction tx = db.beginTx();){
            db.getNodeById(node).delete();
            tx.success();
        }
    }

    private void repairIdGenerator(FileSystemAbstraction fs, File file) {
        fs.deleteFile(file);
        IdGeneratorImpl.createGenerator((FileSystemAbstraction)fs, (File)file, (long)1L);
    }

    private GraphDatabaseService newDB(EphemeralFileSystemAbstraction fs) {
        fs.mkdirs(this.storeDir);
        return new TestGraphDatabaseFactory().setFileSystem((FileSystemAbstraction)fs).newImpermanentDatabase(this.storeDir.getAbsolutePath());
    }

    private long createNode(GraphDatabaseService db) {
        long node1;
        try (Transaction tx = db.beginTx();){
            node1 = db.createNode().getId();
            tx.success();
        }
        return node1;
    }
}

