/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.store;

import java.io.File;
import java.io.IOException;
import java.nio.ByteBuffer;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.mockito.Mockito;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.io.fs.StoreChannel;
import org.neo4j.io.pagecache.PageCache;
import org.neo4j.kernel.DefaultIdGeneratorFactory;
import org.neo4j.kernel.IdGeneratorFactory;
import org.neo4j.kernel.IdType;
import org.neo4j.kernel.configuration.Config;
import org.neo4j.kernel.impl.store.AbstractDynamicStore;
import org.neo4j.kernel.impl.store.RecordStore;
import org.neo4j.kernel.impl.store.StoreVersionMismatchHandler;
import org.neo4j.kernel.impl.store.record.DynamicRecord;
import org.neo4j.kernel.impl.util.StringLogger;
import org.neo4j.kernel.monitoring.Monitors;
import org.neo4j.test.EphemeralFileSystemRule;
import org.neo4j.unsafe.impl.batchimport.store.BatchingPageCache;
import org.neo4j.unsafe.impl.batchimport.store.io.Monitor;

public class AbstractDynamicStoreTest {
    @Rule
    public final EphemeralFileSystemRule fsr = new EphemeralFileSystemRule();
    private final File fileName = new File("store");

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void shouldRecognizeDesignatedInUseBit() throws Exception {
        try (AbstractDynamicStore store = this.newTestableDynamicStore();){
            byte otherBitsInTheInUseByte = 0;
            for (int i = 0; i < 8; ++i) {
                this.assertRecognizesByteAsInUse(store, otherBitsInTheInUseByte);
                otherBitsInTheInUseByte = (byte)(otherBitsInTheInUseByte << 1);
                otherBitsInTheInUseByte = (byte)(otherBitsInTheInUseByte | 1);
            }
        }
    }

    private void assertRecognizesByteAsInUse(AbstractDynamicStore store, byte inUseByte) {
        Assert.assertTrue((boolean)store.isInUse((byte)(inUseByte | 0x10)));
        Assert.assertFalse((boolean)store.isInUse((byte)(inUseByte & 0xFFFFFFEF)));
    }

    private AbstractDynamicStore newTestableDynamicStore() {
        return new AbstractDynamicStore(this.fileName, new Config(), IdType.ARRAY_BLOCK, (IdGeneratorFactory)new DefaultIdGeneratorFactory(), (PageCache)new BatchingPageCache((FileSystemAbstraction)this.fsr.get(), 1000, BatchingPageCache.SYNCHRONOUS, (Monitor)Mockito.mock(Monitor.class), BatchingPageCache.Mode.UPDATE), (FileSystemAbstraction)this.fsr.get(), StringLogger.DEV_NULL, StoreVersionMismatchHandler.ALLOW_OLD_VERSION, new Monitors()){

            public void accept(RecordStore.Processor processor, DynamicRecord record) {
            }

            public String getTypeDescriptor() {
                return "TestDynamicStore";
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Before
    public void before() throws IOException {
        try (StoreChannel channel = this.fsr.get().create(this.fileName);){
            ByteBuffer buffer = ByteBuffer.allocate(4);
            buffer.putInt(60);
            buffer.flip();
            channel.write(buffer);
        }
    }
}

