/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.store;

import java.util.concurrent.CountDownLatch;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import org.junit.Assert;
import org.junit.Test;
import org.neo4j.kernel.impl.util.ArrayQueueOutOfOrderSequence;
import org.neo4j.kernel.impl.util.OutOfOrderSequence;

public class ArrayQueueOutOfOrderSequenceTest {
    @Test
    public void shouldExposeGapFreeSequenceSingleThreaded() throws Exception {
        ArrayQueueOutOfOrderSequence sequence = new ArrayQueueOutOfOrderSequence(0L, 10);
        sequence.offer(1L, 1L);
        this.assertGet((OutOfOrderSequence)sequence, 1L, 1L);
        sequence.offer(2L, 2L);
        this.assertGet((OutOfOrderSequence)sequence, 2L, 2L);
        sequence.offer(4L, 3L);
        this.assertGet((OutOfOrderSequence)sequence, 2L, 2L);
        sequence.offer(3L, 4L);
        this.assertGet((OutOfOrderSequence)sequence, 4L, 3L);
        sequence.offer(5L, 5L);
        this.assertGet((OutOfOrderSequence)sequence, 5L, 5L);
        sequence.offer(10L, 6L);
        sequence.offer(11L, 7L);
        sequence.offer(8L, 8L);
        sequence.offer(9L, 9L);
        sequence.offer(7L, 10L);
        this.assertGet((OutOfOrderSequence)sequence, 5L, 5L);
        sequence.offer(6L, 11L);
        this.assertGet((OutOfOrderSequence)sequence, 11L, 7L);
    }

    private void assertGet(OutOfOrderSequence sequence, long number, long meta) {
        long[] data = sequence.get();
        Assert.assertEquals((long)number, (long)data[0]);
        Assert.assertEquals((long)meta, (long)data[1]);
    }

    @Test
    public void shouldExtendArrayIfNeedBe() throws Exception {
        ArrayQueueOutOfOrderSequence sequence = new ArrayQueueOutOfOrderSequence(0L, 5);
        sequence.offer(3L, 0L);
        sequence.offer(2L, 1L);
        sequence.offer(5L, 2L);
        sequence.offer(4L, 3L);
        sequence.offer(6L, 4L);
        sequence.offer(1L, 5L);
        this.assertGet((OutOfOrderSequence)sequence, 6L, 4L);
    }

    @Test
    public void shouldDealWithThisScenario() throws Exception {
        ArrayQueueOutOfOrderSequence sequence = new ArrayQueueOutOfOrderSequence(0L, 5);
        Assert.assertTrue((boolean)sequence.offer(1L, 0L));
        Assert.assertFalse((boolean)sequence.offer(3L, 0L));
        Assert.assertFalse((boolean)sequence.offer(4L, 0L));
        Assert.assertTrue((boolean)sequence.offer(2L, 0L));
        Assert.assertFalse((boolean)sequence.offer(6L, 0L));
        Assert.assertTrue((boolean)sequence.offer(5L, 0L));
        Assert.assertFalse((boolean)sequence.offer(8L, 0L));
        Assert.assertFalse((boolean)sequence.offer(9L, 0L));
        Assert.assertFalse((boolean)sequence.offer(10L, 0L));
        Assert.assertFalse((boolean)sequence.offer(11L, 0L));
        Assert.assertFalse((boolean)sequence.offer(12L, 0L));
        Assert.assertFalse((boolean)sequence.offer(13L, 0L));
        Assert.assertFalse((boolean)sequence.offer(14L, 0L));
        Assert.assertTrue((boolean)sequence.offer(7L, 0L));
        this.assertGet((OutOfOrderSequence)sequence, 14L, 0L);
    }

    @Test
    public void shouldKeepItsCoolWhenMultipleThreadsAreHammeringIt() throws Exception {
        final AtomicLong numberSource = new AtomicLong();
        ArrayQueueOutOfOrderSequence sequence = new ArrayQueueOutOfOrderSequence(numberSource.get(), 5);
        final AtomicBoolean end = new AtomicBoolean();
        final CountDownLatch startSignal = new CountDownLatch(1);
        Thread[] threads = new Thread[1];
        for (int i = 0; i < threads.length; ++i) {
            threads[i] = new Thread((OutOfOrderSequence)sequence){
                final /* synthetic */ OutOfOrderSequence val$sequence;
                {
                    this.val$sequence = outOfOrderSequence;
                }

                @Override
                public void run() {
                    ArrayQueueOutOfOrderSequenceTest.this.await(startSignal);
                    while (!end.get()) {
                        long number = numberSource.incrementAndGet();
                        this.val$sequence.offer(number, number + 2L);
                    }
                }
            };
        }
        for (Thread thread : threads) {
            thread.start();
        }
        startSignal.countDown();
        while (numberSource.get() < 10000000L) {
            Thread.sleep(1L);
            Thread.yield();
        }
        end.set(true);
        for (Thread thread : threads) {
            thread.join();
        }
        long lastNumber = numberSource.get();
        this.assertGet((OutOfOrderSequence)sequence, lastNumber, lastNumber + 2L);
    }

    protected void await(CountDownLatch latch) {
        try {
            latch.await();
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
    }
}

