/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.store;

import java.util.List;
import org.junit.Assert;
import org.neo4j.kernel.impl.api.CountsAccessor;
import org.neo4j.kernel.impl.api.CountsRecordState;
import org.neo4j.kernel.impl.api.CountsVisitor;
import org.neo4j.kernel.impl.store.counts.CountsTracker;
import org.neo4j.register.Register;
import org.neo4j.register.Registers;

public class CountsOracle {
    private final CountsRecordState state = new CountsRecordState();

    public Node node(long ... labels) {
        this.state.addNode(labels);
        return new Node(labels);
    }

    public void relationship(Node start, int type, Node end) {
        this.state.addRelationship(start.labels, type, end.labels);
    }

    public void indexUpdatesAndSize(int labelId, int propertyKeyId, long updates, long size) {
        this.state.replaceIndexUpdateAndSize(labelId, propertyKeyId, updates, size);
    }

    public void indexSampling(int labelId, int propertyKeyId, long unique, long size) {
        this.state.replaceIndexSample(labelId, propertyKeyId, unique, size);
    }

    public void update(CountsAccessor target) {
        this.state.accept((CountsVisitor)new CountsAccessor.Initializer(target));
    }

    public void update(CountsOracle target) {
        this.update((CountsAccessor)target.state);
    }

    public void verify(final CountsTracker tracker) {
        List differences = this.state.verify(new CountsVisitor.Visitable(){

            public void accept(final CountsVisitor verifier) {
                tracker.accept(new CountsVisitor(){

                    public void visitNodeCount(int labelId, long count) {
                        long expected = tracker.nodeCount(labelId, Registers.newDoubleLongRegister()).readSecond();
                        Assert.assertEquals((String)"Should be able to read visited state.", (long)expected, (long)count);
                        verifier.visitNodeCount(labelId, count);
                    }

                    public void visitRelationshipCount(int startLabelId, int typeId, int endLabelId, long count) {
                        long expected = tracker.relationshipCount(startLabelId, typeId, endLabelId, Registers.newDoubleLongRegister()).readSecond();
                        Assert.assertEquals((String)"Should be able to read visited state.", (long)expected, (long)count);
                        verifier.visitRelationshipCount(startLabelId, typeId, endLabelId, count);
                    }

                    public void visitIndexCounts(int labelId, int propertyKeyId, long updates, long size) {
                        Register.DoubleLongRegister output = tracker.indexUpdatesAndSize(labelId, propertyKeyId, Registers.newDoubleLongRegister());
                        Assert.assertEquals((String)"Should be able to read visited state.", (long)output.readFirst(), (long)updates);
                        Assert.assertEquals((String)"Should be able to read visited state.", (long)output.readSecond(), (long)size);
                        verifier.visitIndexCounts(labelId, propertyKeyId, updates, size);
                    }

                    public void visitIndexSample(int labelId, int propertyKeyId, long unique, long size) {
                        Register.DoubleLongRegister output = tracker.indexSample(labelId, propertyKeyId, Registers.newDoubleLongRegister());
                        Assert.assertEquals((String)"Should be able to read visited state.", (long)output.readFirst(), (long)unique);
                        Assert.assertEquals((String)"Should be able to read visited state.", (long)output.readSecond(), (long)size);
                        verifier.visitIndexSample(labelId, propertyKeyId, unique, size);
                    }
                });
            }
        });
        if (!differences.isEmpty()) {
            StringBuilder errors = new StringBuilder().append("Counts differ in ").append(differences.size()).append(" places...");
            for (CountsRecordState.Difference difference : differences) {
                errors.append("\n\t").append(difference);
            }
            throw new AssertionError((Object)errors.toString());
        }
    }

    public static class Node {
        private final long[] labels;

        private Node(long[] labels) {
            this.labels = labels;
        }
    }
}

