/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.store;

import java.io.File;
import java.util.HashMap;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;
import org.junit.runners.Suite;
import org.neo4j.graphdb.DynamicRelationshipType;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.PropertyContainer;
import org.neo4j.graphdb.Relationship;
import org.neo4j.graphdb.RelationshipType;
import org.neo4j.graphdb.Transaction;
import org.neo4j.graphdb.factory.GraphDatabaseSettings;
import org.neo4j.graphdb.mockfs.EphemeralFileSystemAbstraction;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.kernel.DefaultIdGeneratorFactory;
import org.neo4j.kernel.IdGeneratorFactory;
import org.neo4j.kernel.configuration.Config;
import org.neo4j.kernel.impl.store.NeoStore;
import org.neo4j.kernel.impl.store.StoreFactory;
import org.neo4j.kernel.impl.util.StringLogger;
import org.neo4j.kernel.monitoring.Monitors;
import org.neo4j.test.ImpermanentGraphDatabase;
import org.neo4j.test.PageCacheRule;
import org.neo4j.test.subprocess.BreakpointTrigger;
import org.neo4j.test.subprocess.EnabledBreakpoints;
import org.neo4j.tooling.GlobalGraphOperations;

@RunWith(value=Suite.class)
@Suite.SuiteClasses(value={FailureBeforeRebuild.class})
public class IdGeneratorRebuildFailureEmulationTest {
    private FileSystem fs;
    private StoreFactory factory;
    private final String storeDir = new File("dir").getAbsolutePath();
    @Rule
    public PageCacheRule pageCacheRule = new PageCacheRule();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @BreakpointTrigger
    private void performTest() throws Exception {
        String file = this.storeDir + File.separator + Thread.currentThread().getStackTrace()[2].getMethodName().replace('_', '.');
        this.fs.deleteFile(new File(file + ".id"));
        try (NeoStore neostore = null;){
            neostore = this.factory.newNeoStore(false, false);
            this.emulateFailureOnRebuildOf(neostore);
        }
    }

    void emulateFailureOnRebuildOf(NeoStore neostore) {
        Assert.fail((String)"emulateFailureOnRebuildOf(NeoStore) must be overridden");
    }

    @Before
    public void initialize() {
        this.fs = new FileSystem();
        Database graphdb = new Database(this.storeDir);
        this.createInitialData((GraphDatabaseService)graphdb);
        graphdb.shutdown();
        HashMap<String, String> params = new HashMap<String, String>();
        params.put(GraphDatabaseSettings.rebuild_idgenerators_fast.name(), "false");
        Monitors monitors = new Monitors();
        Config config = StoreFactory.configForStoreDir((Config)new Config(params, new Class[]{GraphDatabaseSettings.class}), (File)new File(this.storeDir));
        this.factory = new StoreFactory(config, (IdGeneratorFactory)new DefaultIdGeneratorFactory(), this.pageCacheRule.getPageCache((FileSystemAbstraction)this.fs), (FileSystemAbstraction)this.fs, StringLogger.DEV_NULL, monitors);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @After
    public void verifyAndDispose() throws Exception {
        Database graphdb = null;
        try {
            graphdb = new Database(this.storeDir);
            this.verifyData((GraphDatabaseService)graphdb);
        }
        finally {
            if (graphdb != null) {
                graphdb.shutdown();
            }
            if (this.fs != null) {
                this.fs.disposeAndAssertNoOpenFiles();
            }
            this.fs = null;
        }
    }

    private void verifyData(GraphDatabaseService graphdb) {
        try (Transaction tx = graphdb.beginTx();){
            int nodecount = 0;
            for (Node node : GlobalGraphOperations.at((GraphDatabaseService)graphdb).getAllNodes()) {
                int propcount = this.readProperties((PropertyContainer)node);
                int relcount = 0;
                for (Relationship rel : node.getRelationships()) {
                    Assert.assertEquals((String)"all relationships should have 3 properties.", (long)3L, (long)this.readProperties((PropertyContainer)rel));
                    ++relcount;
                }
                Assert.assertEquals((String)"all created nodes should have 3 properties.", (long)3L, (long)propcount);
                Assert.assertEquals((String)"all created nodes should have 2 relationships.", (long)2L, (long)relcount);
                ++nodecount;
            }
            Assert.assertEquals((String)"The database should have 2 nodes.", (long)2L, (long)nodecount);
        }
    }

    private void createInitialData(GraphDatabaseService graphdb) {
        try (Transaction tx = graphdb.beginTx();){
            Node first = this.properties(graphdb.createNode());
            Node other = this.properties(graphdb.createNode());
            this.properties(first.createRelationshipTo(other, (RelationshipType)DynamicRelationshipType.withName((String)"KNOWS")));
            this.properties(other.createRelationshipTo(first, (RelationshipType)DynamicRelationshipType.withName((String)"DISTRUSTS")));
            tx.success();
        }
    }

    private <E extends PropertyContainer> E properties(E entity) {
        entity.setProperty("short thing", (Object)"short");
        entity.setProperty("long thing", (Object)"this is quite a long string, don't you think, it sure is long enough at least");
        entity.setProperty("string array", (Object)new String[]{"these are a few", "cool strings", "for your viewing pleasure"});
        return entity;
    }

    private int readProperties(PropertyContainer entity) {
        int count = 0;
        for (String key : entity.getPropertyKeys()) {
            entity.getProperty(key);
            ++count;
        }
        return count;
    }

    @EnabledBreakpoints(value={"performTest"})
    @Test
    public void neostore() throws Exception {
        this.performTest();
    }

    @EnabledBreakpoints(value={"performTest"})
    @Test
    public void neostore_nodestore_db() throws Exception {
        this.performTest();
    }

    @EnabledBreakpoints(value={"performTest"})
    @Test
    public void neostore_propertystore_db_arrays() throws Exception {
        this.performTest();
    }

    @EnabledBreakpoints(value={"performTest"})
    @Test
    public void neostore_propertystore_db() throws Exception {
        this.performTest();
    }

    @EnabledBreakpoints(value={"performTest"})
    @Test
    public void neostore_propertystore_db_index() throws Exception {
        this.performTest();
    }

    @EnabledBreakpoints(value={"performTest"})
    @Test
    public void neostore_propertystore_db_index_keys() throws Exception {
        this.performTest();
    }

    @EnabledBreakpoints(value={"performTest"})
    @Test
    public void neostore_propertystore_db_strings() throws Exception {
        this.performTest();
    }

    @EnabledBreakpoints(value={"performTest"})
    @Test
    public void neostore_relationshipstore_db() throws Exception {
        this.performTest();
    }

    @EnabledBreakpoints(value={"performTest"})
    @Test
    public void neostore_relationshiptypestore_db() throws Exception {
        this.performTest();
    }

    @EnabledBreakpoints(value={"performTest"})
    @Test
    public void neostore_relationshiptypestore_db_names() throws Exception {
        this.performTest();
    }

    private IdGeneratorRebuildFailureEmulationTest() {
        if (IdGeneratorRebuildFailureEmulationTest.class == this.getClass()) {
            throw new UnsupportedOperationException("This class is effectively abstract");
        }
    }

    private class Database
    extends ImpermanentGraphDatabase {
        public Database(String storeDir) {
            super(storeDir);
        }

        @Override
        protected FileSystemAbstraction createFileSystemAbstraction() {
            return IdGeneratorRebuildFailureEmulationTest.this.fs;
        }

        protected IdGeneratorFactory createIdGeneratorFactory() {
            return new DefaultIdGeneratorFactory();
        }
    }

    private static class FileSystem
    extends EphemeralFileSystemAbstraction {
        private FileSystem() {
        }

        void disposeAndAssertNoOpenFiles() throws Exception {
            this.assertNoOpenFiles();
            super.shutdown();
        }

        public void shutdown() {
        }
    }

    @RunWith(value=JUnit4.class)
    public static final class FailureBeforeRebuild
    extends IdGeneratorRebuildFailureEmulationTest {
        @Override
        protected void emulateFailureOnRebuildOf(NeoStore neostore) {
        }
    }
}

