/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.store;

import java.util.Arrays;
import org.hamcrest.Matcher;
import org.hamcrest.core.IsEqual;
import org.junit.Assert;
import org.junit.Test;
import org.neo4j.helpers.collection.Iterables;
import org.neo4j.kernel.impl.store.record.DynamicRecord;
import org.neo4j.kernel.impl.store.record.NodeRecord;

public class NodeRecordTest {
    @Test
    public void cloneShouldProduceExactCopy() throws Exception {
        long relId = 1337L;
        long propId = 1338L;
        long inlinedLabels = 12L;
        NodeRecord node = new NodeRecord(1L, false, relId, propId);
        node.setLabelField(inlinedLabels, Arrays.asList(new DynamicRecord(1L), new DynamicRecord(2L)));
        node.setInUse(true);
        NodeRecord clone = node.clone();
        Assert.assertEquals((Object)node.inUse(), (Object)clone.inUse());
        Assert.assertEquals((long)node.getLabelField(), (long)clone.getLabelField());
        Assert.assertEquals((long)node.getNextProp(), (long)clone.getNextProp());
        Assert.assertEquals((long)node.getNextRel(), (long)clone.getNextRel());
        Assert.assertThat((Object)clone.getDynamicLabelRecords(), (Matcher)IsEqual.equalTo((Object)node.getDynamicLabelRecords()));
    }

    @Test
    public void shouldListLabelRecordsInUse() throws Exception {
        NodeRecord node = new NodeRecord(1L, false, -1L, -1L);
        long inlinedLabels = 12L;
        DynamicRecord dynamic1 = DynamicRecord.dynamicRecord((long)1L, (boolean)true);
        DynamicRecord dynamic2 = DynamicRecord.dynamicRecord((long)2L, (boolean)true);
        DynamicRecord dynamic3 = DynamicRecord.dynamicRecord((long)3L, (boolean)true);
        node.setLabelField(inlinedLabels, Arrays.asList(dynamic1, dynamic2, dynamic3));
        dynamic3.setInUse(false);
        Iterable usedRecords = node.getUsedDynamicLabelRecords();
        Assert.assertThat((Object)Iterables.toList((Iterable)usedRecords), (Matcher)IsEqual.equalTo(Arrays.asList(dynamic1, dynamic2)));
    }
}

