/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.store;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.HashMap;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.ClassRule;
import org.junit.Ignore;
import org.junit.Rule;
import org.junit.Test;
import org.neo4j.graphdb.factory.GraphDatabaseSettings;
import org.neo4j.helpers.collection.MapUtil;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.io.fs.FileUtils;
import org.neo4j.kernel.DefaultIdGeneratorFactory;
import org.neo4j.kernel.IdGeneratorFactory;
import org.neo4j.kernel.configuration.Config;
import org.neo4j.kernel.impl.store.CommonAbstractStore;
import org.neo4j.kernel.impl.store.NeoStore;
import org.neo4j.kernel.impl.store.NodeStore;
import org.neo4j.kernel.impl.store.NotCurrentStoreVersionException;
import org.neo4j.kernel.impl.store.StoreFactory;
import org.neo4j.kernel.impl.store.StoreVersionMismatchHandler;
import org.neo4j.kernel.impl.storemigration.StoreMigrator;
import org.neo4j.kernel.impl.util.StringLogger;
import org.neo4j.kernel.monitoring.Monitors;
import org.neo4j.test.EphemeralFileSystemRule;
import org.neo4j.test.PageCacheRule;

public class StoreVersionTest {
    @Rule
    public EphemeralFileSystemRule fs = new EphemeralFileSystemRule();
    private final File outputDir = new File("target/var/" + StoreVersionTest.class.getSimpleName()).getAbsoluteFile();
    private final Config config = StoreFactory.configForStoreDir((Config)new Config(MapUtil.stringMap((String[])new String[0]), new Class[]{GraphDatabaseSettings.class}), (File)this.outputDir);
    private final Monitors monitors = new Monitors();
    @ClassRule
    public static PageCacheRule pageCacheRule = new PageCacheRule();

    @Test
    public void allStoresShouldHaveTheCurrentVersionIdentifier() {
        CommonAbstractStore[] stores;
        StoreFactory sf = new StoreFactory(this.config, (IdGeneratorFactory)new DefaultIdGeneratorFactory(), pageCacheRule.getPageCache((FileSystemAbstraction)this.fs.get()), (FileSystemAbstraction)this.fs.get(), StringLogger.DEV_NULL, this.monitors);
        NeoStore neoStore = sf.newNeoStore(true, false);
        for (CommonAbstractStore store : stores = new CommonAbstractStore[]{neoStore.getNodeStore(), neoStore.getRelationshipStore(), neoStore.getRelationshipTypeTokenStore(), neoStore.getPropertyStore(), neoStore.getPropertyKeyTokenStore()}) {
            Assert.assertThat((Object)store.getTypeAndVersionDescriptor(), (Matcher)CoreMatchers.containsString((String)"v0.A.4"));
        }
        neoStore.close();
    }

    @Test
    @Ignore
    public void shouldFailToCreateAStoreContainingOldVersionNumber() throws IOException {
        URL legacyStoreResource = StoreMigrator.class.getResource("legacystore/exampledb/neostore.nodestore.db");
        File workingFile = new File(this.outputDir, "neostore.nodestore.db");
        FileUtils.copyFile((File)new File(legacyStoreResource.getFile()), (File)workingFile);
        Config config = new Config(new HashMap(), new Class[]{GraphDatabaseSettings.class});
        try {
            Monitors monitors = new Monitors();
            new NodeStore(workingFile, config, (IdGeneratorFactory)new DefaultIdGeneratorFactory(), pageCacheRule.getPageCache((FileSystemAbstraction)this.fs.get()), (FileSystemAbstraction)this.fs.get(), StringLogger.DEV_NULL, null, StoreVersionMismatchHandler.FORCE_CURRENT_VERSION, monitors);
            Assert.fail((String)"Should have thrown exception");
        }
        catch (NotCurrentStoreVersionException e) {
            // empty catch block
        }
    }

    @Test
    public void neoStoreHasCorrectStoreVersionField() {
        StoreFactory sf = new StoreFactory(this.config, (IdGeneratorFactory)new DefaultIdGeneratorFactory(), pageCacheRule.getPageCache((FileSystemAbstraction)this.fs.get()), (FileSystemAbstraction)this.fs.get(), StringLogger.DEV_NULL, this.monitors);
        NeoStore neoStore = sf.newNeoStore(true, false);
        Assert.assertEquals((Object)"v0.A.4", (Object)NeoStore.versionLongToString((long)neoStore.getStoreVersion()));
        Assert.assertEquals((Object)"v0.A.4", (Object)NeoStore.versionLongToString((long)NeoStore.getRecord((FileSystemAbstraction)this.fs.get(), (File)new File(this.outputDir, "neostore"), (NeoStore.Position)NeoStore.Position.STORE_VERSION)));
        neoStore.close();
    }

    @Test
    public void testProperEncodingDecodingOfVersionString() {
        String[] toTest;
        for (String string : toTest = new String[]{"123", "foo", "0.9.9", "v0.A.0", "bar", "chris", "1234567"}) {
            Assert.assertEquals((Object)string, (Object)NeoStore.versionLongToString((long)NeoStore.versionStringToLong((String)string)));
        }
    }
}

