/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.store;

import java.io.File;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.ClassRule;
import org.junit.Test;
import org.neo4j.graphdb.factory.GraphDatabaseSettings;
import org.neo4j.helpers.Settings;
import org.neo4j.helpers.collection.MapUtil;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.io.pagecache.PageCache;
import org.neo4j.kernel.DefaultFileSystemAbstraction;
import org.neo4j.kernel.DefaultIdGeneratorFactory;
import org.neo4j.kernel.IdGeneratorFactory;
import org.neo4j.kernel.configuration.Config;
import org.neo4j.kernel.impl.store.CommonAbstractStore;
import org.neo4j.kernel.impl.store.NodeStore;
import org.neo4j.kernel.impl.store.StoreFactory;
import org.neo4j.kernel.impl.store.StoreVersionMismatchHandler;
import org.neo4j.kernel.impl.store.record.NodeRecord;
import org.neo4j.kernel.impl.util.StringLogger;
import org.neo4j.kernel.monitoring.Monitors;
import org.neo4j.test.PageCacheRule;
import org.neo4j.test.TargetDirectory;

public class TestGrowingFileMemoryMapping {
    private static final int MEGA = 0x100000;
    @ClassRule
    public static PageCacheRule pageCacheRule = new PageCacheRule();

    @Test
    public void shouldGrowAFileWhileContinuingToMemoryMapNewRegions() throws Exception {
        long startingId;
        Assume.assumeTrue((!Settings.osIsWindows() ? 1 : 0) != 0);
        int NUMBER_OF_RECORDS = 1000000;
        File storeDir = TargetDirectory.forTest(this.getClass()).makeGraphDbDir();
        Config config = new Config(MapUtil.stringMap((String[])new String[]{GraphDatabaseSettings.mapped_memory_total_size.name(), this.mmapSize(NUMBER_OF_RECORDS, 15), CommonAbstractStore.Configuration.store_dir.name(), storeDir.getPath()}), new Class[]{NodeStore.Configuration.class});
        DefaultIdGeneratorFactory idGeneratorFactory = new DefaultIdGeneratorFactory();
        Monitors monitors = new Monitors();
        DefaultFileSystemAbstraction fileSystemAbstraction = new DefaultFileSystemAbstraction();
        PageCache pageCache = pageCacheRule.getPageCache((FileSystemAbstraction)fileSystemAbstraction, config);
        StoreFactory storeFactory = new StoreFactory(config, (IdGeneratorFactory)idGeneratorFactory, pageCache, (FileSystemAbstraction)fileSystemAbstraction, StringLogger.DEV_NULL, monitors);
        File fileName = new File(storeDir, "neostore.nodestore.db");
        storeFactory.createEmptyStore(fileName, StoreFactory.buildTypeDescriptorAndVersion((String)"NodeStore"));
        NodeStore nodeStore = new NodeStore(fileName, config, (IdGeneratorFactory)idGeneratorFactory, pageCache, (FileSystemAbstraction)fileSystemAbstraction, StringLogger.DEV_NULL, null, StoreVersionMismatchHandler.FORCE_CURRENT_VERSION, monitors);
        int iterations = 2 * NUMBER_OF_RECORDS;
        long nodeId = startingId = nodeStore.nextId();
        for (int i = 0; i < iterations; ++i) {
            NodeRecord record = new NodeRecord(nodeId, false, (long)i, 0L);
            record.setInUse(true);
            nodeStore.updateRecord(record);
            nodeId = nodeStore.nextId();
        }
        NodeRecord record = new NodeRecord(0L, false, 0L, 0L);
        for (int i = 0; i < iterations; ++i) {
            record.setId(startingId + (long)i);
            nodeStore.getRecord((long)i, record);
            Assert.assertTrue((String)("record[" + i + "] should be in use"), (boolean)record.inUse());
            Assert.assertThat((String)("record[" + i + "] should have nextRelId of " + i), (Object)record.getNextRel(), (Matcher)Matchers.is((Object)i));
        }
        nodeStore.close();
    }

    private String mmapSize(int numberOfRecords, int recordSize) {
        int bytes = numberOfRecords * recordSize;
        if (bytes < 0x100000) {
            throw new IllegalArgumentException("too few records: " + numberOfRecords);
        }
        return bytes / 0x100000 + "M";
    }
}

