/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.store;

import java.io.File;
import java.io.IOException;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TestName;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Transaction;
import org.neo4j.graphdb.factory.GraphDatabaseFactory;
import org.neo4j.helpers.Settings;
import org.neo4j.io.fs.FileLock;
import org.neo4j.io.fs.StoreChannel;
import org.neo4j.kernel.DefaultFileSystemAbstraction;
import org.neo4j.test.TargetDirectory;

public class TestOsSpecificLocks {
    private File path;
    @Rule
    public TestName name = new TestName();

    @Before
    public void doBefore() {
        this.path = TargetDirectory.forTest(this.getClass()).cleanDirectory(this.name.getMethodName());
    }

    @Test
    public void sanityCheck() throws Exception {
        Assume.assumeTrue((boolean)Settings.osIsWindows());
        DefaultFileSystemAbstraction fs = new DefaultFileSystemAbstraction();
        File fileName = new File(this.path, "store_lock");
        StoreChannel channel = fs.open(fileName, "rw");
        FileLock lock = fs.tryLock(fileName, channel);
        Assert.assertTrue((boolean)new File(this.path, "lock").exists());
        try {
            fs.tryLock(fileName, channel);
            Assert.fail((String)"Should have thrown IOException");
        }
        catch (IOException e) {
            // empty catch block
        }
        StoreChannel tempChannel = fs.open(new File(fileName.getPath() + "1"), "rw");
        FileLock tempLock = fs.tryLock(new File(fileName.getPath() + "1"), tempChannel);
        Assert.assertNotNull((Object)tempLock);
        tempLock.release();
        tempChannel.close();
        lock.release();
        Assert.assertFalse((boolean)new File(this.path, "lock").exists());
        fs.tryLock(fileName, channel).release();
        Assert.assertFalse((boolean)new File(this.path, "lock").exists());
    }

    @Test
    public void testDatabaseLocking() {
        Assume.assumeTrue((boolean)Settings.osIsWindows());
        GraphDatabaseService db = new GraphDatabaseFactory().newEmbeddedDatabase(this.path.getPath());
        Transaction tx = db.beginTx();
        db.createNode();
        tx.success();
        tx.finish();
        Assert.assertTrue((boolean)new File(this.path, "lock").exists());
        try {
            new GraphDatabaseFactory().newEmbeddedDatabase(this.path.getPath());
            Assert.fail((String)"Should not be able to start up another db in the same dir");
        }
        catch (Exception exception) {
            // empty catch block
        }
        db.shutdown();
    }
}

