/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.store;

import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.channels.FileChannel;
import java.util.Collections;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.neo4j.graphdb.factory.GraphDatabaseSettings;
import org.neo4j.helpers.collection.MapUtil;
import org.neo4j.io.fs.DefaultFileSystemAbstraction;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.io.pagecache.PageCache;
import org.neo4j.kernel.DefaultIdGeneratorFactory;
import org.neo4j.kernel.IdGeneratorFactory;
import org.neo4j.kernel.IdType;
import org.neo4j.kernel.configuration.Config;
import org.neo4j.kernel.impl.AbstractNeo4jTestCase;
import org.neo4j.kernel.impl.store.AbstractStore;
import org.neo4j.kernel.impl.store.StoreFactory;
import org.neo4j.kernel.impl.store.StoreVersionMismatchHandler;
import org.neo4j.kernel.impl.util.StringLogger;
import org.neo4j.kernel.monitoring.Monitors;
import org.neo4j.test.PageCacheRule;

public class TestStore {
    public static IdGeneratorFactory ID_GENERATOR_FACTORY = new DefaultIdGeneratorFactory();
    public static FileSystemAbstraction FILE_SYSTEM = new DefaultFileSystemAbstraction();
    @Rule
    public final PageCacheRule pageCacheRule = new PageCacheRule();
    private PageCache pageCache;

    @Before
    public void setUp() {
        this.pageCache = this.pageCacheRule.getPageCache(FILE_SYSTEM);
    }

    private File path() {
        String path = AbstractNeo4jTestCase.getStorePath("teststore");
        File file = new File(path);
        file.mkdirs();
        return file;
    }

    private File file(String name) {
        return new File(this.path(), name);
    }

    private File storeFile() {
        return this.file("testStore.db");
    }

    private File storeIdFile() {
        return this.file("testStore.db.id");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testCreateStore() throws IOException {
        try {
            try {
                Store.createStore(null, this.pageCache);
                Assert.fail((String)"Null fileName should throw exception");
            }
            catch (IllegalArgumentException e) {
                // empty catch block
            }
            Store store = Store.createStore(this.storeFile(), this.pageCache);
            try {
                Store.createStore(this.storeFile(), this.pageCache);
                Assert.fail((String)"Creating existing store should throw exception");
            }
            catch (IllegalStateException illegalStateException) {
                // empty catch block
            }
            store.close();
        }
        finally {
            this.deleteBothFiles();
        }
    }

    private void deleteBothFiles() {
        File file = this.storeFile();
        if (file.exists()) {
            Assert.assertTrue((boolean)file.delete());
        }
        if ((file = this.storeIdFile()).exists()) {
            Assert.assertTrue((boolean)file.delete());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testStickyStore() throws IOException {
        try {
            Store.createStore(this.storeFile(), this.pageCache).close();
            FileChannel fileChannel = new RandomAccessFile(this.storeFile(), "rw").getChannel();
            fileChannel.truncate(fileChannel.size() - 2L);
            fileChannel.close();
            Store store = new Store(this.storeFile(), this.pageCache);
            store.makeStoreOk();
            store.close();
        }
        finally {
            this.deleteBothFiles();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testClose() throws IOException {
        try {
            Store store = Store.createStore(this.storeFile(), this.pageCache);
            store.close();
        }
        finally {
            this.deleteBothFiles();
        }
    }

    private static class Store
    extends AbstractStore {
        private static final Config config = new Config(MapUtil.stringMap((String[])new String[]{"store_dir", "target/var/teststore"}), new Class[]{GraphDatabaseSettings.class});
        public static final String TYPE_DESCRIPTOR = "TestVersion";
        private static final int RECORD_SIZE = 1;

        public Store(File fileName, PageCache pageCache) throws IOException {
            super(fileName, config, IdType.NODE, ID_GENERATOR_FACTORY, pageCache, FILE_SYSTEM, StringLogger.DEV_NULL, StoreVersionMismatchHandler.FORCE_CURRENT_VERSION, new Monitors());
        }

        public int getRecordSize() {
            return 1;
        }

        public String getTypeDescriptor() {
            return TYPE_DESCRIPTOR;
        }

        public static Store createStore(File fileName, PageCache pageCache) throws IOException {
            new StoreFactory(new Config(Collections.emptyMap(), new Class[]{GraphDatabaseSettings.class}), ID_GENERATOR_FACTORY, pageCache, FILE_SYSTEM, StringLogger.DEV_NULL, new Monitors()).createEmptyStore(fileName, Store.buildTypeDescriptorAndVersion((String)TYPE_DESCRIPTOR));
            return new Store(fileName, pageCache);
        }

        protected void rebuildIdGenerator() {
        }
    }
}

