/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.store;

import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Ignore;
import org.junit.Rule;
import org.junit.Test;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.TransactionFailureException;
import org.neo4j.graphdb.factory.GraphDatabaseFactory;
import org.neo4j.graphdb.factory.GraphDatabaseSettings;
import org.neo4j.helpers.UTF8;
import org.neo4j.helpers.collection.IteratorUtil;
import org.neo4j.helpers.collection.MapUtil;
import org.neo4j.io.fs.DefaultFileSystemAbstraction;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.io.pagecache.PageCache;
import org.neo4j.kernel.DefaultIdGeneratorFactory;
import org.neo4j.kernel.IdGeneratorFactory;
import org.neo4j.kernel.IdType;
import org.neo4j.kernel.configuration.Config;
import org.neo4j.kernel.impl.AbstractNeo4jTestCase;
import org.neo4j.kernel.impl.store.DynamicStringStore;
import org.neo4j.kernel.impl.store.NotCurrentStoreVersionException;
import org.neo4j.kernel.impl.store.PropertyStore;
import org.neo4j.kernel.impl.store.RelationshipTypeTokenStore;
import org.neo4j.kernel.impl.store.StoreVersionMismatchHandler;
import org.neo4j.kernel.impl.store.id.IdGenerator;
import org.neo4j.kernel.impl.store.id.IdGeneratorImpl;
import org.neo4j.kernel.impl.store.record.DynamicRecord;
import org.neo4j.kernel.impl.store.record.RelationshipTypeTokenRecord;
import org.neo4j.kernel.impl.store.record.TokenRecord;
import org.neo4j.kernel.impl.util.StringLogger;
import org.neo4j.kernel.monitoring.Monitors;
import org.neo4j.test.PageCacheRule;
import org.neo4j.unsafe.batchinsert.BatchInserters;

@Ignore
public class UpgradeStoreIT {
    private static final String PATH = "target/var/upgrade";
    @Rule
    public final PageCacheRule pageCacheRule = new PageCacheRule();

    @Before
    public void doBefore() {
        AbstractNeo4jTestCase.deleteFileOrDirectory(PATH);
    }

    private File path(int i) {
        return new File(PATH, "" + i);
    }

    @Test
    public void makeSureStoreWithTooManyRelationshipTypesCannotBeUpgraded() throws Exception {
        File path = this.path(0);
        new GraphDatabaseFactory().newEmbeddedDatabase(path.getPath()).shutdown();
        this.createManyRelationshipTypes(path, 65536);
        this.assertCannotStart(path, "Shouldn't be able to upgrade with that many types set");
    }

    @Test
    public void makeSureStoreWithDecentAmountOfRelationshipTypesCanBeUpgraded() throws Exception {
        File path = this.path(1);
        new GraphDatabaseFactory().newEmbeddedDatabase(path.getPath()).shutdown();
        this.createManyRelationshipTypes(path, 65535);
        this.assertCanStart(path);
    }

    @Test(expected=TransactionFailureException.class)
    public void makeSureStoreWithTooBigStringBlockSizeCannotBeCreated() throws Exception {
        new GraphDatabaseFactory().newEmbeddedDatabaseBuilder(this.path(2).getPath()).setConfig(GraphDatabaseSettings.string_block_size, "65536").newGraphDatabase().shutdown();
    }

    @Test
    public void makeSureStoreWithDecentStringBlockSizeCanBeCreated() throws Exception {
        new GraphDatabaseFactory().newEmbeddedDatabaseBuilder(this.path(3).getPath()).setConfig(GraphDatabaseSettings.string_block_size, "65535").newGraphDatabase().shutdown();
    }

    @Test(expected=TransactionFailureException.class)
    public void makeSureStoreWithTooBigArrayBlockSizeCannotBeCreated() throws Exception {
        new GraphDatabaseFactory().newEmbeddedDatabaseBuilder(this.path(4).getPath()).setConfig(GraphDatabaseSettings.array_block_size, "65536").newGraphDatabase().shutdown();
    }

    @Test
    public void makeSureStoreWithDecentArrayBlockSizeCanBeCreated() throws Exception {
        new GraphDatabaseFactory().newEmbeddedDatabaseBuilder(this.path(5).getPath()).setConfig(GraphDatabaseSettings.array_block_size, "65535").newGraphDatabase().shutdown();
    }

    @Test
    public void makeSureStoreWithTooBigStringBlockSizeCannotBeUpgraded() throws Exception {
        File path = this.path(6);
        new GraphDatabaseFactory().newEmbeddedDatabase(path.getPath()).shutdown();
        this.setBlockSize(new File(path, "neostore.propertystore.db.strings"), 65536, "StringPropertyStore v0.9.5");
        this.assertCannotStart(path, "Shouldn't be able to upgrade with block size that big");
    }

    @Test
    public void makeSureStoreWithDecentStringBlockSizeCanBeUpgraded() throws Exception {
        File path = this.path(7);
        new GraphDatabaseFactory().newEmbeddedDatabase(path.getPath()).shutdown();
        this.setBlockSize(new File(path, "neostore.propertystore.db.strings"), 65535, "StringPropertyStore v0.9.5");
        this.assertCanStart(path);
    }

    @Test
    public void makeSureStoreWithTooBigArrayBlockSizeCannotBeUpgraded() throws Exception {
        File path = this.path(8);
        new GraphDatabaseFactory().newEmbeddedDatabase(path.getPath()).shutdown();
        this.setBlockSize(new File(path, "neostore.propertystore.db.arrays"), 65536, "ArrayPropertyStore v0.9.5");
        this.assertCannotStart(path, "Shouldn't be able to upgrade with block size that big");
    }

    @Test
    public void makeSureStoreWithDecentArrayBlockSizeCanBeUpgraded() throws Exception {
        File path = this.path(9);
        new GraphDatabaseFactory().newEmbeddedDatabase(path.getPath()).shutdown();
        this.setBlockSize(new File(path, "neostore.propertystore.db.arrays"), 65535, "ArrayPropertyStore v0.9.5");
        this.assertCanStart(path);
    }

    @Test
    public void makeSureLogsAreMovedWhenUpgrading() throws Exception {
        File path = this.path(10);
        for (int i = 0; i < 3; ++i) {
            new GraphDatabaseFactory().newEmbeddedDatabaseBuilder(path.getPath()).setConfig(GraphDatabaseSettings.keep_logical_logs, "true").newGraphDatabase().shutdown();
        }
        this.setOlderNeoStoreVersion(path);
        new GraphDatabaseFactory().newEmbeddedDatabaseBuilder(path.getPath()).setConfig(GraphDatabaseSettings.allow_store_upgrade, "true").newGraphDatabase().shutdown();
        File oldLogDir = new File(path, "1.2-logs");
        Assert.assertTrue((boolean)oldLogDir.exists());
        Assert.assertTrue((boolean)new File(oldLogDir, "neostore.transaction.db.0").exists());
        Assert.assertTrue((boolean)new File(oldLogDir, "neostore.transaction.db.1").exists());
        Assert.assertTrue((boolean)new File(oldLogDir, "neostore.transaction.db.2").exists());
        Assert.assertFalse((boolean)new File(path, "neostore.transaction.db.0").exists());
        Assert.assertFalse((boolean)new File(path, "neostore.transaction.db.1").exists());
        Assert.assertFalse((boolean)new File(path, "neostore.transaction.db.2").exists());
    }

    @Test
    public void makeSureStoreCantBeUpgradedIfNotExplicitlyToldTo() throws Exception {
        block2: {
            File path = this.path(11);
            new GraphDatabaseFactory().newEmbeddedDatabase(path.getPath()).shutdown();
            this.setOlderNeoStoreVersion(path);
            try {
                new GraphDatabaseFactory().newEmbeddedDatabase(path.getPath());
                Assert.fail((String)"Shouldn't be able to upgrade if not told to");
            }
            catch (TransactionFailureException e) {
                if (e.getCause() instanceof NotCurrentStoreVersionException) break block2;
                throw e;
            }
        }
    }

    @Test
    public void makeSureStoreCantBeUpgradedIfNotExplicitlyToldTo2() throws Exception {
        block2: {
            File path = this.path(12);
            new GraphDatabaseFactory().newEmbeddedDatabase(path.getPath()).shutdown();
            this.setOlderNeoStoreVersion(path);
            try {
                new GraphDatabaseFactory().newEmbeddedDatabaseBuilder(path.getPath()).setConfig(GraphDatabaseSettings.allow_store_upgrade, "true").newGraphDatabase().shutdown();
                Assert.fail((String)"Shouldn't be able to upgrade if not told to");
            }
            catch (TransactionFailureException e) {
                if (e.getCause() instanceof NotCurrentStoreVersionException) break block2;
                throw e;
            }
        }
    }

    @Test
    public void makeSureStoreCanBeUpgradedIfExplicitlyToldTo() throws Exception {
        File path = this.path(13);
        new GraphDatabaseFactory().newEmbeddedDatabase(path.getPath()).shutdown();
        this.setOlderNeoStoreVersion(path);
        new GraphDatabaseFactory().newEmbeddedDatabaseBuilder(path.getPath()).setConfig(GraphDatabaseSettings.allow_store_upgrade, "true").newGraphDatabase().shutdown();
    }

    @Test
    public void makeSureStoreCantBeUpgradedByBatchInserterEvenIfExplicitlyToldTo() throws Exception {
        File path = this.path(14);
        new GraphDatabaseFactory().newEmbeddedDatabase(path.getPath()).shutdown();
        this.setOlderNeoStoreVersion(path);
        try {
            BatchInserters.inserter((String)path.getPath(), (Map)MapUtil.stringMap((String[])new String[]{GraphDatabaseSettings.allow_store_upgrade.name(), "true"}));
            Assert.fail((String)"Shouldn't be able to upgrade with batch inserter");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void assertCannotStart(File path, String failMessage) {
        GraphDatabaseService db = null;
        try {
            db = new GraphDatabaseFactory().newEmbeddedDatabase(path.getPath());
            Assert.fail((String)failMessage);
        }
        catch (TransactionFailureException e) {
            if (!(e.getCause() instanceof NotCurrentStoreVersionException)) {
                throw e;
            }
        }
        finally {
            if (db != null) {
                db.shutdown();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void assertCanStart(File path) {
        GraphDatabaseService db = null;
        try {
            db = new GraphDatabaseFactory().newEmbeddedDatabase(path.getPath());
        }
        finally {
            if (db != null) {
                db.shutdown();
            }
        }
    }

    private void setOlderNeoStoreVersion(File path) throws IOException {
        String oldVersion = "NeoStore v0.9.6";
        FileChannel channel = new RandomAccessFile(new File(path, "neostore"), "rw").getChannel();
        channel.position(channel.size() - (long)UTF8.encode((String)oldVersion).length);
        ByteBuffer buffer = ByteBuffer.wrap(UTF8.encode((String)oldVersion));
        channel.write(buffer);
        channel.close();
    }

    private void setBlockSize(File file, int blockSize, String oldVersionToSet) throws IOException {
        FileChannel channel = new RandomAccessFile(file, "rw").getChannel();
        ByteBuffer buffer = ByteBuffer.wrap(new byte[4]);
        buffer.putInt(blockSize + 8);
        buffer.flip();
        channel.write(buffer);
        channel.position(channel.size() - (long)UTF8.encode((String)oldVersionToSet).length);
        buffer = ByteBuffer.wrap(UTF8.encode((String)oldVersionToSet));
        channel.write(buffer);
        channel.close();
    }

    private void createManyRelationshipTypes(File path, int numberOfTypes) {
        File fileName = new File(path, "neostore.relationshiptypestore.db");
        Monitors monitors = new Monitors();
        Config config = new Config();
        DefaultFileSystemAbstraction fs = new DefaultFileSystemAbstraction();
        PageCache pageCache = this.pageCacheRule.getPageCache((FileSystemAbstraction)fs);
        DynamicStringStore stringStore = new DynamicStringStore(new File(fileName.getPath() + ".names"), config, IdType.RELATIONSHIP_TYPE_TOKEN_NAME, (IdGeneratorFactory)new DefaultIdGeneratorFactory(), pageCache, (FileSystemAbstraction)fs, StringLogger.DEV_NULL, StoreVersionMismatchHandler.FORCE_CURRENT_VERSION, monitors);
        RelationshipTypeTokenStoreWithOneOlderVersion store = new RelationshipTypeTokenStoreWithOneOlderVersion(fileName, stringStore, monitors, (FileSystemAbstraction)fs, pageCache);
        for (int i = 0; i < numberOfTypes; ++i) {
            String name = "type" + i;
            RelationshipTypeTokenRecord record = new RelationshipTypeTokenRecord(i);
            record.setCreated();
            record.setInUse(true);
            Collection typeRecords = store.allocateNameRecords(PropertyStore.encodeString((String)name));
            record.setNameId((int)((DynamicRecord)IteratorUtil.first((Iterable)typeRecords)).getId());
            record.addNameRecords((Iterable)typeRecords);
            store.setHighId(store.getHighId() + 1L);
            store.updateRecord((TokenRecord)record);
        }
        store.close();
    }

    private static class NoLimitIdGeneratorFactory
    implements IdGeneratorFactory {
        private final Map<IdType, IdGenerator> generators = new HashMap<IdType, IdGenerator>();

        private NoLimitIdGeneratorFactory() {
        }

        public IdGenerator open(FileSystemAbstraction fs, File fileName, int grabSize, IdType idType, long highId) {
            IdGeneratorImpl generator = new IdGeneratorImpl(fs, fileName, grabSize, Long.MAX_VALUE, false, highId);
            this.generators.put(idType, (IdGenerator)generator);
            return generator;
        }

        public IdGenerator get(IdType idType) {
            return this.generators.get(idType);
        }

        public void create(FileSystemAbstraction fs, File fileName, long highId) {
            IdGeneratorImpl.createGenerator((FileSystemAbstraction)fs, (File)fileName, (long)highId);
        }
    }

    private static class RelationshipTypeTokenStoreWithOneOlderVersion
    extends RelationshipTypeTokenStore {
        private static final Config config = new Config(MapUtil.stringMap((String[])new String[0]));
        private boolean versionCalled;

        public RelationshipTypeTokenStoreWithOneOlderVersion(File fileName, DynamicStringStore stringStore, Monitors monitors, FileSystemAbstraction fs, PageCache pageCache) {
            super(fileName, config, (IdGeneratorFactory)new NoLimitIdGeneratorFactory(), pageCache, fs, StringLogger.DEV_NULL, stringStore, StoreVersionMismatchHandler.FORCE_CURRENT_VERSION, monitors);
        }

        public String getTypeDescriptor() {
            if (!this.versionCalled) {
                this.versionCalled = true;
                return super.getTypeDescriptor();
            }
            return "RelationshipTypeStore v0.9.5";
        }
    }
}

