/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.store.counts;

import java.io.File;
import java.io.IOException;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.neo4j.graphdb.DynamicLabel;
import org.neo4j.graphdb.DynamicRelationshipType;
import org.neo4j.graphdb.Label;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.Relationship;
import org.neo4j.graphdb.RelationshipType;
import org.neo4j.graphdb.Transaction;
import org.neo4j.graphdb.factory.GraphDatabaseBuilder;
import org.neo4j.graphdb.factory.GraphDatabaseSettings;
import org.neo4j.graphdb.mockfs.EphemeralFileSystemAbstraction;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.io.pagecache.PageCache;
import org.neo4j.kernel.GraphDatabaseAPI;
import org.neo4j.kernel.impl.api.CountsAccessor;
import org.neo4j.kernel.impl.api.CountsRecordState;
import org.neo4j.kernel.impl.api.CountsVisitor;
import org.neo4j.kernel.impl.store.CountsComputer;
import org.neo4j.kernel.impl.store.NeoStore;
import org.neo4j.kernel.impl.store.StoreFactory;
import org.neo4j.kernel.impl.store.counts.CountsStore;
import org.neo4j.kernel.impl.store.counts.CountsTracker;
import org.neo4j.kernel.impl.store.counts.keys.CountsKey;
import org.neo4j.kernel.impl.store.counts.keys.CountsKeyFactory;
import org.neo4j.kernel.impl.util.StringLogger;
import org.neo4j.register.Register;
import org.neo4j.register.Registers;
import org.neo4j.test.EphemeralFileSystemRule;
import org.neo4j.test.PageCacheRule;
import org.neo4j.test.TargetDirectory;
import org.neo4j.test.TestGraphDatabaseFactory;

public class CountsComputerTest {
    @Rule
    public PageCacheRule pcRule = new PageCacheRule();
    @Rule
    public EphemeralFileSystemRule fsRule = new EphemeralFileSystemRule();
    @Rule
    public TargetDirectory.TestDirectory testDir = TargetDirectory.testDirForTestWithEphemeralFS((EphemeralFileSystemAbstraction)this.fsRule.get(), this.getClass());
    private FileSystemAbstraction fs;
    private File dir;
    private GraphDatabaseBuilder dbBuilder;
    private PageCache pageCache;
    private static final String COUNTS_STORE_BASE = "neostore.counts.db";

    @Test
    public void shouldCreateAnEmptyCountsStoreFromAnEmptyDatabase() throws IOException {
        GraphDatabaseAPI db = (GraphDatabaseAPI)this.dbBuilder.newGraphDatabase();
        CountsRecordState countsState = CountsComputer.computeCounts((GraphDatabaseAPI)db);
        long lastCommittedTransactionId = this.getLastTxId(db);
        db.shutdown();
        this.cleanupCountsForRebuilding();
        this.rebuildCounts(countsState, lastCommittedTransactionId);
        try (CountsStore store = CountsStore.open((FileSystemAbstraction)this.fs, (PageCache)this.pageCache, (File)this.alphaStoreFile());){
            Assert.assertEquals((long)1L, (long)store.lastTxId());
            Assert.assertEquals((long)0L, (long)store.totalRecordsStored());
        }
    }

    @Test
    public void shouldCreateACountsStoreWhenThereAreNodesInTheDB() throws IOException {
        GraphDatabaseAPI db = (GraphDatabaseAPI)this.dbBuilder.newGraphDatabase();
        try (Transaction tx = db.beginTx();){
            db.createNode(new Label[]{DynamicLabel.label((String)"A")});
            db.createNode(new Label[]{DynamicLabel.label((String)"C")});
            db.createNode(new Label[]{DynamicLabel.label((String)"D")});
            db.createNode();
            tx.success();
        }
        CountsRecordState countsState = CountsComputer.computeCounts((GraphDatabaseAPI)db);
        long lastCommittedTransactionId = this.getLastTxId(db);
        db.shutdown();
        this.cleanupCountsForRebuilding();
        this.rebuildCounts(countsState, lastCommittedTransactionId);
        try (CountsStore store = CountsStore.open((FileSystemAbstraction)this.fs, (PageCache)this.pageCache, (File)this.betaStoreFile());){
            Assert.assertEquals((long)5L, (long)store.lastTxId());
            Assert.assertEquals((long)4L, (long)store.totalRecordsStored());
            Assert.assertEquals((long)4L, (long)this.get(store, (CountsKey)CountsKeyFactory.nodeKey((int)-1)));
            Assert.assertEquals((long)1L, (long)this.get(store, (CountsKey)CountsKeyFactory.nodeKey((int)0)));
            Assert.assertEquals((long)1L, (long)this.get(store, (CountsKey)CountsKeyFactory.nodeKey((int)1)));
            Assert.assertEquals((long)1L, (long)this.get(store, (CountsKey)CountsKeyFactory.nodeKey((int)2)));
            Assert.assertEquals((long)0L, (long)this.get(store, (CountsKey)CountsKeyFactory.nodeKey((int)3)));
        }
    }

    @Test
    public void shouldCreateACountsStoreWhenThereAreUnusedNodeRecordsInTheDB() throws IOException {
        GraphDatabaseAPI db = (GraphDatabaseAPI)this.dbBuilder.newGraphDatabase();
        try (Transaction tx = db.beginTx();){
            db.createNode(new Label[]{DynamicLabel.label((String)"A")});
            db.createNode(new Label[]{DynamicLabel.label((String)"C")});
            Node node = db.createNode(new Label[]{DynamicLabel.label((String)"D")});
            db.createNode();
            node.delete();
            tx.success();
        }
        CountsRecordState countsState = CountsComputer.computeCounts((GraphDatabaseAPI)db);
        long lastCommittedTransactionId = this.getLastTxId(db);
        db.shutdown();
        this.cleanupCountsForRebuilding();
        this.rebuildCounts(countsState, lastCommittedTransactionId);
        try (CountsStore store = CountsStore.open((FileSystemAbstraction)this.fs, (PageCache)this.pageCache, (File)this.betaStoreFile());){
            Assert.assertEquals((long)5L, (long)store.lastTxId());
            Assert.assertEquals((long)3L, (long)store.totalRecordsStored());
            Assert.assertEquals((long)3L, (long)this.get(store, (CountsKey)CountsKeyFactory.nodeKey((int)-1)));
            Assert.assertEquals((long)1L, (long)this.get(store, (CountsKey)CountsKeyFactory.nodeKey((int)0)));
            Assert.assertEquals((long)1L, (long)this.get(store, (CountsKey)CountsKeyFactory.nodeKey((int)1)));
            Assert.assertEquals((long)0L, (long)this.get(store, (CountsKey)CountsKeyFactory.nodeKey((int)2)));
            Assert.assertEquals((long)0L, (long)this.get(store, (CountsKey)CountsKeyFactory.nodeKey((int)3)));
        }
    }

    @Test
    public void shouldCreateACountsStoreWhenThereAreUnusedRelationshipRecordsInTheDB() throws IOException {
        GraphDatabaseAPI db = (GraphDatabaseAPI)this.dbBuilder.newGraphDatabase();
        try (Transaction tx = db.beginTx();){
            Node nodeA = db.createNode(new Label[]{DynamicLabel.label((String)"A")});
            Node nodeC = db.createNode(new Label[]{DynamicLabel.label((String)"C")});
            Relationship rel = nodeA.createRelationshipTo(nodeC, (RelationshipType)DynamicRelationshipType.withName((String)"TYPE1"));
            nodeC.createRelationshipTo(nodeA, (RelationshipType)DynamicRelationshipType.withName((String)"TYPE2"));
            rel.delete();
            tx.success();
        }
        CountsRecordState countsState = CountsComputer.computeCounts((GraphDatabaseAPI)db);
        long lastCommittedTransactionId = this.getLastTxId(db);
        db.shutdown();
        this.cleanupCountsForRebuilding();
        this.rebuildCounts(countsState, lastCommittedTransactionId);
        try (CountsStore store = CountsStore.open((FileSystemAbstraction)this.fs, (PageCache)this.pageCache, (File)this.betaStoreFile());){
            Assert.assertEquals((long)6L, (long)store.lastTxId());
            Assert.assertEquals((long)9L, (long)store.totalRecordsStored());
            Assert.assertEquals((long)2L, (long)this.get(store, (CountsKey)CountsKeyFactory.nodeKey((int)-1)));
            Assert.assertEquals((long)1L, (long)this.get(store, (CountsKey)CountsKeyFactory.nodeKey((int)0)));
            Assert.assertEquals((long)1L, (long)this.get(store, (CountsKey)CountsKeyFactory.nodeKey((int)1)));
            Assert.assertEquals((long)0L, (long)this.get(store, (CountsKey)CountsKeyFactory.nodeKey((int)2)));
            Assert.assertEquals((long)0L, (long)this.get(store, (CountsKey)CountsKeyFactory.nodeKey((int)3)));
            Assert.assertEquals((long)0L, (long)this.get(store, (CountsKey)CountsKeyFactory.relationshipKey((int)-1, (int)0, (int)-1)));
            Assert.assertEquals((long)1L, (long)this.get(store, (CountsKey)CountsKeyFactory.relationshipKey((int)-1, (int)1, (int)-1)));
        }
    }

    @Test
    public void shouldCreateACountsStoreWhenThereAreNodesAndRelationshipsInTheDB() throws IOException {
        GraphDatabaseAPI db = (GraphDatabaseAPI)this.dbBuilder.newGraphDatabase();
        try (Transaction tx = db.beginTx();){
            Node nodeA = db.createNode(new Label[]{DynamicLabel.label((String)"A")});
            Node nodeC = db.createNode(new Label[]{DynamicLabel.label((String)"C")});
            Node nodeD = db.createNode(new Label[]{DynamicLabel.label((String)"D")});
            Node node = db.createNode();
            nodeA.createRelationshipTo(nodeD, (RelationshipType)DynamicRelationshipType.withName((String)"TYPE"));
            node.createRelationshipTo(nodeC, (RelationshipType)DynamicRelationshipType.withName((String)"TYPE2"));
            tx.success();
        }
        CountsRecordState countsState = CountsComputer.computeCounts((GraphDatabaseAPI)db);
        long lastCommittedTransactionId = this.getLastTxId(db);
        db.shutdown();
        this.cleanupCountsForRebuilding();
        this.rebuildCounts(countsState, lastCommittedTransactionId);
        try (CountsStore store = CountsStore.open((FileSystemAbstraction)this.fs, (PageCache)this.pageCache, (File)this.betaStoreFile());){
            Assert.assertEquals((long)7L, (long)store.lastTxId());
            Assert.assertEquals((long)13L, (long)store.totalRecordsStored());
            Assert.assertEquals((long)4L, (long)this.get(store, (CountsKey)CountsKeyFactory.nodeKey((int)-1)));
            Assert.assertEquals((long)1L, (long)this.get(store, (CountsKey)CountsKeyFactory.nodeKey((int)0)));
            Assert.assertEquals((long)1L, (long)this.get(store, (CountsKey)CountsKeyFactory.nodeKey((int)1)));
            Assert.assertEquals((long)1L, (long)this.get(store, (CountsKey)CountsKeyFactory.nodeKey((int)2)));
            Assert.assertEquals((long)0L, (long)this.get(store, (CountsKey)CountsKeyFactory.nodeKey((int)3)));
            Assert.assertEquals((long)2L, (long)this.get(store, (CountsKey)CountsKeyFactory.relationshipKey((int)-1, (int)-1, (int)-1)));
            Assert.assertEquals((long)1L, (long)this.get(store, (CountsKey)CountsKeyFactory.relationshipKey((int)-1, (int)0, (int)-1)));
            Assert.assertEquals((long)1L, (long)this.get(store, (CountsKey)CountsKeyFactory.relationshipKey((int)-1, (int)1, (int)-1)));
            Assert.assertEquals((long)0L, (long)this.get(store, (CountsKey)CountsKeyFactory.relationshipKey((int)-1, (int)2, (int)-1)));
            Assert.assertEquals((long)1L, (long)this.get(store, (CountsKey)CountsKeyFactory.relationshipKey((int)-1, (int)1, (int)1)));
            Assert.assertEquals((long)0L, (long)this.get(store, (CountsKey)CountsKeyFactory.relationshipKey((int)-1, (int)0, (int)1)));
        }
    }

    @Test
    public void shouldCreateACountStoreWhenDBContainsDenseNodes() throws IOException {
        GraphDatabaseAPI db = (GraphDatabaseAPI)this.dbBuilder.setConfig(GraphDatabaseSettings.dense_node_threshold, "2").newGraphDatabase();
        try (Transaction tx = db.beginTx();){
            Node nodeA = db.createNode(new Label[]{DynamicLabel.label((String)"A")});
            Node nodeC = db.createNode(new Label[]{DynamicLabel.label((String)"C")});
            Node nodeD = db.createNode(new Label[]{DynamicLabel.label((String)"D")});
            nodeA.createRelationshipTo(nodeA, (RelationshipType)DynamicRelationshipType.withName((String)"TYPE1"));
            nodeA.createRelationshipTo(nodeC, (RelationshipType)DynamicRelationshipType.withName((String)"TYPE2"));
            nodeA.createRelationshipTo(nodeD, (RelationshipType)DynamicRelationshipType.withName((String)"TYPE3"));
            nodeD.createRelationshipTo(nodeC, (RelationshipType)DynamicRelationshipType.withName((String)"TYPE4"));
            tx.success();
        }
        CountsRecordState countsState = CountsComputer.computeCounts((GraphDatabaseAPI)db);
        long lastCommittedTransactionId = this.getLastTxId(db);
        db.shutdown();
        this.cleanupCountsForRebuilding();
        this.rebuildCounts(countsState, lastCommittedTransactionId);
        try (CountsStore store = CountsStore.open((FileSystemAbstraction)this.fs, (PageCache)this.pageCache, (File)this.betaStoreFile());){
            Assert.assertEquals((long)9L, (long)store.lastTxId());
            Assert.assertEquals((long)22L, (long)store.totalRecordsStored());
            Assert.assertEquals((long)3L, (long)this.get(store, (CountsKey)CountsKeyFactory.nodeKey((int)-1)));
            Assert.assertEquals((long)1L, (long)this.get(store, (CountsKey)CountsKeyFactory.nodeKey((int)0)));
            Assert.assertEquals((long)1L, (long)this.get(store, (CountsKey)CountsKeyFactory.nodeKey((int)1)));
            Assert.assertEquals((long)1L, (long)this.get(store, (CountsKey)CountsKeyFactory.nodeKey((int)2)));
            Assert.assertEquals((long)0L, (long)this.get(store, (CountsKey)CountsKeyFactory.nodeKey((int)3)));
            Assert.assertEquals((long)4L, (long)this.get(store, (CountsKey)CountsKeyFactory.relationshipKey((int)-1, (int)-1, (int)-1)));
            Assert.assertEquals((long)1L, (long)this.get(store, (CountsKey)CountsKeyFactory.relationshipKey((int)-1, (int)0, (int)-1)));
            Assert.assertEquals((long)1L, (long)this.get(store, (CountsKey)CountsKeyFactory.relationshipKey((int)-1, (int)1, (int)-1)));
            Assert.assertEquals((long)1L, (long)this.get(store, (CountsKey)CountsKeyFactory.relationshipKey((int)-1, (int)2, (int)-1)));
            Assert.assertEquals((long)1L, (long)this.get(store, (CountsKey)CountsKeyFactory.relationshipKey((int)-1, (int)3, (int)-1)));
            Assert.assertEquals((long)0L, (long)this.get(store, (CountsKey)CountsKeyFactory.relationshipKey((int)-1, (int)4, (int)-1)));
            Assert.assertEquals((long)1L, (long)this.get(store, (CountsKey)CountsKeyFactory.relationshipKey((int)-1, (int)1, (int)1)));
            Assert.assertEquals((long)2L, (long)this.get(store, (CountsKey)CountsKeyFactory.relationshipKey((int)-1, (int)-1, (int)1)));
            Assert.assertEquals((long)3L, (long)this.get(store, (CountsKey)CountsKeyFactory.relationshipKey((int)0, (int)-1, (int)-1)));
        }
    }

    @Before
    public void setup() {
        this.fs = this.fsRule.get();
        this.dir = this.testDir.directory("dir").getAbsoluteFile();
        this.dbBuilder = new TestGraphDatabaseFactory().setFileSystem(this.fs).newImpermanentDatabaseBuilder(this.dir.getPath());
        this.pageCache = this.pcRule.getPageCache(this.fs);
    }

    private File alphaStoreFile() {
        return new File(this.dir, "neostore.counts.db.a");
    }

    private File betaStoreFile() {
        return new File(this.dir, "neostore.counts.db.b");
    }

    private long getLastTxId(GraphDatabaseAPI db) {
        return ((NeoStore)db.getDependencyResolver().resolveDependency(NeoStore.class)).getLastCommittedTransactionId();
    }

    private void cleanupCountsForRebuilding() {
        this.fs.deleteFile(this.alphaStoreFile());
        this.fs.deleteFile(this.betaStoreFile());
        CountsTracker.createEmptyCountsStore((PageCache)this.pageCache, (File)new File(this.dir, COUNTS_STORE_BASE), (String)StoreFactory.buildTypeDescriptorAndVersion((String)CountsTracker.STORE_DESCRIPTOR));
    }

    private void rebuildCounts(CountsRecordState countsState, long lastCommittedTransactionId) throws IOException {
        CountsTracker tracker = new CountsTracker(StringLogger.DEV_NULL, this.fs, this.pageCache, new File(this.dir, COUNTS_STORE_BASE));
        countsState.accept((CountsVisitor)new CountsAccessor.Initializer((CountsAccessor)tracker));
        tracker.rotate(lastCommittedTransactionId);
        tracker.close();
    }

    private long get(CountsStore store, CountsKey key) {
        Register.DoubleLongRegister value = Registers.newDoubleLongRegister();
        store.get((Comparable)key, (Object)value);
        return value.readSecond();
    }
}

