/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.store.counts;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.neo4j.graphdb.DynamicLabel;
import org.neo4j.graphdb.Label;
import org.neo4j.graphdb.Transaction;
import org.neo4j.graphdb.factory.GraphDatabaseBuilder;
import org.neo4j.graphdb.factory.GraphDatabaseSettings;
import org.neo4j.graphdb.mockfs.EphemeralFileSystemAbstraction;
import org.neo4j.helpers.Pair;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.io.pagecache.PageCache;
import org.neo4j.kernel.GraphDatabaseAPI;
import org.neo4j.kernel.impl.core.LabelTokenHolder;
import org.neo4j.kernel.impl.store.NeoStore;
import org.neo4j.kernel.impl.store.counts.CountsStore;
import org.neo4j.kernel.impl.store.counts.CountsTracker;
import org.neo4j.kernel.impl.store.counts.keys.CountsKey;
import org.neo4j.kernel.impl.store.kvstore.KeyValueRecordVisitor;
import org.neo4j.kernel.impl.store.kvstore.SortedKeyValueStore;
import org.neo4j.register.Register;
import org.neo4j.register.Registers;
import org.neo4j.test.EphemeralFileSystemRule;
import org.neo4j.test.PageCacheRule;
import org.neo4j.test.TargetDirectory;
import org.neo4j.test.TestGraphDatabaseFactory;

public class CountsRotationTest {
    private final Label A = DynamicLabel.label((String)"A");
    private final Label B = DynamicLabel.label((String)"B");
    private final Label C = DynamicLabel.label((String)"C");
    @Rule
    public PageCacheRule pcRule = new PageCacheRule();
    @Rule
    public EphemeralFileSystemRule fsRule = new EphemeralFileSystemRule();
    @Rule
    public TargetDirectory.TestDirectory testDir = TargetDirectory.testDirForTestWithEphemeralFS((EphemeralFileSystemAbstraction)this.fsRule.get(), this.getClass());
    private FileSystemAbstraction fs;
    private File dir;
    private GraphDatabaseBuilder dbBuilder;
    private PageCache pageCache;
    private static final String COUNTS_STORE_BASE = "neostore.counts.db";

    @Test
    public void shouldCreateEmptyCountsTrackerStoreWhenCreatingDatabase() throws IOException {
        GraphDatabaseAPI db = (GraphDatabaseAPI)this.dbBuilder.newGraphDatabase();
        db.shutdown();
        Assert.assertTrue((boolean)this.fs.fileExists(this.alphaStoreFile()));
        Assert.assertTrue((boolean)this.fs.fileExists(this.betaStoreFile()));
        try (CountsStore store = CountsStore.open((FileSystemAbstraction)this.fs, (PageCache)this.pageCache, (File)this.alphaStoreFile());){
            Assert.assertEquals((long)1L, (long)store.lastTxId());
            Assert.assertEquals((long)0L, (long)store.totalRecordsStored());
            Assert.assertEquals((long)0L, (long)this.allRecords((SortedKeyValueStore<CountsKey, Register.CopyableDoubleLongRegister>)store).size());
        }
        store = CountsStore.open((FileSystemAbstraction)this.fs, (PageCache)this.pageCache, (File)this.betaStoreFile());
        var3_3 = null;
        try {
            Assert.assertEquals((long)1L, (long)store.lastTxId());
            Assert.assertEquals((long)1L, (long)store.minorVersion());
            Assert.assertEquals((long)0L, (long)store.totalRecordsStored());
            Assert.assertEquals((long)0L, (long)this.allRecords((SortedKeyValueStore<CountsKey, Register.CopyableDoubleLongRegister>)store).size());
        }
        catch (Throwable throwable) {
            var3_3 = throwable;
            throw throwable;
        }
        finally {
            if (store != null) {
                if (var3_3 != null) {
                    try {
                        store.close();
                    }
                    catch (Throwable x2) {
                        var3_3.addSuppressed(x2);
                    }
                } else {
                    store.close();
                }
            }
        }
    }

    @Test
    public void shouldRotateCountsStoreWhenClosingTheDatabase() throws IOException {
        GraphDatabaseAPI db = (GraphDatabaseAPI)this.dbBuilder.newGraphDatabase();
        try (Transaction tx = db.beginTx();){
            db.createNode(new Label[]{this.A});
            tx.success();
        }
        db.shutdown();
        Assert.assertTrue((boolean)this.fs.fileExists(this.alphaStoreFile()));
        Assert.assertTrue((boolean)this.fs.fileExists(this.betaStoreFile()));
        var3_3 = null;
        try (CountsStore store = CountsStore.open((FileSystemAbstraction)this.fs, (PageCache)this.pageCache, (File)this.betaStoreFile());){
            Assert.assertEquals((long)3L, (long)store.lastTxId());
            Assert.assertEquals((long)1L, (long)store.minorVersion());
            Assert.assertEquals((long)2L, (long)store.totalRecordsStored());
            Assert.assertEquals((long)2L, (long)this.allRecords((SortedKeyValueStore<CountsKey, Register.CopyableDoubleLongRegister>)store).size());
        }
        catch (Throwable throwable) {
            var3_3 = throwable;
            throw throwable;
        }
    }

    @Test
    public void shouldRotateCountsStoreWhenRotatingLog() throws IOException {
        GraphDatabaseAPI db = (GraphDatabaseAPI)this.dbBuilder.setConfig(GraphDatabaseSettings.logical_log_rotation_threshold, "1").newGraphDatabase();
        try (Transaction tx = db.beginTx();){
            db.createNode(new Label[]{this.B});
            tx.success();
        }
        tx = db.beginTx();
        var3_3 = null;
        try {
            db.createNode(new Label[]{this.C});
            tx.success();
        }
        catch (Throwable x2) {
            var3_3 = x2;
            throw x2;
        }
        finally {
            if (tx != null) {
                if (var3_3 != null) {
                    try {
                        tx.close();
                    }
                    catch (Throwable x2) {
                        var3_3.addSuppressed(x2);
                    }
                } else {
                    tx.close();
                }
            }
        }
        Assert.assertTrue((boolean)this.fs.fileExists(this.alphaStoreFile()));
        Assert.assertTrue((boolean)this.fs.fileExists(this.betaStoreFile()));
        PageCache pageCache = (PageCache)db.getDependencyResolver().resolveDependency(PageCache.class);
        try (CountsStore store = CountsStore.open((FileSystemAbstraction)this.fs, (PageCache)pageCache, (File)this.alphaStoreFile());){
            Assert.assertEquals((long)3L, (long)store.lastTxId());
            Assert.assertEquals((long)1L, (long)store.minorVersion());
            Assert.assertEquals((long)2L, (long)store.totalRecordsStored());
            Assert.assertEquals((long)2L, (long)this.allRecords((SortedKeyValueStore<CountsKey, Register.CopyableDoubleLongRegister>)store).size());
        }
        CountsTracker tracker = ((NeoStore)db.getDependencyResolver().resolveDependency(NeoStore.class)).getCounts();
        Assert.assertEquals((long)2L, (long)tracker.nodeCount(-1, Registers.newDoubleLongRegister()).readSecond());
        LabelTokenHolder holder = (LabelTokenHolder)db.getDependencyResolver().resolveDependency(LabelTokenHolder.class);
        int labelId = holder.getIdByName(this.C.name());
        Assert.assertEquals((long)1L, (long)tracker.nodeCount(labelId, Registers.newDoubleLongRegister()).readSecond());
        db.shutdown();
    }

    @Before
    public void setup() {
        this.fs = this.fsRule.get();
        this.dir = this.testDir.directory("dir").getAbsoluteFile();
        this.dbBuilder = new TestGraphDatabaseFactory().setFileSystem(this.fs).newImpermanentDatabaseBuilder(this.dir.getPath());
        this.pageCache = this.pcRule.getPageCache(this.fs);
    }

    private File alphaStoreFile() {
        return new File(this.dir.getPath(), "neostore.counts.db.a");
    }

    private File betaStoreFile() {
        return new File(this.dir.getPath(), "neostore.counts.db.b");
    }

    private Collection<Pair<CountsKey, Long>> allRecords(SortedKeyValueStore<CountsKey, Register.CopyableDoubleLongRegister> store) {
        final ArrayList<Pair<CountsKey, Long>> records = new ArrayList<Pair<CountsKey, Long>>();
        store.accept((KeyValueRecordVisitor)new KeyValueRecordVisitor<CountsKey, Register.CopyableDoubleLongRegister>(){
            private final Register.DoubleLongRegister register = Registers.newDoubleLongRegister();

            public void visit(CountsKey key, Register.CopyableDoubleLongRegister valueRegister) {
                valueRegister.copyTo((Register.DoubleLong.Out)this.register);
                records.add(Pair.of((Object)key, (Object)this.register.readSecond()));
            }
        }, (Object)Registers.newDoubleLongRegister());
        return records;
    }
}

