/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.store.counts;

import java.io.File;
import java.io.IOException;
import java.nio.ByteBuffer;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.mockito.Mockito;
import org.neo4j.helpers.UTF8;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.io.fs.StoreChannel;
import org.neo4j.io.pagecache.PageCache;
import org.neo4j.kernel.impl.api.CountsVisitor;
import org.neo4j.kernel.impl.store.StoreFactory;
import org.neo4j.kernel.impl.store.UnderlyingStorageException;
import org.neo4j.kernel.impl.store.counts.CountsStore;
import org.neo4j.kernel.impl.store.counts.CountsTracker;
import org.neo4j.kernel.impl.store.counts.keys.CountsKey;
import org.neo4j.kernel.impl.store.counts.keys.CountsKeyFactory;
import org.neo4j.kernel.impl.store.counts.keys.CountsKeyType;
import org.neo4j.kernel.impl.store.kvstore.KeyValueRecordVisitor;
import org.neo4j.kernel.impl.store.kvstore.SortedKeyValueStore;
import org.neo4j.kernel.impl.store.kvstore.SortedKeyValueStoreHeader;
import org.neo4j.register.Register;
import org.neo4j.register.Registers;
import org.neo4j.test.EphemeralFileSystemRule;
import org.neo4j.test.PageCacheRule;

public class CountsStoreTest {
    @Rule
    public EphemeralFileSystemRule fsRule = new EphemeralFileSystemRule();
    @Rule
    public PageCacheRule pageCacheRule = new PageCacheRule();
    private final File alpha = new File("a");
    private final File beta = new File("b");
    private final int lastCommittedTxId = 42;
    private FileSystemAbstraction fs;
    private PageCache pageCache;
    private final SortedKeyValueStoreHeader header = SortedKeyValueStoreHeader.with((int)32, (String)"v0.A.4", (long)1L, (long)1L);

    @Test
    public void shouldCreateAnEmptyStore() throws IOException {
        CountsStore.createEmpty((PageCache)this.pageCache, (File)this.alpha, (SortedKeyValueStoreHeader)this.header);
        try (CountsStore counts = CountsStore.open((FileSystemAbstraction)this.fs, (PageCache)this.pageCache, (File)this.alpha);){
            Assert.assertEquals((long)0L, (long)this.get(counts, (CountsKey)CountsKeyFactory.nodeKey((int)0)));
            Assert.assertEquals((long)0L, (long)this.get(counts, (CountsKey)CountsKeyFactory.relationshipKey((int)1, (int)2, (int)3)));
            Assert.assertEquals((long)1L, (long)counts.lastTxId());
            Assert.assertEquals((long)1L, (long)counts.minorVersion());
            Assert.assertEquals((long)0L, (long)counts.totalRecordsStored());
            Assert.assertEquals((Object)this.alpha, (Object)counts.file());
            counts.accept((KeyValueRecordVisitor)new KeyValueRecordVisitor<CountsKey, Register.CopyableDoubleLongRegister>(){

                public void visit(CountsKey key, Register.CopyableDoubleLongRegister valueRegister) {
                    Assert.fail((String)"should not have been called");
                }
            }, (Object)Registers.newDoubleLongRegister());
        }
    }

    @Test
    public void shouldBumpMinorVersion() throws IOException {
        CountsStore.createEmpty((PageCache)this.pageCache, (File)this.alpha, (SortedKeyValueStoreHeader)this.header);
        try (CountsStore counts = CountsStore.open((FileSystemAbstraction)this.fs, (PageCache)this.pageCache, (File)this.alpha);){
            long initialMinorVersion = counts.minorVersion();
            SortedKeyValueStore.Writer writer = counts.newWriter(this.beta, counts.lastTxId());
            writer.close();
            try (CountsStore updated = (CountsStore)writer.openForReading();){
                Assert.assertEquals((long)(initialMinorVersion + 1L), (long)updated.minorVersion());
            }
        }
    }

    @Test
    public void shouldUpdateTheStore() throws IOException {
        SortedKeyValueStore.Writer writer;
        CountsStore.createEmpty((PageCache)this.pageCache, (File)this.alpha, (SortedKeyValueStoreHeader)this.header);
        try (CountsStore counts = CountsStore.open((FileSystemAbstraction)this.fs, (PageCache)this.pageCache, (File)this.alpha);){
            Register.DoubleLongRegister valueRegister = Registers.newDoubleLongRegister();
            writer = counts.newWriter(this.beta, 42L);
            valueRegister.write(0L, 21L);
            writer.visit((Comparable)CountsKeyFactory.nodeKey((int)0), (Object)valueRegister);
            valueRegister.write(0L, 32L);
            writer.visit((Comparable)CountsKeyFactory.relationshipKey((int)1, (int)2, (int)3), (Object)valueRegister);
            valueRegister.write(9L, 11L);
            writer.visit((Comparable)CountsKeyFactory.indexCountsKey((int)4, (int)5), (Object)valueRegister);
            valueRegister.write(24L, 84L);
            writer.visit((Comparable)CountsKeyFactory.indexSampleKey((int)4, (int)5), (Object)valueRegister);
            writer.close();
        }
        var3_2 = null;
        try (CountsStore updated = (CountsStore)writer.openForReading();){
            Assert.assertEquals((long)21L, (long)this.get(updated, (CountsKey)CountsKeyFactory.nodeKey((int)0)));
            Assert.assertEquals((long)32L, (long)this.get(updated, (CountsKey)CountsKeyFactory.relationshipKey((int)1, (int)2, (int)3)));
            Assert.assertEquals((long)42L, (long)updated.lastTxId());
            Assert.assertEquals((long)1L, (long)updated.minorVersion());
            Assert.assertEquals((long)4L, (long)updated.totalRecordsStored());
            Assert.assertEquals((Object)this.beta, (Object)updated.file());
            updated.accept((KeyValueRecordVisitor)new KeyValueRecordVisitor<CountsKey, Register.CopyableDoubleLongRegister>(){
                private final Register.DoubleLongRegister target = Registers.newDoubleLongRegister();

                public void visit(CountsKey key, Register.CopyableDoubleLongRegister valueRegister) {
                    valueRegister.copyTo((Register.DoubleLong.Out)this.target);
                    key.accept(new CountsVisitor(){

                        public void visitNodeCount(int labelId, long count) {
                            Assert.assertEquals((long)0L, (long)labelId);
                            Assert.assertEquals((long)21L, (long)count);
                        }

                        public void visitRelationshipCount(int startLabelId, int typeId, int endLabelId, long count) {
                            Assert.assertEquals((long)1L, (long)startLabelId);
                            Assert.assertEquals((long)2L, (long)typeId);
                            Assert.assertEquals((long)3L, (long)endLabelId);
                            Assert.assertEquals((long)32L, (long)count);
                        }

                        public void visitIndexCounts(int labelId, int propertyKeyId, long updates, long size) {
                            Assert.assertEquals((long)4L, (long)labelId);
                            Assert.assertEquals((long)5L, (long)propertyKeyId);
                            Assert.assertEquals((long)9L, (long)updates);
                            Assert.assertEquals((long)11L, (long)size);
                        }

                        public void visitIndexSample(int labelId, int propertyKeyId, long unique, long size) {
                            Assert.assertEquals((long)4L, (long)labelId);
                            Assert.assertEquals((long)5L, (long)propertyKeyId);
                            Assert.assertEquals((long)24L, (long)unique);
                            Assert.assertEquals((long)84L, (long)size);
                        }
                    }, this.target.readFirst(), this.target.readSecond());
                }
            }, (Object)Registers.newDoubleLongRegister());
        }
        catch (Throwable throwable) {
            var3_2 = throwable;
            throw throwable;
        }
    }

    @Test
    public void shouldThrowAnExceptionIfTheStoredEntriesDiffersFromTheDataRecordsSavedInTheHeader() throws IOException {
        byte[] version = UTF8.encode((String)StoreFactory.buildTypeDescriptorAndVersion((String)CountsTracker.STORE_DESCRIPTOR));
        int headerBytes = 24 + version.length;
        headerBytes += 32 - headerBytes % 32;
        short headerRecords = (short)(headerBytes / 32);
        int headerSize = 32 * headerRecords;
        try (StoreChannel channel = this.fs.open(this.alpha, "rw");){
            ByteBuffer buffer = ByteBuffer.allocate(headerSize);
            buffer.putShort(headerRecords);
            buffer.putShort((short)version.length);
            buffer.putInt(3);
            buffer.putLong(1L);
            buffer.putLong(1L);
            buffer.put(version);
            for (int i = headerSize; i > 24 + version.length; --i) {
                buffer.put((byte)0);
            }
            buffer.flip();
            channel.write(buffer);
            channel.force(false);
        }
        try {
            CountsStore.open((FileSystemAbstraction)this.fs, (PageCache)this.pageCache, (File)this.alpha);
            Assert.fail((String)"should have thrown");
        }
        catch (UnderlyingStorageException ex) {
            Assert.assertEquals((Object)"Counts store is corrupted", (Object)ex.getMessage());
        }
    }

    @Test
    public void shouldThrowAnExceptionIfTheStoreContainsZeroValues() throws IOException {
        byte[] version = UTF8.encode((String)StoreFactory.buildTypeDescriptorAndVersion((String)CountsTracker.STORE_DESCRIPTOR));
        int headerBytes = 24 + version.length;
        headerBytes += 32 - headerBytes % 32;
        short headerRecords = (short)(headerBytes / 32);
        int headerSize = 32 * headerRecords;
        try (StoreChannel channel = this.fs.open(this.alpha, "rw");){
            ByteBuffer buffer = ByteBuffer.allocate(headerSize + 32);
            buffer.putShort(headerRecords);
            buffer.putShort((short)version.length);
            buffer.putInt(1);
            buffer.putLong(1L);
            buffer.putLong(1L);
            buffer.put(version);
            for (int i = headerSize; i > 24 + version.length; --i) {
                buffer.put((byte)0);
            }
            buffer.put(CountsKeyType.ENTITY_NODE.code);
            buffer.put((byte)0);
            buffer.putInt(0);
            buffer.put((byte)0);
            buffer.putInt(0);
            buffer.put((byte)0);
            buffer.putInt(1);
            buffer.putLong(0L);
            buffer.putLong(0L);
            buffer.flip();
            channel.write(buffer);
            channel.force(false);
        }
        try {
            CountsStore.open((FileSystemAbstraction)this.fs, (PageCache)this.pageCache, (File)this.alpha);
            Assert.fail((String)"should have thrown");
        }
        catch (UnderlyingStorageException ex) {
            Assert.assertEquals((Object)"Counts store contains unexpected value (0,0)", (Object)ex.getMessage());
        }
    }

    @Test
    public void shouldCloseFileIfOpenFailsWithIOExceptionOnHeaderFormat() throws Exception {
        PageCache myCache = (PageCache)Mockito.spy((Object)this.pageCache);
        try (StoreChannel channel = this.fs.open(this.alpha, "rw");){
            ByteBuffer buffer = ByteBuffer.allocate(4);
            buffer.putInt(10);
            buffer.flip();
            channel.write(buffer);
            channel.force(false);
        }
        try {
            CountsStore.open((FileSystemAbstraction)this.fs, (PageCache)myCache, (File)this.alpha);
            Assert.fail((String)"Test setup error, this should have thrown an IOException");
        }
        catch (IOException iOException) {
            // empty catch block
        }
        ((PageCache)Mockito.verify((Object)myCache)).unmap(this.alpha);
    }

    @Before
    public void setup() {
        this.fs = this.fsRule.get();
        this.pageCache = this.pageCacheRule.getPageCache(this.fs);
    }

    private long get(CountsStore store, CountsKey key) {
        Register.DoubleLongRegister value = Registers.newDoubleLongRegister();
        store.get((Comparable)key, (Object)value);
        return value.readSecond();
    }
}

