/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.store.counts;

import java.io.File;
import java.io.IOException;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.io.pagecache.PageCache;
import org.neo4j.kernel.impl.api.CountsVisitor;
import org.neo4j.kernel.impl.store.counts.CountsStore;
import org.neo4j.kernel.impl.store.counts.CountsStoreWriter;
import org.neo4j.kernel.impl.store.counts.keys.CountsKey;
import org.neo4j.kernel.impl.store.counts.keys.CountsKeyFactory;
import org.neo4j.kernel.impl.store.kvstore.KeyValueRecordVisitor;
import org.neo4j.kernel.impl.store.kvstore.SortedKeyValueStoreHeader;
import org.neo4j.register.Register;
import org.neo4j.register.Registers;
import org.neo4j.test.EphemeralFileSystemRule;
import org.neo4j.test.PageCacheRule;

public class CountsStoreWriterTest {
    @Rule
    public EphemeralFileSystemRule fsRule = new EphemeralFileSystemRule();
    @Rule
    public PageCacheRule pageCacheRule = new PageCacheRule();
    private final SortedKeyValueStoreHeader emptyHeader = SortedKeyValueStoreHeader.with((int)32, (String)"v0.A.4", (long)1L, (long)1L);
    private final File file = new File("file");
    private final long lastTxId = 100L;
    private FileSystemAbstraction fs;
    private PageCache pageCache;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void shouldWriteEntriesToTheCountsStore() throws IOException {
        CountsStoreWriter writer = new CountsStoreWriter(this.fs, this.pageCache, this.emptyHeader, this.file, 100L);
        Register.DoubleLongRegister valueRegister = Registers.newDoubleLongRegister();
        valueRegister.write(0L, 42L);
        writer.visit((CountsKey)CountsKeyFactory.nodeKey((int)0), (Register.CopyableDoubleLongRegister)valueRegister);
        valueRegister.write(0L, 24L);
        writer.visit((CountsKey)CountsKeyFactory.relationshipKey((int)1, (int)2, (int)3), (Register.CopyableDoubleLongRegister)valueRegister);
        valueRegister.write(9L, 11L);
        writer.visit((CountsKey)CountsKeyFactory.indexCountsKey((int)4, (int)5), (Register.CopyableDoubleLongRegister)valueRegister);
        valueRegister.write(24L, 84L);
        writer.visit((CountsKey)CountsKeyFactory.indexSampleKey((int)4, (int)5), (Register.CopyableDoubleLongRegister)valueRegister);
        writer.close();
        try {
            CountsStore counts = writer.openForReading();
            Assert.assertEquals((long)100L, (long)counts.lastTxId());
            Assert.assertEquals((long)4L, (long)counts.totalRecordsStored());
            Assert.assertEquals((Object)this.file, (Object)counts.file());
            counts.accept((KeyValueRecordVisitor)new KeyValueRecordVisitor<CountsKey, Register.DoubleLongRegister>(){

                public void visit(CountsKey key, Register.DoubleLongRegister valueRegister) {
                    key.accept(new CountsVisitor(){

                        public void visitNodeCount(int labelId, long count) {
                            Assert.assertEquals((long)0L, (long)labelId);
                            Assert.assertEquals((long)42L, (long)count);
                        }

                        public void visitRelationshipCount(int startLabelId, int typeId, int endLabelId, long count) {
                            Assert.assertEquals((long)1L, (long)startLabelId);
                            Assert.assertEquals((long)2L, (long)typeId);
                            Assert.assertEquals((long)3L, (long)endLabelId);
                            Assert.assertEquals((long)24L, (long)count);
                        }

                        public void visitIndexCounts(int labelId, int propertyKeyId, long updates, long size) {
                            Assert.assertEquals((long)4L, (long)labelId);
                            Assert.assertEquals((long)5L, (long)propertyKeyId);
                            Assert.assertEquals((long)9L, (long)updates);
                            Assert.assertEquals((long)11L, (long)size);
                        }

                        public void visitIndexSample(int labelId, int propertyKeyId, long unique, long size) {
                            Assert.assertEquals((long)4L, (long)labelId);
                            Assert.assertEquals((long)5L, (long)propertyKeyId);
                            Assert.assertEquals((long)24L, (long)unique);
                            Assert.assertEquals((long)84L, (long)size);
                        }
                    }, valueRegister.readFirst(), valueRegister.readSecond());
                }
            }, (Object)Registers.newDoubleLongRegister());
        }
        finally {
            this.pageCache.unmap(this.file);
        }
    }

    @Before
    public void setup() {
        this.fs = this.fsRule.get();
        this.pageCache = this.pageCacheRule.getPageCache(this.fs);
    }
}

