/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.store.counts;

import java.io.File;
import java.io.IOException;
import java.util.concurrent.Future;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TestName;
import org.neo4j.graphdb.mockfs.EphemeralFileSystemAbstraction;
import org.neo4j.helpers.Function;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.io.fs.StoreChannel;
import org.neo4j.io.pagecache.PageCache;
import org.neo4j.kernel.impl.api.CountsAccessor;
import org.neo4j.kernel.impl.store.CommonAbstractStore;
import org.neo4j.kernel.impl.store.CountsOracle;
import org.neo4j.kernel.impl.store.counts.CountsStore;
import org.neo4j.kernel.impl.store.counts.CountsStoreWriter;
import org.neo4j.kernel.impl.store.counts.CountsTracker;
import org.neo4j.kernel.impl.store.counts.CountsTrackerState;
import org.neo4j.kernel.impl.store.counts.keys.CountsKey;
import org.neo4j.kernel.impl.store.kvstore.SortedKeyValueStore;
import org.neo4j.kernel.impl.store.kvstore.SortedKeyValueStoreHeader;
import org.neo4j.kernel.impl.util.StringLogger;
import org.neo4j.register.Register;
import org.neo4j.test.Barrier;
import org.neo4j.test.EphemeralFileSystemRule;
import org.neo4j.test.PageCacheRule;
import org.neo4j.test.ThreadingRule;

public class CountsTrackerTest {
    private static final String VERSION = CommonAbstractStore.buildTypeDescriptorAndVersion((String)CountsTracker.STORE_DESCRIPTOR);
    @Rule
    public final EphemeralFileSystemRule fs = new EphemeralFileSystemRule();
    @Rule
    public final TestName testName = new TestName();
    @Rule
    public final PageCacheRule pageCache = new PageCacheRule();
    @Rule
    public final ThreadingRule threading = new ThreadingRule();

    @Test
    public void shouldCreateBothAlphaAndBetaOnCreation() throws IOException {
        CountsTracker.createEmptyCountsStore((PageCache)this.pageCache(), (File)this.storeFile(), (String)VERSION);
        CountsStore.open((FileSystemAbstraction)this.fs.get(), (PageCache)this.pageCache(), (File)this.alphaStoreFile()).close();
        CountsStore.open((FileSystemAbstraction)this.fs.get(), (PageCache)this.pageCache(), (File)this.betaStoreFile()).close();
    }

    @Test
    public void shouldStoreCounts() throws Exception {
        CountsTracker.createEmptyCountsStore((PageCache)this.pageCache(), (File)this.storeFile(), (String)VERSION);
        CountsOracle oracle = this.oracle();
        try (CountsTracker tracker = new CountsTracker(StringLogger.DEV_NULL, (FileSystemAbstraction)this.fs.get(), this.pageCache(), this.storeFile());){
            oracle.update((CountsAccessor)tracker);
            tracker.rotate(1L);
        }
        tracker = new CountsTracker(StringLogger.DEV_NULL, (FileSystemAbstraction)this.fs.get(), this.pageCache(), this.storeFile());
        var3_3 = null;
        try {
            oracle.verify(tracker);
        }
        catch (Throwable throwable) {
            var3_3 = throwable;
            throw throwable;
        }
        finally {
            if (tracker != null) {
                if (var3_3 != null) {
                    try {
                        tracker.close();
                    }
                    catch (Throwable x2) {
                        var3_3.addSuppressed(x2);
                    }
                } else {
                    tracker.close();
                }
            }
        }
    }

    @Test
    public void shouldUpdateCountsOnExistingStore() throws Exception {
        CountsTracker.createEmptyCountsStore((PageCache)this.pageCache(), (File)this.storeFile(), (String)VERSION);
        CountsOracle oracle = this.oracle();
        int newTxId = 2;
        try (CountsTracker tracker = new CountsTracker(StringLogger.DEV_NULL, (FileSystemAbstraction)this.fs.get(), this.pageCache(), this.storeFile());){
            oracle.update((CountsAccessor)tracker);
            tracker.rotate(1L);
            oracle.verify(tracker);
            CountsOracle delta = new CountsOracle();
            CountsOracle.Node n1 = delta.node(1L);
            CountsOracle.Node n2 = delta.node(1L, 4L);
            delta.relationship(n1, 1, n2);
            delta.relationship(n2, 2, n1);
            delta.update((CountsAccessor)tracker);
            delta.update(oracle);
            oracle.verify(tracker);
            tracker.rotate((long)newTxId);
        }
        tracker = new CountsTracker(StringLogger.DEV_NULL, (FileSystemAbstraction)this.fs.get(), this.pageCache(), this.storeFile());
        var4_4 = null;
        try {
            oracle.verify(tracker);
        }
        catch (Throwable throwable) {
            var4_4 = throwable;
            throw throwable;
        }
        finally {
            if (tracker != null) {
                if (var4_4 != null) {
                    try {
                        tracker.close();
                    }
                    catch (Throwable x2) {
                        var4_4.addSuppressed(x2);
                    }
                } else {
                    tracker.close();
                }
            }
        }
    }

    @Test
    public void shouldBeAbleToReadUpToDateValueWhileAnotherThreadIsPerformingRotation() throws Exception {
        CountsTracker.createEmptyCountsStore((PageCache)this.pageCache(), (File)this.storeFile(), (String)VERSION);
        CountsOracle oracle = this.oracle();
        int newTxId = 2;
        try (CountsTracker tracker = new CountsTracker(StringLogger.DEV_NULL, (FileSystemAbstraction)this.fs.get(), this.pageCache(), this.storeFile());){
            oracle.update((CountsAccessor)tracker);
            tracker.rotate((long)newTxId);
        }
        final CountsOracle delta = new CountsOracle();
        CountsOracle.Node n1 = delta.node(1L);
        CountsOracle.Node n2 = delta.node(1L, 4L);
        delta.relationship(n1, 1, n2);
        delta.relationship(n2, 2, n1);
        delta.update(oracle);
        Barrier.Control barrier = new Barrier.Control();
        try (InstrumentedCountsTracker tracker = new InstrumentedCountsTracker((FileSystemAbstraction)this.fs.get(), this.pageCache(), this.storeFile(), barrier);){
            Future task = this.threading.execute(new Function<CountsTracker, Void>(){

                public Void apply(CountsTracker tracker) {
                    try {
                        delta.update((CountsAccessor)tracker);
                        tracker.rotate(2L);
                    }
                    catch (IOException e) {
                        throw new AssertionError((Object)e);
                    }
                    return null;
                }
            }, tracker);
            barrier.await();
            oracle.verify(tracker);
            barrier.release();
            task.get();
            oracle.verify(tracker);
        }
    }

    @Test
    public void shouldPickStoreFileWithLargerTxId() throws IOException {
        EphemeralFileSystemAbstraction fs = this.fs.get();
        File alphaFile = this.alphaStoreFile();
        File betaFile = this.betaStoreFile();
        PageCache pageCache = this.pageCache();
        this.createStoreFile(fs, pageCache, alphaFile, 1L);
        this.createStoreFile(fs, pageCache, betaFile, 2L);
        CountsTracker tracker = new CountsTracker(StringLogger.DEV_NULL, (FileSystemAbstraction)fs, pageCache, this.storeFile());
        Assert.assertEquals((Object)betaFile, (Object)tracker.storeFile());
        tracker.close();
        this.createStoreFile(fs, pageCache, alphaFile, 2L);
        this.createStoreFile(fs, pageCache, betaFile, 1L);
        tracker = new CountsTracker(StringLogger.DEV_NULL, (FileSystemAbstraction)fs, pageCache, this.storeFile());
        Assert.assertEquals((Object)alphaFile, (Object)tracker.storeFile());
        tracker.close();
    }

    @Test
    public void shouldPickStoreFileWithLargerMinorVersion() throws IOException {
        EphemeralFileSystemAbstraction fs = this.fs.get();
        File alphaFile = this.alphaStoreFile();
        File betaFile = this.betaStoreFile();
        PageCache pageCache = this.pageCache();
        this.createStoreFile(fs, pageCache, alphaFile, 2L);
        this.createStoreFile(fs, pageCache, betaFile, 1L);
        CountsTracker tracker = new CountsTracker(StringLogger.DEV_NULL, (FileSystemAbstraction)fs, pageCache, this.storeFile());
        Assert.assertEquals((Object)alphaFile, (Object)tracker.storeFile());
        tracker.incrementNodeCount(1, 1L);
        tracker.rotate(2L);
        Assert.assertEquals((Object)betaFile, (Object)tracker.storeFile());
        tracker.close();
        tracker = new CountsTracker(StringLogger.DEV_NULL, (FileSystemAbstraction)fs, pageCache, this.storeFile());
        Assert.assertEquals((Object)betaFile, (Object)tracker.storeFile());
        tracker.close();
    }

    @Test
    public void shouldPickTheUncorruptedCountsStoreFile() throws IOException {
        EphemeralFileSystemAbstraction fs = this.fs.get();
        PageCache pageCache = this.pageCache();
        this.createStoreFile(fs, pageCache, this.alphaStoreFile(), 2L);
        this.createStoreFile(fs, pageCache, this.betaStoreFile(), 3L);
        try (StoreChannel channel = fs.open(this.betaStoreFile(), "rw");){
            channel.truncate(12L);
            channel.force(false);
        }
        var4_4 = null;
        try (CountsTracker tracker = new CountsTracker(StringLogger.DEV_NULL, (FileSystemAbstraction)fs, pageCache, this.storeFile());){
            Assert.assertEquals((Object)this.alphaStoreFile(), (Object)tracker.storeFile());
        }
        catch (Throwable throwable) {
            var4_4 = throwable;
            throw throwable;
        }
    }

    public CountsOracle oracle() {
        CountsOracle oracle = new CountsOracle();
        CountsOracle.Node n0 = oracle.node(0L, 1L);
        CountsOracle.Node n1 = oracle.node(0L, 3L);
        CountsOracle.Node n2 = oracle.node(2L, 3L);
        CountsOracle.Node n3 = oracle.node(2L);
        oracle.relationship(n0, 1, n2);
        oracle.relationship(n1, 1, n3);
        oracle.relationship(n1, 1, n2);
        oracle.relationship(n0, 1, n3);
        oracle.indexUpdatesAndSize(1, 2, 0L, 50L);
        oracle.indexSampling(1, 2, 25L, 50L);
        return oracle;
    }

    private File alphaStoreFile() {
        return new File(this.testName.getMethodName() + ".a");
    }

    private File betaStoreFile() {
        return new File(this.testName.getMethodName() + ".b");
    }

    private File storeFile() {
        return new File(this.testName.getMethodName());
    }

    private PageCache pageCache() {
        return this.pageCache.getPageCache((FileSystemAbstraction)this.fs.get());
    }

    private void createStoreFile(EphemeralFileSystemAbstraction fs, PageCache pageCache, File file, long lastTxId) throws IOException {
        SortedKeyValueStoreHeader header = SortedKeyValueStoreHeader.with((int)32, (String)VERSION, (long)1L, (long)1L);
        CountsStoreWriter writer = CountsStore.WRITER_FACTORY.create((FileSystemAbstraction)fs, pageCache, header, file, lastTxId);
        writer.close();
        writer.openForReading().close();
    }

    private static class InstrumentedCountsTracker
    extends CountsTracker {
        private final Barrier barrier;

        InstrumentedCountsTracker(FileSystemAbstraction fs, PageCache pageCache, File storeFileBase, Barrier barrier) {
            super(StringLogger.DEV_NULL, fs, pageCache, storeFileBase);
            this.barrier = barrier;
        }

        SortedKeyValueStore.Writer<CountsKey, Register.CopyableDoubleLongRegister> nextWriter(CountsTrackerState state, long lastTxId) throws IOException {
            final CountsStoreWriter writer = (CountsStoreWriter)super.nextWriter(state, lastTxId);
            return new SortedKeyValueStore.Writer<CountsKey, Register.CopyableDoubleLongRegister>(){

                public SortedKeyValueStore<CountsKey, Register.CopyableDoubleLongRegister> openForReading() throws IOException {
                    InstrumentedCountsTracker.this.barrier.reached();
                    return writer.openForReading();
                }

                public void close() throws IOException {
                    writer.close();
                }

                public void visit(CountsKey key, Register.CopyableDoubleLongRegister valueRegister) {
                    writer.visit(key, valueRegister);
                }
            };
        }
    }
}

