/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.store.format.v2_2;

import java.io.File;
import java.io.IOException;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.io.pagecache.PageCursor;
import org.neo4j.io.pagecache.PagedFile;
import org.neo4j.io.pagecache.StubPageCursor;
import org.neo4j.io.pagecache.impl.muninn.MuninnPageCache;
import org.neo4j.io.pagecache.monitoring.PageCacheMonitor;
import org.neo4j.kernel.impl.store.format.Store;
import org.neo4j.kernel.impl.store.standard.StoreFormat;
import org.neo4j.kernel.impl.store.standard.StoreToolkit;
import org.neo4j.test.EphemeralFileSystemRule;

public abstract class RecordFormatTest<FORMAT extends StoreFormat<RECORD, CURSOR>, RECORD, CURSOR extends Store.RecordCursor<RECORD>> {
    @Rule
    public EphemeralFileSystemRule fsRule = new EphemeralFileSystemRule();
    protected StubPageCursor pageCursor;
    protected final FORMAT format;
    protected StoreFormat.RecordFormat<RECORD> recordFormat;
    protected StoreToolkit storeToolkit;
    protected MuninnPageCache pageCache;
    protected PagedFile pagedFile;

    public RecordFormatTest(FORMAT format) {
        this.format = format;
        this.recordFormat = format.recordFormat();
    }

    @Before
    public void setup() throws IOException {
        int pageSize = 1024;
        this.pageCursor = new StubPageCursor(0L, pageSize);
        this.pageCache = new MuninnPageCache((FileSystemAbstraction)this.fsRule.get(), 1024, 1024, PageCacheMonitor.NULL);
        this.pagedFile = this.pageCache.map(new File("store"), 1024);
        this.storeToolkit = new StoreToolkit(this.format.recordSize(null), pageSize, 0L, null, null);
    }

    public void assertSerializes(RECORD record) {
        this.recordFormat.serialize((PageCursor)this.pageCursor, 0, record);
        Assert.assertEquals((Object)record.toString(), (Object)this.recordFormat.deserialize((PageCursor)this.pageCursor, 0, this.recordFormat.id(record)).toString());
    }

    public void writeToPagedFile(RECORD record) throws IOException {
        try (PageCursor io = this.pagedFile.io(this.storeToolkit.pageId(this.recordFormat.id(record)), 2);){
            io.next();
            this.recordFormat.serialize(io, this.storeToolkit.recordOffset(this.recordFormat.id(record)), record);
        }
    }
}

