/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.store.format.v2_2;

import java.io.File;
import java.util.Arrays;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.io.pagecache.PageCache;
import org.neo4j.io.pagecache.impl.muninn.MuninnPageCache;
import org.neo4j.io.pagecache.monitoring.PageCacheMonitor;
import org.neo4j.kernel.DefaultIdGeneratorFactory;
import org.neo4j.kernel.IdGeneratorFactory;
import org.neo4j.kernel.configuration.Config;
import org.neo4j.kernel.impl.store.NeoStore;
import org.neo4j.kernel.impl.store.RelationshipStore;
import org.neo4j.kernel.impl.store.StoreFactory;
import org.neo4j.kernel.impl.store.format.v2_2.RelationshipStoreFormat_v2_2;
import org.neo4j.kernel.impl.store.impl.StoreMatchers;
import org.neo4j.kernel.impl.store.impl.TestStoreIdGenerator;
import org.neo4j.kernel.impl.store.record.RelationshipRecord;
import org.neo4j.kernel.impl.store.standard.StandardStore;
import org.neo4j.kernel.impl.store.standard.StoreFormat;
import org.neo4j.kernel.impl.store.standard.StoreIdGenerator;
import org.neo4j.kernel.impl.util.StringLogger;
import org.neo4j.kernel.monitoring.Monitors;
import org.neo4j.test.EphemeralFileSystemRule;

public class RelationshipFormatComplianceTest {
    @Rule
    public EphemeralFileSystemRule fsRule = new EphemeralFileSystemRule();
    private PageCache pageCache;
    private StoreFactory storeFactory;
    private final File storeDir = new File("dir").getAbsoluteFile();

    @Before
    public void setup() {
        this.pageCache = new MuninnPageCache((FileSystemAbstraction)this.fsRule.get(), 1024, 1024, PageCacheMonitor.NULL);
        this.storeFactory = new StoreFactory(StoreFactory.configForStoreDir((Config)new Config(), (File)this.storeDir), (IdGeneratorFactory)new DefaultIdGeneratorFactory(), this.pageCache, (FileSystemAbstraction)this.fsRule.get(), StringLogger.DEV_NULL, new Monitors());
    }

    @Test
    public void readsRecords() throws Throwable {
        NeoStore neoStore = this.storeFactory.createNeoStore();
        RelationshipStore relStore = neoStore.getRelationshipStore();
        RelationshipRecord expectedRecord = new RelationshipRecord(relStore.nextId(), 1337L, 1L, 2);
        expectedRecord.setInUse(true);
        relStore.updateRecord(expectedRecord);
        neoStore.close();
        StandardStore store = new StandardStore((StoreFormat)new RelationshipStoreFormat_v2_2(), new File(this.storeDir, "neostore.relationshipstore.db"), (StoreIdGenerator)new TestStoreIdGenerator(), (PageCache)new MuninnPageCache((FileSystemAbstraction)this.fsRule.get(), 1024, 1024, PageCacheMonitor.NULL), (FileSystemAbstraction)this.fsRule.get(), StringLogger.DEV_NULL);
        store.init();
        store.start();
        Assert.assertThat(StoreMatchers.records(store), (Matcher)CoreMatchers.equalTo(Arrays.asList(expectedRecord)));
    }

    @Test
    public void writesRecords() throws Throwable {
        this.storeFactory.createNeoStore().close();
        StandardStore store = new StandardStore((StoreFormat)new RelationshipStoreFormat_v2_2(), new File(this.storeDir, "neostore.relationshipstore.db"), (StoreIdGenerator)new TestStoreIdGenerator(), (PageCache)new MuninnPageCache((FileSystemAbstraction)this.fsRule.get(), 1024, 1024, PageCacheMonitor.NULL), (FileSystemAbstraction)this.fsRule.get(), StringLogger.DEV_NULL);
        store.init();
        store.start();
        RelationshipRecord expectedRecord = new RelationshipRecord(store.allocate(), 1337L, 1L, 2);
        expectedRecord.setInUse(true);
        store.write((Object)expectedRecord);
        store.stop();
        store.shutdown();
        RelationshipStore relStore = this.storeFactory.newRelationshipStore();
        RelationshipRecord record = relStore.getRecord(expectedRecord.getId());
        Assert.assertThat((Object)record, (Matcher)CoreMatchers.equalTo((Object)expectedRecord));
    }
}

