/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.store.id;

import java.io.File;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.kernel.impl.store.UnderlyingStorageException;
import org.neo4j.kernel.impl.store.id.IdGeneratorImpl;
import org.neo4j.test.EphemeralFileSystemRule;

public class IdGeneratorImplTest {
    @Rule
    public final EphemeralFileSystemRule fsr = new EphemeralFileSystemRule();
    private final File file = new File("ids");

    @Test
    public void shouldNotAcceptMinusOne() throws Exception {
        IdGeneratorImpl.createGenerator((FileSystemAbstraction)this.fsr.get(), (File)this.file);
        IdGeneratorImpl idGenerator = new IdGeneratorImpl((FileSystemAbstraction)this.fsr.get(), this.file, 100, 100L, false, 0L);
        try {
            idGenerator.setHighId(-1L);
            Assert.fail((String)"Should have failed");
        }
        catch (UnderlyingStorageException underlyingStorageException) {
            // empty catch block
        }
    }

    @Test
    public void shouldReadHighIdUsingStaticMethod() throws Exception {
        long highId = 12345L;
        IdGeneratorImpl.createGenerator((FileSystemAbstraction)this.fsr.get(), (File)this.file, (long)highId);
        long readHighId = IdGeneratorImpl.readHighId((FileSystemAbstraction)this.fsr.get(), (File)this.file);
        Assert.assertEquals((long)highId, (long)readHighId);
    }

    @Test
    public void shouldBeAbleToReadWrittenGenerator() {
        IdGeneratorImpl.createGenerator((FileSystemAbstraction)this.fsr.get(), (File)this.file);
        IdGeneratorImpl idGenerator = new IdGeneratorImpl((FileSystemAbstraction)this.fsr.get(), this.file, 100, 100L, false, 42L);
        idGenerator.close();
        idGenerator = new IdGeneratorImpl((FileSystemAbstraction)this.fsr.get(), this.file, 100, 100L, false, 0L);
        Assert.assertThat((Object)idGenerator.getHighId(), (Matcher)Matchers.equalTo((Object)42L));
    }
}

