/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.store.impl;

import java.io.File;
import java.util.Arrays;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.io.pagecache.PageCache;
import org.neo4j.io.pagecache.impl.muninn.MuninnPageCache;
import org.neo4j.io.pagecache.monitoring.PageCacheMonitor;
import org.neo4j.kernel.impl.store.format.Store;
import org.neo4j.kernel.impl.store.format.TestCursor;
import org.neo4j.kernel.impl.store.format.TestFormatWithHeader;
import org.neo4j.kernel.impl.store.format.TestHeaderlessStoreFormat;
import org.neo4j.kernel.impl.store.format.TestRecord;
import org.neo4j.kernel.impl.store.impl.StoreMatchers;
import org.neo4j.kernel.impl.store.impl.TestStoreIdGenerator;
import org.neo4j.kernel.impl.store.standard.StandardStore;
import org.neo4j.kernel.impl.store.standard.StoreFormat;
import org.neo4j.kernel.impl.store.standard.StoreIdGenerator;
import org.neo4j.kernel.impl.util.StringLogger;
import org.neo4j.kernel.lifecycle.LifeSupport;
import org.neo4j.test.EphemeralFileSystemRule;

public class StandardStoreTest {
    @Rule
    public EphemeralFileSystemRule fsRule = new EphemeralFileSystemRule();
    private LifeSupport life;
    private PageCache pageCache;

    @Before
    public void setup() {
        this.life = new LifeSupport();
        this.life.start();
        this.pageCache = new MuninnPageCache((FileSystemAbstraction)this.fsRule.get(), 1024, 1024, PageCacheMonitor.NULL);
    }

    @Test
    public void shouldReadRecords() throws Throwable {
        Store store = (Store)this.life.add((Object)new StandardStore((StoreFormat)new TestHeaderlessStoreFormat(), new File("/store"), (StoreIdGenerator)new TestStoreIdGenerator(), this.pageCache, (FileSystemAbstraction)this.fsRule.get(), StringLogger.DEV_NULL));
        long firstId = store.allocate();
        long secondId = store.allocate();
        store.write((Object)new TestRecord(firstId, 1337L));
        store.write((Object)new TestRecord(secondId, 1338L));
        TestRecord firstRecord = (TestRecord)store.read(firstId);
        TestRecord secondRecord = (TestRecord)store.read(secondId);
        Assert.assertThat((Object)firstRecord.value, (Matcher)Matchers.equalTo((Object)1337L));
        Assert.assertThat((Object)secondRecord.value, (Matcher)Matchers.equalTo((Object)1338L));
        this.life.shutdown();
        store = new StandardStore((StoreFormat)new TestHeaderlessStoreFormat(), new File("/store"), (StoreIdGenerator)new TestStoreIdGenerator(), this.pageCache, (FileSystemAbstraction)this.fsRule.get(), StringLogger.DEV_NULL);
        store.init();
        store.start();
        Assert.assertThat(StoreMatchers.records(store), (Matcher)Matchers.equalTo(Arrays.asList(new TestRecord(firstId, 1337L), new TestRecord(secondId, 1338L))));
    }

    @Test
    public void shouldAllowStoresWithHeaders() throws Throwable {
        Store store = (Store)this.life.add((Object)new StandardStore((StoreFormat)new TestFormatWithHeader(14), new File("/store"), (StoreIdGenerator)new TestStoreIdGenerator(), this.pageCache, (FileSystemAbstraction)this.fsRule.get(), StringLogger.DEV_NULL));
        long recordId = store.allocate();
        store.write((Object)new TestRecord(recordId, 1338L));
        TestRecord secondRecord = (TestRecord)store.read(recordId);
        Assert.assertThat((Object)secondRecord.value, (Matcher)Matchers.equalTo((Object)1338L));
        this.life.shutdown();
        store = new StandardStore((StoreFormat)new TestFormatWithHeader(14), new File("/store"), (StoreIdGenerator)new TestStoreIdGenerator(), this.pageCache, (FileSystemAbstraction)this.fsRule.get(), StringLogger.DEV_NULL);
        store.init();
        store.start();
        Assert.assertThat(StoreMatchers.records(store), (Matcher)Matchers.equalTo(Arrays.asList(new TestRecord(recordId, 1338L))));
    }

    @Test
    public void shouldAllowRunningCursorBackwards() throws Throwable {
        Store store = (Store)this.life.add((Object)new StandardStore((StoreFormat)new TestHeaderlessStoreFormat(), new File("/store"), (StoreIdGenerator)new TestStoreIdGenerator(), this.pageCache, (FileSystemAbstraction)this.fsRule.get(), StringLogger.DEV_NULL));
        long firstId = store.allocate();
        long secondId = store.allocate();
        long thirdId = store.allocate();
        long fourthId = store.allocate();
        store.write((Object)new TestRecord(firstId, 1337L));
        store.write((Object)new TestRecord(secondId, 1338L));
        store.write((Object)new TestRecord(fourthId, 1338L));
        TestCursor cursor = (TestCursor)store.cursor(2);
        Assert.assertTrue((boolean)cursor.next());
        Assert.assertEquals((long)fourthId, (long)cursor.recordId());
        Assert.assertTrue((boolean)cursor.next());
        Assert.assertEquals((long)secondId, (long)cursor.recordId());
        Assert.assertTrue((boolean)cursor.next());
        Assert.assertEquals((long)firstId, (long)cursor.recordId());
        Assert.assertFalse((boolean)cursor.next());
    }
}

