/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.store.kvstore;

import java.io.File;
import java.io.IOException;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.neo4j.graphdb.mockfs.EphemeralFileSystemAbstraction;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.io.pagecache.PageCache;
import org.neo4j.io.pagecache.PagedFile;
import org.neo4j.kernel.impl.store.kvstore.SortedKeyValueStoreHeader;
import org.neo4j.test.EphemeralFileSystemRule;
import org.neo4j.test.PageCacheRule;

public class SortedKeyValueStoreHeaderTest {
    @Rule
    public EphemeralFileSystemRule fsRule = new EphemeralFileSystemRule();
    @Rule
    public PageCacheRule pageCacheRule = new PageCacheRule();
    private File file = new File("file");
    private EphemeralFileSystemAbstraction fs;
    private PageCache pageCache;
    private static final int RECORD_SIZE = 32;

    @Test
    public void shouldCreateAnEmptyHeader() {
        SortedKeyValueStoreHeader header = SortedKeyValueStoreHeader.with((int)32, (String)"v0.A.4", (long)1L, (long)1L);
        Assert.assertEquals((long)1L, (long)header.lastTxId());
        Assert.assertEquals((long)0L, (long)header.dataRecords());
        Assert.assertEquals((long)1L, (long)header.headerRecords());
        Assert.assertEquals((Object)"v0.A.4", (Object)header.storeFormatVersion());
    }

    @Test
    public void shouldUpdateHeader() {
        SortedKeyValueStoreHeader header = SortedKeyValueStoreHeader.with((int)32, (String)"v0.A.4", (long)1L, (long)1L);
        SortedKeyValueStoreHeader newHeader = header.update(42, 24L, 12L);
        Assert.assertEquals((long)24L, (long)newHeader.lastTxId());
        Assert.assertEquals((long)12L, (long)newHeader.minorVersion());
        Assert.assertEquals((long)42L, (long)newHeader.dataRecords());
        Assert.assertEquals((long)1L, (long)newHeader.headerRecords());
        Assert.assertEquals((Object)"v0.A.4", (Object)newHeader.storeFormatVersion());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void shouldWriteHeaderInPageFile() throws IOException {
        SortedKeyValueStoreHeader header = SortedKeyValueStoreHeader.with((int)32, (String)"v0.A.4", (long)1L, (long)1L).update(42, 24L, 12L);
        try {
            PagedFile pagedFile = this.pageCache.map(this.file, this.pageCache.pageSize());
            header.write(pagedFile);
            pagedFile.flush();
            Assert.assertEquals((Object)header, (Object)SortedKeyValueStoreHeader.read((int)32, (PagedFile)pagedFile));
        }
        finally {
            this.pageCache.unmap(this.file);
        }
    }

    @Before
    public void setup() {
        this.fs = this.fsRule.get();
        this.pageCache = this.pageCacheRule.getPageCache((FileSystemAbstraction)this.fs);
    }
}

