/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.store.standard;

import java.io.File;
import org.junit.Rule;
import org.junit.Test;
import org.mockito.Mockito;
import org.neo4j.graphdb.mockfs.EphemeralFileSystemAbstraction;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.io.pagecache.PageCache;
import org.neo4j.io.pagecache.impl.muninn.MuninnPageCache;
import org.neo4j.io.pagecache.monitoring.PageCacheMonitor;
import org.neo4j.kernel.impl.store.format.Store;
import org.neo4j.kernel.impl.store.format.TestCursor;
import org.neo4j.kernel.impl.store.format.TestHeaderlessStoreFormat;
import org.neo4j.kernel.impl.store.format.TestRecord;
import org.neo4j.kernel.impl.store.impl.TestStoreIdGenerator;
import org.neo4j.kernel.impl.store.standard.IdGeneratorRebuilder;
import org.neo4j.kernel.impl.store.standard.StandardStore;
import org.neo4j.kernel.impl.store.standard.StoreFormat;
import org.neo4j.kernel.impl.store.standard.StoreIdGenerator;
import org.neo4j.kernel.impl.store.standard.StoreToolkit;
import org.neo4j.kernel.impl.util.StringLogger;
import org.neo4j.test.EphemeralFileSystemRule;

public class FindHighestInUseRebuilderFactoryTest {
    @Rule
    public EphemeralFileSystemRule fsRule = new EphemeralFileSystemRule();

    @Test
    public void shouldFindHighestInUseWhenThereAreUnusedRecordsAtEndOfFile() throws Throwable {
        EphemeralFileSystemAbstraction fs = this.fsRule.get();
        File path = new File("/store.db");
        MuninnPageCache cache = new MuninnPageCache((FileSystemAbstraction)this.fsRule.get(), 1024, 1024, PageCacheMonitor.NULL);
        Store<TestRecord, TestCursor> store = this.newStore(fs, path, (PageCache)cache);
        store.write((Object)new TestRecord(1001L, 1L));
        store.write((Object)new TestRecord(2001L, 0L));
        cache.flush();
        StoreIdGenerator idGenerator = (StoreIdGenerator)Mockito.mock(StoreIdGenerator.class);
        StoreToolkit toolkit = (StoreToolkit)Mockito.mock(StoreToolkit.class);
        Mockito.when((Object)toolkit.fileSize()).thenReturn((Object)16008L);
        Mockito.when((Object)toolkit.recordSize()).thenReturn((Object)8);
        IdGeneratorRebuilder.FindHighestInUseRebuilderFactory rebuilder = new IdGeneratorRebuilder.FindHighestInUseRebuilderFactory();
        rebuilder.newIdGeneratorRebuilder(store, toolkit, idGenerator).rebuildIdGenerator();
        ((StoreIdGenerator)Mockito.verify((Object)idGenerator)).rebuild(1001L);
    }

    @Test
    public void shouldNotGetTrippedUpIfLastRecordIsInUse() throws Throwable {
        EphemeralFileSystemAbstraction fs = this.fsRule.get();
        File path = new File("/store.db");
        MuninnPageCache cache = new MuninnPageCache((FileSystemAbstraction)this.fsRule.get(), 1024, 1024, PageCacheMonitor.NULL);
        Store<TestRecord, TestCursor> store = this.newStore(fs, path, (PageCache)cache);
        store.write((Object)new TestRecord(1001L, 1L));
        store.write((Object)new TestRecord(2001L, 1L));
        cache.flush();
        StoreIdGenerator idGenerator = (StoreIdGenerator)Mockito.mock(StoreIdGenerator.class);
        StoreToolkit toolkit = (StoreToolkit)Mockito.mock(StoreToolkit.class);
        Mockito.when((Object)toolkit.fileSize()).thenReturn((Object)16008L);
        Mockito.when((Object)toolkit.recordSize()).thenReturn((Object)8);
        IdGeneratorRebuilder.FindHighestInUseRebuilderFactory rebuilder = new IdGeneratorRebuilder.FindHighestInUseRebuilderFactory();
        rebuilder.newIdGeneratorRebuilder(store, toolkit, idGenerator).rebuildIdGenerator();
        ((StoreIdGenerator)Mockito.verify((Object)idGenerator)).rebuild(2001L);
    }

    @Test
    public void shouldIgnoreHeaderRecords() throws Throwable {
        EphemeralFileSystemAbstraction fs = this.fsRule.get();
        File path = new File("/store.db");
        MuninnPageCache cache = new MuninnPageCache((FileSystemAbstraction)this.fsRule.get(), 1024, 1024, PageCacheMonitor.NULL);
        Store<TestRecord, TestCursor> store = this.newStore(fs, path, (PageCache)cache);
        store.write((Object)new TestRecord(2L, 1L));
        cache.flush();
        StoreIdGenerator idGenerator = (StoreIdGenerator)Mockito.mock(StoreIdGenerator.class);
        StoreToolkit toolkit = (StoreToolkit)Mockito.mock(StoreToolkit.class);
        Mockito.when((Object)toolkit.fileSize()).thenReturn((Object)800L);
        Mockito.when((Object)toolkit.recordSize()).thenReturn((Object)8);
        Mockito.when((Object)toolkit.firstRecordId()).thenReturn((Object)4L);
        IdGeneratorRebuilder.FindHighestInUseRebuilderFactory rebuilder = new IdGeneratorRebuilder.FindHighestInUseRebuilderFactory();
        rebuilder.newIdGeneratorRebuilder(store, toolkit, idGenerator).rebuildIdGenerator();
        ((StoreIdGenerator)Mockito.verify((Object)idGenerator)).rebuild(4L);
    }

    private Store<TestRecord, TestCursor> newStore(EphemeralFileSystemAbstraction fs, File path, PageCache cache) throws Throwable {
        StandardStore store = new StandardStore((StoreFormat)new TestHeaderlessStoreFormat(), path, (StoreIdGenerator)new TestStoreIdGenerator(), cache, (FileSystemAbstraction)fs, StringLogger.DEV_NULL);
        store.init();
        store.start();
        return store;
    }
}

