/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.storemigration;

import java.io.File;
import java.io.IOException;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.neo4j.graphdb.mockfs.EphemeralFileSystemAbstraction;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.io.pagecache.PageCache;
import org.neo4j.kernel.api.index.SchemaIndexProvider;
import org.neo4j.kernel.impl.api.index.inmemory.InMemoryIndexProvider;
import org.neo4j.kernel.impl.store.StoreFactory;
import org.neo4j.kernel.impl.storemigration.MigrationTestUtils;
import org.neo4j.kernel.impl.storemigration.StoreMigrator;
import org.neo4j.kernel.impl.storemigration.monitoring.MigrationProgressMonitor;
import org.neo4j.kernel.impl.storemigration.monitoring.SilentMigrationProgressMonitor;
import org.neo4j.kernel.logging.DevNullLoggingService;
import org.neo4j.kernel.logging.Logging;
import org.neo4j.kernel.monitoring.Monitors;
import org.neo4j.test.EphemeralFileSystemRule;
import org.neo4j.test.PageCacheRule;

public class StoreMigratorTest {
    private SchemaIndexProvider schemaIndexProvider = new InMemoryIndexProvider();
    @Rule
    public final EphemeralFileSystemRule fs = new EphemeralFileSystemRule();
    @Rule
    public final PageCacheRule pageCacheRule = new PageCacheRule();

    private File createNeoStoreWithOlderVersion(String version) throws IOException {
        File storeDir = new File("dir").getAbsoluteFile();
        EphemeralFileSystemAbstraction fileSystem = this.fs.get();
        fileSystem.mkdirs(storeDir);
        MigrationTestUtils.prepareSampleLegacyDatabase(version, fileSystem, storeDir);
        return storeDir;
    }

    @Test
    public void shouldBeAbleToResumeMigration() throws Exception {
        File storeDirectory = this.createNeoStoreWithOlderVersion("v0.A.1");
        DevNullLoggingService logging = new DevNullLoggingService();
        PageCache pageCache = this.pageCacheRule.getPageCache((FileSystemAbstraction)this.fs.get());
        StoreMigrator migrator = new StoreMigrator((MigrationProgressMonitor)new SilentMigrationProgressMonitor(), (FileSystemAbstraction)this.fs.get(), (Logging)logging);
        File migrationDir = new File(storeDirectory, "upgrade");
        this.fs.get().mkdirs(migrationDir);
        Assert.assertTrue((boolean)migrator.needsMigration(storeDirectory));
        migrator.migrate(storeDirectory, migrationDir, this.schemaIndexProvider, pageCache);
        migrator.close();
        migrator = new StoreMigrator((MigrationProgressMonitor)new SilentMigrationProgressMonitor(), (FileSystemAbstraction)this.fs.get(), (Logging)logging);
        migrator.moveMigratedFiles(migrationDir, storeDirectory);
        StoreFactory storeFactory = new StoreFactory((FileSystemAbstraction)this.fs.get(), storeDirectory, pageCache, logging.getMessagesLog(this.getClass()), new Monitors());
        storeFactory.newNeoStore(false, false).close();
    }
}

