/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.storemigration;

import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import org.hamcrest.Matcher;
import org.hamcrest.core.Is;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.neo4j.helpers.UTF8;
import org.neo4j.io.fs.DefaultFileSystemAbstraction;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.kernel.impl.storemigration.MigrationTestUtils;
import org.neo4j.kernel.impl.storemigration.StoreUpgrader;
import org.neo4j.kernel.impl.storemigration.StoreVersionCheck;
import org.neo4j.kernel.impl.storemigration.UpgradableDatabase;

@RunWith(value=Parameterized.class)
public class UpgradableDatabaseTest {
    private final FileSystemAbstraction fileSystem = new DefaultFileSystemAbstraction();
    private final String version;
    private File workingDirectory;

    public UpgradableDatabaseTest(String version) {
        this.version = version;
    }

    @Parameterized.Parameters(name="{0}")
    public static Collection<Object[]> versions() {
        return Arrays.asList({"v0.A.0"}, {"v0.A.1"}, {"v0.A.3"});
    }

    @Before
    public void setup() throws IOException {
        this.workingDirectory = MigrationTestUtils.findFormatStoreDirectoryForVersion(this.version);
    }

    @Test
    public void shouldAcceptTheStoresInTheSampleDatabaseAsBeingEligibleForUpgrade() throws IOException {
        UpgradableDatabase upgradableDatabase = new UpgradableDatabase(new StoreVersionCheck(this.fileSystem));
        boolean result = upgradableDatabase.storeFilesUpgradeable(this.workingDirectory);
        Assert.assertTrue((boolean)result);
    }

    @Test
    public void shouldRejectStoresIfOneFileHasIncorrectVersion() throws IOException {
        MigrationTestUtils.changeVersionNumber(this.fileSystem, new File(this.workingDirectory, "neostore.nodestore.db"), "v0.9.5");
        UpgradableDatabase upgradableDatabase = new UpgradableDatabase(new StoreVersionCheck(this.fileSystem));
        boolean result = upgradableDatabase.storeFilesUpgradeable(this.workingDirectory);
        Assert.assertFalse((boolean)result);
    }

    @Test
    public void shouldRejectStoresIfOneFileHasNoVersionAsIfNotShutDownCleanly() throws IOException {
        File storeFile = new File(this.workingDirectory, "neostore.nodestore.db");
        MigrationTestUtils.truncateFile(this.fileSystem, storeFile, "StringPropertyStore " + this.version);
        UpgradableDatabase upgradableDatabase = new UpgradableDatabase(new StoreVersionCheck(this.fileSystem));
        boolean result = upgradableDatabase.storeFilesUpgradeable(this.workingDirectory);
        Assert.assertFalse((boolean)result);
    }

    @Test
    public void shouldRejectStoresIfOneFileShorterThanExpectedVersionString() throws IOException {
        int shortFileLength = 15;
        Assert.assertTrue((15 < UTF8.encode((String)("StringPropertyStore " + this.version)).length ? 1 : 0) != 0);
        MigrationTestUtils.truncateToFixedLength(this.fileSystem, new File(this.workingDirectory, "neostore.relationshiptypestore.db"), 15);
        UpgradableDatabase upgradableDatabase = new UpgradableDatabase(new StoreVersionCheck(this.fileSystem));
        boolean result = upgradableDatabase.storeFilesUpgradeable(this.workingDirectory);
        Assert.assertFalse((boolean)result);
    }

    @Test
    public void shouldCommunicateWhatCausesInabilityToUpgrade() throws IOException {
        String filename = "neostore.nodestore.db";
        String version = "v0.9.5";
        MigrationTestUtils.changeVersionNumber(this.fileSystem, new File(this.workingDirectory, "neostore.nodestore.db"), "v0.9.5");
        UpgradableDatabase upgradableDatabase = new UpgradableDatabase(new StoreVersionCheck(this.fileSystem));
        try {
            upgradableDatabase.checkUpgradeable(this.workingDirectory);
            Assert.fail((String)"should not have been able to upgrade");
        }
        catch (StoreUpgrader.UnexpectedUpgradingStoreVersionException e) {
            String expected = "'neostore.nodestore.db' has a store version number that we cannot upgrade from. Expected 'v0.A.3' but file is version 'NodeStore v0.9.5'.";
            Assert.assertThat((Object)e.getMessage(), (Matcher)Is.is((Object)"'neostore.nodestore.db' has a store version number that we cannot upgrade from. Expected 'v0.A.3' but file is version 'NodeStore v0.9.5'."));
        }
    }
}

