/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.storemigration.legacystore.v21.propertydeduplication;

import java.io.IOException;
import java.util.Map;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.mockito.Mockito;
import org.neo4j.graphdb.DependencyResolver;
import org.neo4j.graphdb.DynamicLabel;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Label;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.Transaction;
import org.neo4j.graphdb.factory.GraphDatabaseFactory;
import org.neo4j.kernel.GraphDatabaseAPI;
import org.neo4j.kernel.impl.store.NeoStore;
import org.neo4j.kernel.impl.store.NodeStore;
import org.neo4j.kernel.impl.store.PropertyKeyTokenStore;
import org.neo4j.kernel.impl.store.PropertyStore;
import org.neo4j.kernel.impl.store.record.NodeRecord;
import org.neo4j.kernel.impl.store.record.PropertyBlock;
import org.neo4j.kernel.impl.store.record.PropertyRecord;
import org.neo4j.kernel.impl.storemigration.legacystore.v21.propertydeduplication.DuplicatePropertyRemover;
import org.neo4j.kernel.impl.storemigration.legacystore.v21.propertydeduplication.IndexConsultedPropertyBlockSweeper;
import org.neo4j.kernel.impl.storemigration.legacystore.v21.propertydeduplication.IndexLookup;
import org.neo4j.kernel.impl.storemigration.legacystore.v21.propertydeduplication.IndexLookupTest;
import org.neo4j.kernel.impl.storemigration.legacystore.v21.propertydeduplication.PropertyDeduplicatorTestUtil;
import org.neo4j.kernel.impl.transaction.state.NeoStoreProvider;
import org.neo4j.test.TargetDirectory;

public class IndexConsultedPropertyBlockSweeperTest {
    @Rule
    public TargetDirectory.TestDirectory storePath = TargetDirectory.testDirForTest(IndexLookupTest.class);
    private GraphDatabaseAPI api;
    private long nodeId;
    private NodeStore nodeStore;
    private PropertyStore propertyStore;
    private Map<String, Integer> propertyKeys;
    private String nonIndexedPropKey;
    private String indexedPropKey;
    private IndexConsultedPropertyBlockSweeper sweeper;
    private IndexLookup.Index indexMock;
    private DuplicatePropertyRemover propertyRemoverMock;
    private String indexedValue;
    private String nonIndexedValue;
    private long propertyId;
    private NodeRecord nodeRecord;

    @Before
    public void setUp() throws IOException {
        GraphDatabaseFactory factory = new GraphDatabaseFactory();
        GraphDatabaseService db = factory.newEmbeddedDatabase(this.storePath.absolutePath());
        this.api = (GraphDatabaseAPI)db;
        this.nonIndexedPropKey = "notIndexed";
        this.indexedPropKey = "indexed";
        Label usedLabel = DynamicLabel.label((String)"UsedLabel");
        try (Transaction transaction = db.beginTx();){
            db.schema().indexFor(usedLabel).on(this.indexedPropKey).create();
            transaction.success();
        }
        transaction = db.beginTx();
        var5_5 = null;
        try {
            this.indexedValue = "value1";
            this.nonIndexedValue = "value2";
            Node nodeA = db.createNode(new Label[]{usedLabel});
            nodeA.setProperty(this.indexedPropKey, (Object)this.indexedValue);
            nodeA.setProperty(this.nonIndexedPropKey, (Object)this.nonIndexedValue);
            this.nodeId = nodeA.getId();
            transaction.success();
        }
        catch (Throwable x2) {
            var5_5 = x2;
            throw x2;
        }
        finally {
            if (transaction != null) {
                if (var5_5 != null) {
                    try {
                        transaction.close();
                    }
                    catch (Throwable x2) {
                        var5_5.addSuppressed(x2);
                    }
                } else {
                    transaction.close();
                }
            }
        }
        DependencyResolver resolver = this.api.getDependencyResolver();
        NeoStoreProvider neoStoreProvider = (NeoStoreProvider)resolver.resolveDependency(NeoStoreProvider.class);
        NeoStore neoStore = (NeoStore)neoStoreProvider.evaluate();
        this.nodeStore = neoStore.getNodeStore();
        PropertyKeyTokenStore propertyKeyTokenStore = neoStore.getPropertyKeyTokenStore();
        this.propertyKeys = PropertyDeduplicatorTestUtil.indexPropertyKeys(propertyKeyTokenStore);
        this.propertyStore = neoStore.getPropertyStore();
        this.nodeRecord = this.nodeStore.getRecord(this.nodeId);
        this.propertyId = this.nodeRecord.getNextProp();
        this.indexMock = (IndexLookup.Index)Mockito.mock(IndexLookup.Index.class);
        Mockito.when((Object)this.indexMock.contains(this.nodeId, (Object)this.indexedValue)).thenReturn((Object)true);
        this.propertyRemoverMock = (DuplicatePropertyRemover)Mockito.mock(DuplicatePropertyRemover.class);
    }

    @After
    public void tearDown() {
        this.api.shutdown();
    }

    @Test
    public void shouldNotRemoveIndexedValue() throws Exception {
        int propertyKeyId = this.propertyKeys.get(this.indexedPropKey);
        this.sweeper = new IndexConsultedPropertyBlockSweeper(propertyKeyId, this.indexMock, this.nodeRecord, this.propertyStore, this.propertyRemoverMock);
        Assert.assertFalse((boolean)this.sweeper.visited(this.propertyId));
        PropertyRecord propertyRecord = this.propertyStore.getRecord(this.propertyId);
        Assert.assertNotNull((Object)propertyRecord.getPropertyBlock(propertyKeyId));
    }

    @Test
    public void shouldRemoveNonIndexedValue() throws Exception {
        int propertyKeyId = this.propertyKeys.get(this.nonIndexedPropKey);
        this.sweeper = new IndexConsultedPropertyBlockSweeper(propertyKeyId, this.indexMock, this.nodeRecord, this.propertyStore, this.propertyRemoverMock);
        Assert.assertFalse((boolean)this.sweeper.visited(this.propertyId));
        PropertyRecord propertyRecord = this.propertyStore.getRecord(this.propertyId);
        Assert.assertNull((Object)propertyRecord.getPropertyBlock(propertyKeyId));
    }

    @Test
    public void shouldFixThePropertyChainAfterAllTheBlocksInRecordAreRemoved() throws IOException {
        int propertyKeyId = this.propertyKeys.get(this.indexedPropKey);
        PropertyRecord propertyRecord = this.propertyStore.getRecord(this.propertyId);
        for (PropertyBlock propertyBlock : propertyRecord.getPropertyBlocks()) {
            long[] valueBlocks = propertyBlock.getValueBlocks();
            valueBlocks[1] = valueBlocks[1] + 2L;
            propertyBlock.setKeyIndexId(propertyKeyId);
        }
        this.propertyStore.updateRecord(propertyRecord);
        this.sweeper = new IndexConsultedPropertyBlockSweeper(propertyKeyId, this.indexMock, this.nodeRecord, this.propertyStore, this.propertyRemoverMock);
        Assert.assertFalse((boolean)this.sweeper.visited(this.propertyId));
        ((DuplicatePropertyRemover)Mockito.verify((Object)this.propertyRemoverMock)).fixUpPropertyLinksAroundUnusedRecord(this.nodeRecord, propertyRecord);
    }
}

