/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.transaction;

import java.util.concurrent.atomic.AtomicLong;
import org.neo4j.kernel.impl.transaction.log.TransactionIdStore;
import org.neo4j.kernel.impl.util.ArrayQueueOutOfOrderSequence;
import org.neo4j.kernel.impl.util.OutOfOrderSequence;

public class DeadSimpleTransactionIdStore
implements TransactionIdStore {
    private final AtomicLong committingTransactionId = new AtomicLong();
    private final OutOfOrderSequence committedTransactionId = new ArrayQueueOutOfOrderSequence(-1L, 100);
    private final OutOfOrderSequence closedTransactionId = new ArrayQueueOutOfOrderSequence(-1L, 100);
    private final long initialTransactionId;
    private final long initialTransactionChecksum;

    public DeadSimpleTransactionIdStore() {
        this(1L, 0L);
    }

    public DeadSimpleTransactionIdStore(long initialTransactionId, long checksum) {
        this.setLastCommittedAndClosedTransactionId(initialTransactionId, checksum);
        this.initialTransactionId = initialTransactionId;
        this.initialTransactionChecksum = checksum;
    }

    public long getLastCommittingTransactionId() {
        return this.committingTransactionId.get();
    }

    public long nextCommittingTransactionId() {
        return this.committingTransactionId.incrementAndGet();
    }

    public void transactionCommitted(long transactionId, long checksum) {
        this.committedTransactionId.offer(transactionId, checksum);
    }

    public long getLastCommittedTransactionId() {
        return this.committedTransactionId.getHighestGapFreeNumber();
    }

    public long[] getLastCommittedTransaction() {
        return this.committedTransactionId.get();
    }

    public long[] getUpgradeTransaction() {
        return new long[]{this.initialTransactionId, this.initialTransactionChecksum};
    }

    public long getLastClosedTransactionId() {
        return this.closedTransactionId.getHighestGapFreeNumber();
    }

    public void setLastCommittedAndClosedTransactionId(long transactionId, long checksum) {
        this.committingTransactionId.set(transactionId);
        this.committedTransactionId.set(transactionId, checksum);
        this.closedTransactionId.set(transactionId, checksum);
    }

    public void transactionClosed(long transactionId) {
        this.closedTransactionId.offer(transactionId, 0L);
    }

    public boolean closedTransactionIdIsOnParWithCommittedTransactionId() {
        return this.closedTransactionId.getHighestGapFreeNumber() == this.committedTransactionId.getHighestGapFreeNumber();
    }

    public void flush() {
    }
}

