/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.transaction;

import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.neo4j.graphdb.event.ErrorState;
import org.neo4j.kernel.KernelHealth;
import org.neo4j.kernel.impl.core.KernelPanicEventGenerator;
import org.neo4j.kernel.impl.util.StringLogger;
import org.neo4j.kernel.logging.Logging;
import org.neo4j.kernel.logging.SingleLoggingService;
import org.neo4j.test.BufferingLogging;

public class KernelHealthTest {
    @Test
    public void shouldGenerateKernelPanicEvents() throws Exception {
        KernelPanicEventGenerator generator = (KernelPanicEventGenerator)Mockito.mock(KernelPanicEventGenerator.class);
        KernelHealth kernelHealth = new KernelHealth(generator, (Logging)new SingleLoggingService(StringLogger.DEV_NULL));
        kernelHealth.healed();
        Exception cause = new Exception("My own fault");
        kernelHealth.panic((Throwable)cause);
        kernelHealth.panic((Throwable)cause);
        ((KernelPanicEventGenerator)Mockito.verify((Object)generator, (VerificationMode)Mockito.times((int)1))).generateEvent(ErrorState.TX_MANAGER_NOT_OK, (Throwable)cause);
    }

    @Test
    public void shouldLogKernelPanicEvent() throws Exception {
        BufferingLogging logging = new BufferingLogging();
        KernelHealth kernelHealth = new KernelHealth((KernelPanicEventGenerator)Mockito.mock(KernelPanicEventGenerator.class), (Logging)logging);
        kernelHealth.healed();
        String message = "Listen everybody... panic!";
        kernelHealth.panic((Throwable)new Exception(message));
        Assert.assertThat((Object)logging.toString(), (Matcher)CoreMatchers.containsString((String)message));
    }
}

