/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.transaction;

import java.util.Arrays;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.CountDownLatch;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.neo4j.adversaries.Adversary;
import org.neo4j.adversaries.ClassGuardedAdversary;
import org.neo4j.adversaries.CountingAdversary;
import org.neo4j.adversaries.fs.AdversarialFileSystemAbstraction;
import org.neo4j.graphdb.DynamicRelationshipType;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.Relationship;
import org.neo4j.graphdb.RelationshipType;
import org.neo4j.graphdb.Transaction;
import org.neo4j.graphdb.factory.GraphDatabaseFactoryState;
import org.neo4j.helpers.collection.MapUtil;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.kernel.EmbeddedGraphDatabase;
import org.neo4j.kernel.InternalAbstractGraphDatabase;
import org.neo4j.kernel.extension.KernelExtensionFactory;
import org.neo4j.kernel.impl.api.index.inmemory.InMemoryIndexProviderFactory;
import org.neo4j.kernel.impl.api.scan.InMemoryLabelScanStoreExtension;
import org.neo4j.kernel.impl.cache.SoftCacheProvider;
import org.neo4j.test.TargetDirectory;

public class PartialTransactionFailureIT {
    @Rule
    public TargetDirectory.TestDirectory dir = TargetDirectory.testDirForTest(PartialTransactionFailureIT.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void concurrentlyCommittingTransactionsMustNotRotateOutLoggedCommandsOfFailingTransaction() throws Exception {
        Node d;
        Node c;
        Node b;
        Node a;
        final ClassGuardedAdversary adversary = new ClassGuardedAdversary((Adversary)new CountingAdversary(1, false), new String[]{"org.neo4j.kernel.impl.nioneo.xa.Command$RelationshipCommand"});
        adversary.disable();
        Map params = MapUtil.stringMap((String[])new String[]{"logical_log_rotation_threshold", "1"});
        String storeDir = this.dir.directory().getAbsolutePath();
        TestEmbeddedGraphDatabase db = new TestEmbeddedGraphDatabase(storeDir, params){

            protected FileSystemAbstraction createFileSystemAbstraction() {
                return new AdversarialFileSystemAbstraction((Adversary)adversary);
            }
        };
        Transaction tx = db.beginTx();
        try {
            a = db.createNode();
            b = db.createNode();
            c = db.createNode();
            d = db.createNode();
            tx.success();
        }
        finally {
            tx.finish();
        }
        adversary.enable();
        CountDownLatch latch = new CountDownLatch(1);
        Thread t1 = new Thread(this.createRelationship(db, a, b, latch), "T1");
        Thread t2 = new Thread(this.createRelationship(db, c, d, latch), "T2");
        t1.start();
        t2.start();
        t1.join(10L);
        t2.join(10L);
        latch.countDown();
        t1.join(25000L);
        t2.join(25000L);
        db.shutdown();
        TestEmbeddedGraphDatabase db2 = new TestEmbeddedGraphDatabase(storeDir, MapUtil.stringMap((String[])new String[0]));
        tx = db2.beginTx();
        try {
            Relationship rel;
            Node x = db2.getNodeById(a.getId());
            Node y = db2.getNodeById(b.getId());
            Node z = db2.getNodeById(c.getId());
            Node w = db2.getNodeById(d.getId());
            Iterator itrRelX = x.getRelationships().iterator();
            Iterator itrRelY = y.getRelationships().iterator();
            Iterator itrRelZ = z.getRelationships().iterator();
            Iterator itrRelW = w.getRelationships().iterator();
            if (itrRelX.hasNext() != itrRelY.hasNext()) {
                Assert.fail((String)"Node x and y have inconsistent relationship counts");
            } else if (itrRelX.hasNext()) {
                rel = (Relationship)itrRelX.next();
                Assert.assertEquals((Object)rel, itrRelY.next());
                Assert.assertFalse((boolean)itrRelX.hasNext());
                Assert.assertFalse((boolean)itrRelY.hasNext());
            }
            if (itrRelZ.hasNext() != itrRelW.hasNext()) {
                Assert.fail((String)"Node z and w have inconsistent relationship counts");
            } else if (itrRelZ.hasNext()) {
                rel = (Relationship)itrRelZ.next();
                Assert.assertEquals((Object)rel, itrRelW.next());
                Assert.assertFalse((boolean)itrRelZ.hasNext());
                Assert.assertFalse((boolean)itrRelW.hasNext());
            }
        }
        finally {
            try {
                tx.finish();
            }
            finally {
                db2.shutdown();
            }
        }
    }

    private Runnable createRelationship(final EmbeddedGraphDatabase db, final Node x, final Node y, final CountDownLatch latch) {
        return new Runnable(){

            @Override
            public void run() {
                Transaction tx = db.beginTx();
                try {
                    x.createRelationshipTo(y, (RelationshipType)DynamicRelationshipType.withName((String)"r"));
                    tx.success();
                    latch.await();
                    tx.finish();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        };
    }

    private static class TestEmbeddedGraphDatabase
    extends EmbeddedGraphDatabase {
        public TestEmbeddedGraphDatabase(String storeDir, Map<String, String> params) {
            super(storeDir, params, TestEmbeddedGraphDatabase.dependencies());
        }

        private static InternalAbstractGraphDatabase.Dependencies dependencies() {
            GraphDatabaseFactoryState state = new GraphDatabaseFactoryState();
            state.addKernelExtensions(Arrays.asList(new KernelExtensionFactory[]{new InMemoryIndexProviderFactory(), new InMemoryLabelScanStoreExtension()}));
            state.setCacheProviders(Arrays.asList(new SoftCacheProvider()));
            return state.databaseDependencies();
        }
    }
}

