/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.transaction.command;

import org.hamcrest.Description;
import org.hamcrest.Matcher;
import org.hamcrest.TypeSafeMatcher;
import org.neo4j.kernel.impl.transaction.command.Command;
import org.neo4j.kernel.impl.transaction.log.entry.LogEntry;
import org.neo4j.kernel.impl.transaction.log.entry.LogEntryCommand;

public class CommandMatchers {
    public static Matcher<? extends LogEntry> nodeCommandEntry(final int identifier, final int nodeId) {
        return new TypeSafeMatcher<LogEntryCommand>(){

            public boolean matchesSafely(LogEntryCommand entry) {
                if (entry != null && entry.getXaCommand() != null && entry.getXaCommand() instanceof Command.NodeCommand) {
                    Command.NodeCommand cmd = (Command.NodeCommand)entry.getXaCommand();
                    return cmd.getKey() == (long)nodeId;
                }
                return false;
            }

            public void describeTo(Description description) {
                description.appendText(String.format("Command[%d, Node[%d,used=<Any boolean>,rel=<Any relchain>,prop=<Any relchain>]]", identifier, nodeId));
            }
        };
    }
}

