/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.transaction.command;

import org.junit.Assert;
import org.junit.Test;
import org.neo4j.kernel.impl.transaction.command.CommandReader;
import org.neo4j.kernel.impl.transaction.command.CommandReaderFactory;
import org.neo4j.kernel.impl.transaction.command.PhysicalLogNeoCommandReaderV0_19;
import org.neo4j.kernel.impl.transaction.command.PhysicalLogNeoCommandReaderV0_20;
import org.neo4j.kernel.impl.transaction.command.PhysicalLogNeoCommandReaderV1;
import org.neo4j.kernel.impl.transaction.command.PhysicalLogNeoCommandReaderV2;

public class CommandReaderFactoryTest {
    @Test
    public void testReturnsV0_19ReaderForVersion0AndLogFormat1_9() throws Exception {
        CommandReaderFactory.Default factory = new CommandReaderFactory.Default();
        CommandReader reader = factory.newInstance((byte)2, (byte)0);
        Assert.assertTrue((boolean)(reader instanceof PhysicalLogNeoCommandReaderV0_19));
    }

    @Test
    public void testReturnsV0_20ReaderForVersion0AndLogFormat2_0() throws Exception {
        CommandReaderFactory.Default factory = new CommandReaderFactory.Default();
        CommandReader reader = factory.newInstance((byte)3, (byte)0);
        Assert.assertTrue((boolean)(reader instanceof PhysicalLogNeoCommandReaderV0_20));
    }

    @Test
    public void testReturnsV1_21ReaderForVersion1AndLogFormat2_1() throws Exception {
        CommandReaderFactory.Default factory = new CommandReaderFactory.Default();
        CommandReader reader = factory.newInstance((byte)4, (byte)-1);
        Assert.assertTrue((boolean)(reader instanceof PhysicalLogNeoCommandReaderV1));
    }

    @Test
    public void testReturnsV2ReaderForVersion2AndLogFormat2_2() throws Exception {
        CommandReaderFactory.Default factory = new CommandReaderFactory.Default();
        CommandReader reader = factory.newInstance((byte)5, (byte)-2);
        Assert.assertTrue((boolean)(reader instanceof PhysicalLogNeoCommandReaderV2));
    }

    @Test
    public void testThrowsExceptionForNonExistingVersionFor2_1() throws Exception {
        CommandReaderFactory.Default factory = new CommandReaderFactory.Default();
        try {
            factory.newInstance((byte)4, (byte)-5);
            Assert.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void testThrowsExceptionForNonExistingVersionFor1_9() throws Exception {
        CommandReaderFactory.Default factory = new CommandReaderFactory.Default();
        try {
            factory.newInstance((byte)2, (byte)-5);
            Assert.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }
}

