/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.transaction.command;

import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.neo4j.kernel.api.labelscan.LabelScanStore;
import org.neo4j.kernel.api.labelscan.NodeLabelUpdate;
import org.neo4j.kernel.impl.api.TransactionApplicationMode;
import org.neo4j.kernel.impl.api.index.IndexUpdates;
import org.neo4j.kernel.impl.api.index.IndexingService;
import org.neo4j.kernel.impl.core.CacheAccessBackDoor;
import org.neo4j.kernel.impl.store.NodeStore;
import org.neo4j.kernel.impl.store.PropertyStore;
import org.neo4j.kernel.impl.store.record.NodeRecord;
import org.neo4j.kernel.impl.store.record.PropertyRecord;
import org.neo4j.kernel.impl.transaction.command.Command;
import org.neo4j.kernel.impl.transaction.command.IndexTransactionApplier;
import org.neo4j.kernel.impl.transaction.state.LazyIndexUpdates;
import org.neo4j.kernel.impl.transaction.state.PropertyLoader;
import org.neo4j.unsafe.batchinsert.LabelScanWriter;

public class NeoTransactionIndexApplierTest {
    private final IndexingService indexingService = (IndexingService)Mockito.mock(IndexingService.class);
    private final LabelScanStore labelScanStore = (LabelScanStore)Mockito.mock(LabelScanStore.class);
    private final NodeStore nodeStore = (NodeStore)Mockito.mock(NodeStore.class);
    private final PropertyStore propertyStore = (PropertyStore)Mockito.mock(PropertyStore.class);
    private final CacheAccessBackDoor cacheAccess = (CacheAccessBackDoor)Mockito.mock(CacheAccessBackDoor.class);
    private final PropertyLoader propertyLoader = (PropertyLoader)Mockito.mock(PropertyLoader.class);
    private final Map<Long, Command.NodeCommand> emptyNodeCommands = Collections.emptyMap();
    private final Map<Long, List<Command.PropertyCommand>> emptyPropCommands = Collections.emptyMap();
    private final long transactionId = 42L;

    @Test
    public void shouldUpdateIndexesOnNodeCommands() throws IOException {
        IndexTransactionApplier applier = new IndexTransactionApplier(this.indexingService, this.labelScanStore, this.nodeStore, this.propertyStore, this.cacheAccess, this.propertyLoader, 42L, TransactionApplicationMode.EXTERNAL);
        NodeRecord before = new NodeRecord(11L);
        NodeRecord after = new NodeRecord(12L);
        Command.NodeCommand command = new Command.NodeCommand().init(before, after);
        boolean result = applier.visitNodeCommand(command);
        applier.apply();
        Assert.assertFalse((boolean)result);
        Map<Long, Command.NodeCommand> nodeCommands = Collections.singletonMap(command.getKey(), command);
        LazyIndexUpdates expectedUpdates = new LazyIndexUpdates(this.nodeStore, this.propertyStore, this.emptyPropCommands, nodeCommands, this.propertyLoader);
        ((IndexingService)Mockito.verify((Object)this.indexingService, (VerificationMode)Mockito.times((int)1))).updateIndexes((IndexUpdates)Matchers.eq((Object)expectedUpdates), Matchers.eq((long)42L), Matchers.eq((boolean)false));
    }

    @Test
    public void shouldUpdateLabelStoreScanOnNodeCommands() throws IOException {
        IndexTransactionApplier applier = new IndexTransactionApplier(this.indexingService, this.labelScanStore, this.nodeStore, this.propertyStore, this.cacheAccess, this.propertyLoader, 42L, TransactionApplicationMode.EXTERNAL);
        NodeRecord before = new NodeRecord(11L);
        before.setLabelField(17L, Collections.emptySet());
        NodeRecord after = new NodeRecord(12L);
        after.setLabelField(18L, Collections.emptySet());
        Command.NodeCommand command = new Command.NodeCommand().init(before, after);
        Mockito.when((Object)this.labelScanStore.newWriter()).thenReturn(Mockito.mock(LabelScanWriter.class));
        boolean result = applier.visitNodeCommand(command);
        applier.apply();
        Assert.assertFalse((boolean)result);
        NodeLabelUpdate update = NodeLabelUpdate.labelChanges((long)command.getKey(), (long[])new long[0], (long[])new long[0]);
        List<NodeLabelUpdate> labelUpdates = Arrays.asList(update);
        ((CacheAccessBackDoor)Mockito.verify((Object)this.cacheAccess, (VerificationMode)Mockito.times((int)1))).applyLabelUpdates((Collection)Matchers.eq(labelUpdates));
        Map<Long, Command.NodeCommand> nodeCommands = Collections.singletonMap(command.getKey(), command);
        LazyIndexUpdates expectedUpdates = new LazyIndexUpdates(this.nodeStore, this.propertyStore, this.emptyPropCommands, nodeCommands, this.propertyLoader);
        ((IndexingService)Mockito.verify((Object)this.indexingService, (VerificationMode)Mockito.times((int)1))).updateIndexes((IndexUpdates)Matchers.eq((Object)expectedUpdates), Matchers.eq((long)42L), Matchers.eq((boolean)false));
    }

    @Test
    public void shouldUpdateIndexesOnPropertyCommandsWhenThePropertyIsOnANode() throws IOException {
        IndexTransactionApplier applier = new IndexTransactionApplier(this.indexingService, this.labelScanStore, this.nodeStore, this.propertyStore, this.cacheAccess, this.propertyLoader, 42L, TransactionApplicationMode.EXTERNAL);
        PropertyRecord before = new PropertyRecord(11L);
        PropertyRecord after = new PropertyRecord(12L);
        after.setNodeId(42L);
        Command.PropertyCommand command = new Command.PropertyCommand().init(before, after);
        boolean result = applier.visitPropertyCommand(command);
        applier.apply();
        Assert.assertFalse((boolean)result);
        Map<Long, List<Command.PropertyCommand>> propCommands = Collections.singletonMap(command.getNodeId(), Arrays.asList(command));
        LazyIndexUpdates expectedUpdates = new LazyIndexUpdates(this.nodeStore, this.propertyStore, propCommands, this.emptyNodeCommands, this.propertyLoader);
        ((IndexingService)Mockito.verify((Object)this.indexingService, (VerificationMode)Mockito.times((int)1))).updateIndexes((IndexUpdates)Matchers.eq((Object)expectedUpdates), Matchers.eq((long)42L), Matchers.eq((boolean)false));
    }

    @Test
    public void shouldNotUpdateIndexesOnPropertyCommandsWhenThePropertyIsNotOnANode() throws IOException {
        IndexTransactionApplier applier = new IndexTransactionApplier(this.indexingService, this.labelScanStore, this.nodeStore, this.propertyStore, this.cacheAccess, this.propertyLoader, 42L, TransactionApplicationMode.EXTERNAL);
        PropertyRecord before = new PropertyRecord(11L);
        PropertyRecord after = new PropertyRecord(12L);
        Command.PropertyCommand command = new Command.PropertyCommand().init(before, after);
        boolean result = applier.visitPropertyCommand(command);
        applier.apply();
        Assert.assertFalse((boolean)result);
        ((IndexingService)Mockito.verify((Object)this.indexingService, (VerificationMode)Mockito.never())).updateIndexes((IndexUpdates)Matchers.any(), Matchers.anyLong(), Matchers.anyBoolean());
    }
}

