/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.transaction.command;

import org.junit.Assert;
import org.junit.Test;
import org.neo4j.kernel.impl.index.IndexCommand;
import org.neo4j.kernel.impl.transaction.command.PhysicalLogNeoCommandReaderV2;
import org.neo4j.kernel.impl.transaction.log.CommandWriter;
import org.neo4j.kernel.impl.transaction.log.InMemoryLogChannel;
import org.neo4j.kernel.impl.transaction.log.ReadableLogChannel;
import org.neo4j.kernel.impl.transaction.log.WritableLogChannel;

public class PhysicalLogNeoCommandReaderV2Test {
    @Test
    public void shouldReadIndexCommandHeaderCorrectly() throws Exception {
        PhysicalLogNeoCommandReaderV2 reader = new PhysicalLogNeoCommandReaderV2();
        InMemoryLogChannel data = new InMemoryLogChannel();
        CommandWriter writer = new CommandWriter((WritableLogChannel)data);
        IndexCommand.AddRelationshipCommand command = new IndexCommand.AddRelationshipCommand();
        byte indexNameId = 12;
        long entityId = 123L;
        byte keyId = 1;
        String value = "test value";
        long startNode = 14L;
        long endNode = 15L;
        command.init(indexNameId, entityId, keyId, (Object)value, startNode, endNode);
        writer.visitIndexAddRelationshipCommand(command);
        IndexCommand.AddRelationshipCommand readCommand = (IndexCommand.AddRelationshipCommand)reader.read((ReadableLogChannel)data);
        Assert.assertEquals((long)indexNameId, (long)readCommand.getIndexNameId());
        Assert.assertEquals((long)entityId, (long)readCommand.getEntityId());
        Assert.assertEquals((long)keyId, (long)readCommand.getKeyId());
        Assert.assertEquals((Object)value, (Object)readCommand.getValue());
        Assert.assertEquals((long)startNode, (long)readCommand.getStartNode());
        Assert.assertEquals((long)endNode, (long)readCommand.getEndNode());
    }
}

