/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.transaction.command;

import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;
import org.neo4j.kernel.impl.store.record.Record;
import org.neo4j.kernel.impl.store.record.RelationshipRecord;
import org.neo4j.kernel.impl.transaction.command.Command;
import org.neo4j.kernel.impl.transaction.command.PhysicalLogNeoCommandReaderV0_19;
import org.neo4j.kernel.impl.transaction.log.ReadableLogChannel;

public class PhysicalNeoCommandReaderV0_19Test {
    @Test
    public void testReturnsRelationshipCommandsWithProperFirstInChainFlags() throws Exception {
        PhysicalLogNeoCommandReaderV0_19 reader = new PhysicalLogNeoCommandReaderV0_19();
        RelationshipRecord writtenRecord = new RelationshipRecord(1L, 2L, 3L, 4);
        writtenRecord.setInUse(true);
        writtenRecord.setSecondPrevRel(3L);
        writtenRecord.setFirstPrevRel((long)Record.NO_PREV_RELATIONSHIP.intValue());
        writtenRecord.setFirstInSecondChain(false);
        ReadableLogChannel mockChannel = (ReadableLogChannel)Mockito.mock(ReadableLogChannel.class);
        Mockito.when((Object)mockChannel.get()).thenReturn((Object)3).thenReturn((Object)1);
        Mockito.when((Object)mockChannel.getLong()).thenReturn((Object)writtenRecord.getId()).thenReturn((Object)writtenRecord.getFirstNode()).thenReturn((Object)writtenRecord.getSecondNode()).thenReturn((Object)writtenRecord.getFirstPrevRel()).thenReturn((Object)writtenRecord.getFirstNextRel()).thenReturn((Object)writtenRecord.getSecondPrevRel()).thenReturn((Object)writtenRecord.getSecondNextRel()).thenReturn((Object)writtenRecord.getNextProp());
        Mockito.when((Object)mockChannel.getInt()).thenReturn((Object)writtenRecord.getType());
        Command result = reader.read(mockChannel);
        Assert.assertTrue((boolean)(result instanceof Command.RelationshipCommand));
        Command.RelationshipCommand relCommand = (Command.RelationshipCommand)result;
        RelationshipRecord readRecord = relCommand.getRecord();
        Assert.assertTrue((boolean)readRecord.isFirstInFirstChain());
        Assert.assertFalse((boolean)readRecord.isFirstInSecondChain());
    }
}

