/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.transaction.log;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Future;
import org.junit.Rule;
import org.junit.Test;
import org.mockito.Mockito;
import org.neo4j.function.Factory;
import org.neo4j.kernel.impl.transaction.log.BatchingPhysicalTransactionAppender;
import org.neo4j.kernel.impl.transaction.log.ControlledParkStrategy;
import org.neo4j.kernel.impl.transaction.log.InMemoryLogChannel;
import org.neo4j.kernel.impl.transaction.log.LogFile;
import org.neo4j.kernel.impl.transaction.log.LogRotation;
import org.neo4j.kernel.impl.transaction.log.ParkStrategy;
import org.neo4j.kernel.impl.transaction.log.TransactionIdStore;
import org.neo4j.kernel.impl.transaction.log.TransactionMetadataCache;
import org.neo4j.kernel.impl.util.Counter;
import org.neo4j.kernel.impl.util.IdOrderingQueue;
import org.neo4j.test.CleanupRule;
import org.neo4j.test.OtherThreadExecutor;

public class BatchingPhysicalTransactionAppenderTest {
    @Rule
    public final CleanupRule cleanup = new CleanupRule();

    @Test
    public void shouldWaitOnCorrectTicket() throws Exception {
        long highestValueBeforeWrappingAround = 3L;
        LogFile logFile = (LogFile)Mockito.mock(LogFile.class);
        Mockito.when((Object)logFile.getWriter()).thenReturn((Object)new InMemoryLogChannel());
        TransactionMetadataCache cache = new TransactionMetadataCache(10, 10);
        TransactionIdStore transactionIdStore = (TransactionIdStore)Mockito.mock(TransactionIdStore.class);
        LimitedCounterFactory counters = new LimitedCounterFactory(highestValueBeforeWrappingAround, 0L);
        ControlledParkStrategy forceThreadControl = new ControlledParkStrategy();
        BatchingPhysicalTransactionAppender appender = new BatchingPhysicalTransactionAppender(logFile, (LogRotation)Mockito.mock(LogRotation.class), cache, transactionIdStore, IdOrderingQueue.BYPASS, (Factory)counters, (ParkStrategy)forceThreadControl);
        Counter appendCounter = (Counter)counters.createdCounters.get(0);
        OtherThreadExecutor<Object> t2 = this.cleanup.add(new OtherThreadExecutor<Object>("T2", null));
        this.assertForceAfterAppendAwaitsCorrectForceTicket(t2, appender, forceThreadControl, appendCounter);
    }

    @Test
    public void shouldHandleTicketsWrappingAround() throws Exception {
        long highestValueBeforeWrappingAround = 3L;
        LogFile logFile = (LogFile)Mockito.mock(LogFile.class);
        Mockito.when((Object)logFile.getWriter()).thenReturn((Object)new InMemoryLogChannel());
        TransactionMetadataCache cache = new TransactionMetadataCache(10, 10);
        TransactionIdStore transactionIdStore = (TransactionIdStore)Mockito.mock(TransactionIdStore.class);
        LimitedCounterFactory counters = new LimitedCounterFactory(highestValueBeforeWrappingAround, highestValueBeforeWrappingAround);
        ControlledParkStrategy forceThreadControl = new ControlledParkStrategy();
        BatchingPhysicalTransactionAppender appender = new BatchingPhysicalTransactionAppender(logFile, (LogRotation)Mockito.mock(LogRotation.class), cache, transactionIdStore, IdOrderingQueue.BYPASS, (Factory)counters, (ParkStrategy)forceThreadControl);
        Counter appendCounter = (Counter)counters.createdCounters.get(0);
        OtherThreadExecutor<Object> t2 = this.cleanup.add(new OtherThreadExecutor<Object>("T2", null));
        this.assertForceAfterAppendAwaitsCorrectForceTicket(t2, appender, forceThreadControl, appendCounter);
    }

    private void assertForceAfterAppendAwaitsCorrectForceTicket(OtherThreadExecutor<Void> t2, BatchingPhysicalTransactionAppender appender, ControlledParkStrategy forceThreadControl, Counter appendCounter) throws Exception {
        forceThreadControl.awaitIdle();
        long ticket = appendCounter.incrementAndGet();
        Future<Object> forceFuture = t2.executeDontWait(this.forceAfterAppend(appender, ticket));
        forceThreadControl.unpark(Thread.currentThread());
        forceFuture.get();
    }

    private OtherThreadExecutor.WorkerCommand<Void, Object> forceAfterAppend(final BatchingPhysicalTransactionAppender appender, final long ticket) {
        return new OtherThreadExecutor.WorkerCommand<Void, Object>(){

            @Override
            public Object doWork(Void state) throws Exception {
                appender.forceAfterAppend(ticket);
                return null;
            }
        };
    }

    private static class LimitedCounterFactory
    implements Factory<Counter> {
        private final List<Counter> createdCounters = new ArrayList<Counter>();
        private final long highestValue;
        private final long initialValue;

        public LimitedCounterFactory(long highestValue, long initialValue) {
            this.highestValue = highestValue;
            this.initialValue = initialValue;
        }

        public Counter newInstance() {
            Counter counter = new Counter(){
                private long value;
                {
                    this.value = LimitedCounterFactory.this.initialValue;
                }

                public void set(long value) {
                    assert (value <= LimitedCounterFactory.this.highestValue && value >= -LimitedCounterFactory.this.highestValue - 1L);
                    this.value = value;
                }

                public long incrementAndGet() {
                    ++this.value;
                    if (this.value > LimitedCounterFactory.this.highestValue) {
                        this.value = -LimitedCounterFactory.this.highestValue - 1L;
                    }
                    return this.value;
                }

                public long get() {
                    return this.value;
                }
            };
            this.createdCounters.add(counter);
            return counter;
        }
    }
}

