/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.transaction.log;

import java.io.File;
import java.io.IOException;
import java.util.concurrent.atomic.AtomicBoolean;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.mockito.Mockito;
import org.neo4j.helpers.collection.Visitor;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.kernel.DefaultFileSystemAbstraction;
import org.neo4j.kernel.impl.transaction.DeadSimpleLogVersionRepository;
import org.neo4j.kernel.impl.transaction.DeadSimpleTransactionIdStore;
import org.neo4j.kernel.impl.transaction.log.LogFile;
import org.neo4j.kernel.impl.transaction.log.LogPosition;
import org.neo4j.kernel.impl.transaction.log.LogPositionMarker;
import org.neo4j.kernel.impl.transaction.log.LogRotationControl;
import org.neo4j.kernel.impl.transaction.log.LogVersionRepository;
import org.neo4j.kernel.impl.transaction.log.PhysicalLogFile;
import org.neo4j.kernel.impl.transaction.log.PhysicalLogFiles;
import org.neo4j.kernel.impl.transaction.log.ReadableLogChannel;
import org.neo4j.kernel.impl.transaction.log.ReadableVersionableLogChannel;
import org.neo4j.kernel.impl.transaction.log.TransactionIdStore;
import org.neo4j.kernel.impl.transaction.log.TransactionMetadataCache;
import org.neo4j.kernel.impl.transaction.log.WritableLogChannel;
import org.neo4j.kernel.impl.transaction.log.entry.LogHeader;
import org.neo4j.kernel.impl.transaction.log.entry.LogHeaderReader;
import org.neo4j.kernel.lifecycle.LifeSupport;
import org.neo4j.test.TargetDirectory;

public class PhysicalLogFileTest {
    private final FileSystemAbstraction fs = new DefaultFileSystemAbstraction();
    @Rule
    public final TargetDirectory.TestDirectory directory = TargetDirectory.testDirForTest(this.getClass());
    private final LogVersionRepository logVersionRepository = new DeadSimpleLogVersionRepository(1L);
    private final TransactionIdStore transactionIdStore = new DeadSimpleTransactionIdStore(5L, 0L);
    private static final Visitor<ReadableVersionableLogChannel, IOException> NO_RECOVERY_EXPECTED = new Visitor<ReadableVersionableLogChannel, IOException>(){

        public boolean visit(ReadableVersionableLogChannel element) throws IOException {
            Assert.fail((String)"No recovery expected");
            return false;
        }
    };

    @Test
    public void shouldOpenInFreshDirectoryAndFinallyAddHeader() throws Exception {
        String name = "log";
        LogRotationControl logRotationControl = (LogRotationControl)Mockito.mock(LogRotationControl.class);
        LifeSupport life = new LifeSupport();
        PhysicalLogFiles logFiles = new PhysicalLogFiles(this.directory.directory(), name, this.fs);
        life.add((Object)new PhysicalLogFile(this.fs, logFiles, 1000L, this.transactionIdStore, this.logVersionRepository, (PhysicalLogFile.Monitor)Mockito.mock(PhysicalLogFile.Monitor.class), new TransactionMetadataCache(10, 100)));
        life.start();
        life.shutdown();
        File file = new PhysicalLogFiles(this.directory.directory(), name, this.fs).getLogFileForVersion(1L);
        LogHeader header = LogHeaderReader.readLogHeader((FileSystemAbstraction)this.fs, (File)file);
        Assert.assertEquals((long)1L, (long)header.logVersion);
        Assert.assertEquals((long)5L, (long)header.lastCommittedTxId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void shouldWriteSomeDataIntoTheLog() throws Exception {
        String name = "log";
        LogRotationControl logRotationControl = (LogRotationControl)Mockito.mock(LogRotationControl.class);
        LifeSupport life = new LifeSupport();
        PhysicalLogFiles logFiles = new PhysicalLogFiles(this.directory.directory(), name, this.fs);
        PhysicalLogFile.Monitor monitor = (PhysicalLogFile.Monitor)Mockito.mock(PhysicalLogFile.Monitor.class);
        LogFile logFile = (LogFile)life.add((Object)new PhysicalLogFile(this.fs, logFiles, 1000L, this.transactionIdStore, this.logVersionRepository, monitor, new TransactionMetadataCache(10, 100)));
        try {
            life.start();
            WritableLogChannel writer = logFile.getWriter();
            LogPositionMarker positionMarker = new LogPositionMarker();
            writer.getCurrentPosition(positionMarker);
            int intValue = 45;
            long longValue = 4854587L;
            writer.putInt(intValue);
            writer.putLong(longValue);
            writer.emptyBufferIntoChannelAndClearIt();
            writer.force();
            try (ReadableVersionableLogChannel reader = logFile.getReader(positionMarker.newPosition());){
                Assert.assertEquals((long)intValue, (long)reader.getInt());
                Assert.assertEquals((long)longValue, (long)reader.getLong());
            }
        }
        finally {
            life.shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void shouldReadOlderLogs() throws Exception {
        String name = "log";
        LogRotationControl logRotationControl = (LogRotationControl)Mockito.mock(LogRotationControl.class);
        LifeSupport life = new LifeSupport();
        PhysicalLogFiles logFiles = new PhysicalLogFiles(this.directory.directory(), name, this.fs);
        LogFile logFile = (LogFile)life.add((Object)new PhysicalLogFile(this.fs, logFiles, 50L, this.transactionIdStore, this.logVersionRepository, (PhysicalLogFile.Monitor)Mockito.mock(PhysicalLogFile.Monitor.class), new TransactionMetadataCache(10, 100)));
        life.start();
        try {
            WritableLogChannel writer = logFile.getWriter();
            LogPositionMarker positionMarker = new LogPositionMarker();
            writer.getCurrentPosition(positionMarker);
            LogPosition position1 = positionMarker.newPosition();
            int intValue = 45;
            long longValue = 4854587L;
            byte[] someBytes = this.someBytes(40);
            writer.putInt(intValue);
            writer.putLong(longValue);
            writer.put(someBytes, someBytes.length);
            writer.emptyBufferIntoChannelAndClearIt();
            writer.force();
            writer.getCurrentPosition(positionMarker);
            LogPosition position2 = positionMarker.newPosition();
            long longValue2 = 123456789L;
            writer.putLong(longValue2);
            writer.put(someBytes, someBytes.length);
            writer.emptyBufferIntoChannelAndClearIt();
            writer.force();
            try (ReadableVersionableLogChannel reader = logFile.getReader(position1);){
                Assert.assertEquals((long)intValue, (long)reader.getInt());
                Assert.assertEquals((long)longValue, (long)reader.getLong());
                Assert.assertArrayEquals((byte[])someBytes, (byte[])this.readBytes((ReadableLogChannel)reader, 40));
            }
            reader = logFile.getReader(position2);
            var17_15 = null;
            try {
                Assert.assertEquals((long)longValue2, (long)reader.getLong());
                Assert.assertArrayEquals((byte[])someBytes, (byte[])this.readBytes((ReadableLogChannel)reader, 40));
            }
            catch (Throwable throwable) {
                var17_15 = throwable;
                throw throwable;
            }
            finally {
                if (reader != null) {
                    if (var17_15 != null) {
                        try {
                            reader.close();
                        }
                        catch (Throwable x2) {
                            var17_15.addSuppressed(x2);
                        }
                    } else {
                        reader.close();
                    }
                }
            }
        }
        finally {
            life.shutdown();
        }
    }

    @Test
    public void shouldVisitLogFile() throws Exception {
        String name = "log";
        LogRotationControl logRotationControl = (LogRotationControl)Mockito.mock(LogRotationControl.class);
        LifeSupport life = new LifeSupport();
        PhysicalLogFiles logFiles = new PhysicalLogFiles(this.directory.directory(), name, this.fs);
        LogFile logFile = (LogFile)life.add((Object)new PhysicalLogFile(this.fs, logFiles, 50L, this.transactionIdStore, this.logVersionRepository, (PhysicalLogFile.Monitor)Mockito.mock(PhysicalLogFile.Monitor.class), new TransactionMetadataCache(10, 100)));
        life.start();
        WritableLogChannel writer = logFile.getWriter();
        LogPositionMarker mark = new LogPositionMarker();
        writer.getCurrentPosition(mark);
        for (int i = 0; i < 5; ++i) {
            writer.put((byte)i);
        }
        writer.emptyBufferIntoChannelAndClearIt();
        final AtomicBoolean called = new AtomicBoolean();
        logFile.accept(new LogFile.LogFileVisitor(){

            public boolean visit(LogPosition position, ReadableVersionableLogChannel channel) throws IOException {
                for (int i = 0; i < 5; ++i) {
                    Assert.assertEquals((long)((byte)i), (long)channel.get());
                }
                called.set(true);
                return true;
            }
        }, mark.newPosition());
        Assert.assertTrue((boolean)called.get());
        life.shutdown();
    }

    private byte[] readBytes(ReadableLogChannel reader, int length) throws IOException {
        byte[] result = new byte[length];
        reader.get(result, length);
        return result;
    }

    private byte[] someBytes(int length) {
        byte[] result = new byte[length];
        for (int i = 0; i < length; ++i) {
            result[i] = (byte)(i % 5);
        }
        return result;
    }
}

