/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.transaction.log;

import java.io.File;
import java.io.IOException;
import java.nio.ByteBuffer;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.io.fs.StoreChannel;
import org.neo4j.kernel.DefaultFileSystemAbstraction;
import org.neo4j.kernel.impl.transaction.log.LogPosition;
import org.neo4j.kernel.impl.transaction.log.LogPositionMarker;
import org.neo4j.kernel.impl.transaction.log.LogVersionedStoreChannel;
import org.neo4j.kernel.impl.transaction.log.PhysicalLogVersionedStoreChannel;
import org.neo4j.kernel.impl.transaction.log.PhysicalWritableLogChannel;
import org.neo4j.test.TargetDirectory;

public class PhysicalWritableLogChannelTest {
    private final FileSystemAbstraction fs = new DefaultFileSystemAbstraction();
    @Rule
    public final TargetDirectory.TestDirectory directory = TargetDirectory.testDirForTest(this.getClass());

    @Test
    public void shouldWriteThroughRotation() throws Exception {
        File firstFile = new File(this.directory.directory(), "file1");
        File secondFile = new File(this.directory.directory(), "file2");
        StoreChannel storeChannel = this.fs.open(firstFile, "rw");
        PhysicalLogVersionedStoreChannel versionedStoreChannel = new PhysicalLogVersionedStoreChannel(storeChannel, 1L, -1);
        PhysicalWritableLogChannel channel = new PhysicalWritableLogChannel((LogVersionedStoreChannel)versionedStoreChannel);
        byte byteValue = 4;
        short shortValue = 10;
        int intValue = 3545;
        long longValue = 45849589L;
        float floatValue = 45849.332f;
        double doubleValue = 4.58493343E8;
        byte[] byteArrayValue = new byte[]{1, 4, 2, 5, 3, 6};
        channel.put(byteValue);
        channel.putShort(shortValue);
        channel.putInt(intValue);
        channel.putLong(longValue);
        channel.emptyBufferIntoChannelAndClearIt();
        channel.force();
        storeChannel = this.fs.open(secondFile, "rw");
        channel.setChannel((LogVersionedStoreChannel)new PhysicalLogVersionedStoreChannel(storeChannel, 2L, -1));
        channel.putFloat(floatValue);
        channel.putDouble(doubleValue);
        channel.put(byteArrayValue, byteArrayValue.length);
        channel.close();
        ByteBuffer firstFileContents = this.readFile(firstFile);
        Assert.assertEquals((long)byteValue, (long)firstFileContents.get());
        Assert.assertEquals((long)shortValue, (long)firstFileContents.getShort());
        Assert.assertEquals((long)intValue, (long)firstFileContents.getInt());
        Assert.assertEquals((long)longValue, (long)firstFileContents.getLong());
        ByteBuffer secondFileContents = this.readFile(secondFile);
        Assert.assertEquals((float)floatValue, (float)secondFileContents.getFloat(), (float)0.0f);
        Assert.assertEquals((double)doubleValue, (double)secondFileContents.getDouble(), (double)0.0);
        byte[] readByteArray = new byte[byteArrayValue.length];
        secondFileContents.get(readByteArray);
        Assert.assertArrayEquals((byte[])byteArrayValue, (byte[])readByteArray);
    }

    @Test
    public void shouldSeeCorrectPositionEvenBeforeEmptyingDataIntoChannel() throws Exception {
        File file = new File(this.directory.directory(), "file");
        StoreChannel storeChannel = this.fs.open(file, "rw");
        PhysicalLogVersionedStoreChannel versionedStoreChannel = new PhysicalLogVersionedStoreChannel(storeChannel, 1L, -1);
        PhysicalWritableLogChannel channel = new PhysicalWritableLogChannel((LogVersionedStoreChannel)versionedStoreChannel);
        LogPositionMarker positionMarker = new LogPositionMarker();
        LogPosition initialPosition = channel.getCurrentPosition(positionMarker).newPosition();
        channel.putLong(67L);
        channel.putInt(1234);
        LogPosition positionAfterSomeData = channel.getCurrentPosition(positionMarker).newPosition();
        Assert.assertEquals((long)12L, (long)(positionAfterSomeData.getByteOffset() - initialPosition.getByteOffset()));
    }

    private ByteBuffer readFile(File file) throws IOException {
        try (StoreChannel channel = this.fs.open(file, "r");){
            ByteBuffer buffer = ByteBuffer.allocate((int)channel.size());
            channel.read(buffer);
            buffer.flip();
            ByteBuffer byteBuffer = buffer;
            return byteBuffer;
        }
    }
}

