/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.transaction.log.entry;

import org.junit.Assert;
import org.junit.Test;
import org.neo4j.kernel.impl.transaction.log.entry.DefaultLogEntryParserFactory;
import org.neo4j.kernel.impl.transaction.log.entry.LogEntryParserDispatcher;

public class DefaultLogEntryParserFactoryTest {
    private final DefaultLogEntryParserFactory factory = new DefaultLogEntryParserFactory();

    @Test
    public void shouldBeAbleToConstructAParserForLogVersion5() {
        Assert.assertNotNull((Object)this.factory.newInstance((byte)5));
    }

    @Test
    public void shouldBeAbleToConstructAParserForLogVersion4() {
        Assert.assertNotNull((Object)this.factory.newInstance((byte)4));
    }

    @Test(expected=IllegalStateException.class)
    public void shouldBeAbleToConstructAParserForAnyOtherVersion() {
        Assert.assertNotNull((Object)this.factory.newInstance((byte)1));
    }

    @Test
    public void shouldBeAbleToCacheAParserForLogVersion4() {
        LogEntryParserDispatcher first = this.factory.newInstance((byte)4);
        Assert.assertNotNull((Object)first);
        LogEntryParserDispatcher second = this.factory.newInstance((byte)4);
        Assert.assertNotNull((Object)second);
        Assert.assertSame((Object)first, (Object)second);
    }

    @Test
    public void shouldBeAbleToCacheAParserForLogVersion5() {
        LogEntryParserDispatcher first = this.factory.newInstance((byte)5);
        Assert.assertNotNull((Object)first);
        LogEntryParserDispatcher second = this.factory.newInstance((byte)5);
        Assert.assertNotNull((Object)second);
        Assert.assertSame((Object)first, (Object)second);
    }
}

