/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.transaction.log.entry;

import org.junit.Test;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.neo4j.helpers.Function;
import org.neo4j.kernel.impl.transaction.command.LogHandler;
import org.neo4j.kernel.impl.transaction.log.LogPosition;
import org.neo4j.kernel.impl.transaction.log.entry.LogEntry;
import org.neo4j.kernel.impl.transaction.log.entry.LogEntryCommand;
import org.neo4j.kernel.impl.transaction.log.entry.LogEntryStart;
import org.neo4j.kernel.impl.transaction.log.entry.OnePhaseCommit;
import org.neo4j.kernel.impl.transaction.log.entry.TranslatingEntryVisitor;

public class LogEntryConsumerTest {
    @Test
    public void ensureCurrentVersionEntriesAreHandledImmediately() throws Exception {
        TranslatingEntryVisitor consumer = new TranslatingEntryVisitor((Function)Mockito.mock(Function.class));
        LogHandler handler = (LogHandler)Mockito.mock(LogHandler.class);
        consumer.bind(handler);
        LogEntryStart start = new LogEntryStart(1, 2, 3L, 4L, new byte[1], (LogPosition)Mockito.mock(LogPosition.class));
        consumer.visit((LogEntry)start);
        ((LogHandler)Mockito.verify((Object)handler, (VerificationMode)Mockito.times((int)1))).startEntry(start);
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{handler});
        LogEntryCommand command = new LogEntryCommand(null);
        consumer.visit((LogEntry)command);
        ((LogHandler)Mockito.verify((Object)handler, (VerificationMode)Mockito.times((int)1))).commandEntry(command);
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{handler});
        OnePhaseCommit onePC = new OnePhaseCommit(1L, 2L);
        consumer.visit((LogEntry)onePC);
        ((LogHandler)Mockito.verify((Object)handler, (VerificationMode)Mockito.times((int)1))).onePhaseCommitEntry(onePC);
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{handler});
    }
}

