/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.transaction.log.entry;

import java.io.IOException;
import org.junit.Assert;
import org.junit.Test;
import org.neo4j.kernel.impl.transaction.command.Command;
import org.neo4j.kernel.impl.transaction.command.CommandReaderFactory;
import org.neo4j.kernel.impl.transaction.log.InMemoryLogChannel;
import org.neo4j.kernel.impl.transaction.log.LogPosition;
import org.neo4j.kernel.impl.transaction.log.LogPositionMarker;
import org.neo4j.kernel.impl.transaction.log.ReadableLogChannel;
import org.neo4j.kernel.impl.transaction.log.entry.IdentifiableLogEntry;
import org.neo4j.kernel.impl.transaction.log.entry.LogEntryCommand;
import org.neo4j.kernel.impl.transaction.log.entry.LogEntryParser;
import org.neo4j.kernel.impl.transaction.log.entry.LogEntryParserDispatcher;
import org.neo4j.kernel.impl.transaction.log.entry.LogEntryParsersV2;
import org.neo4j.kernel.impl.transaction.log.entry.LogEntryStart;
import org.neo4j.kernel.impl.transaction.log.entry.OnePhaseCommit;

public class LogEntryParserDispatcherV2Test {
    private final LogEntryParserDispatcher<LogEntryParsersV2> dispatcher = new LogEntryParserDispatcher((LogEntryParser[])LogEntryParsersV2.values());
    private final CommandReaderFactory.Default commandReaderFactory = new CommandReaderFactory.Default();
    private final byte version = 0;
    private final LogPositionMarker marker = new LogPositionMarker();
    private final LogPosition position = new LogPosition(0L, 29L);

    @Test
    public void shouldParserStartEntry() throws IOException {
        LogEntryStart start = new LogEntryStart(0, 1, 2, 3L, -1L, new byte[0], this.position);
        InMemoryLogChannel channel = new InMemoryLogChannel();
        channel.put((byte)1);
        channel.put((byte)2);
        channel.put(new byte[]{42}, 1);
        channel.put(new byte[]{21, 12}, 2);
        channel.putInt(123);
        channel.putInt(456);
        channel.putInt(start.getMasterId());
        channel.putInt(start.getLocalId());
        channel.putLong(start.getTimeWritten());
        channel.getCurrentPosition(this.marker);
        LogEntryParser parser = this.dispatcher.dispatch((byte)1);
        IdentifiableLogEntry logEntry = (IdentifiableLogEntry)parser.parse((byte)0, (ReadableLogChannel)channel, this.marker, (CommandReaderFactory)this.commandReaderFactory);
        Assert.assertEquals((Object)start, (Object)logEntry.getEntry());
        Assert.assertFalse((boolean)parser.skip());
    }

    @Test
    public void shouldParserOnePhaseCommitEntry() throws IOException {
        OnePhaseCommit commit = new OnePhaseCommit(0, 42L, 21L);
        InMemoryLogChannel channel = new InMemoryLogChannel();
        channel.putInt(123);
        channel.putLong(commit.getTxId());
        channel.putLong(commit.getTimeWritten());
        channel.getCurrentPosition(this.marker);
        LogEntryParser parser = this.dispatcher.dispatch((byte)5);
        IdentifiableLogEntry logEntry = (IdentifiableLogEntry)parser.parse((byte)0, (ReadableLogChannel)channel, this.marker, (CommandReaderFactory)this.commandReaderFactory);
        Assert.assertEquals((Object)commit, (Object)logEntry.getEntry());
        Assert.assertFalse((boolean)parser.skip());
    }

    @Test
    public void shouldParseTwoPhaseCommitEntryAndMapThemIntoOnePhaseCommit() throws IOException {
        OnePhaseCommit commit = new OnePhaseCommit(0, 42L, 21L);
        InMemoryLogChannel channel = new InMemoryLogChannel();
        channel.putInt(123);
        channel.putLong(commit.getTxId());
        channel.putLong(commit.getTimeWritten());
        channel.getCurrentPosition(this.marker);
        LogEntryParser parser = this.dispatcher.dispatch((byte)6);
        IdentifiableLogEntry logEntry = (IdentifiableLogEntry)parser.parse((byte)0, (ReadableLogChannel)channel, this.marker, (CommandReaderFactory)this.commandReaderFactory);
        Assert.assertEquals((Object)commit, (Object)logEntry.getEntry());
        Assert.assertFalse((boolean)parser.skip());
    }

    @Test
    public void shouldParserCommandsUsingAGivenFactory() throws IOException {
        Command.NodeCommand nodeCommand = new Command.NodeCommand();
        LogEntryCommand command = new LogEntryCommand(0, (Command)nodeCommand);
        InMemoryLogChannel channel = new InMemoryLogChannel();
        channel.putInt(123);
        channel.put((byte)1);
        channel.getCurrentPosition(this.marker);
        LogEntryParser parser = this.dispatcher.dispatch((byte)3);
        IdentifiableLogEntry logEntry = (IdentifiableLogEntry)parser.parse((byte)0, (ReadableLogChannel)channel, this.marker, (CommandReaderFactory)this.commandReaderFactory);
        Assert.assertEquals((Object)command, (Object)logEntry.getEntry());
        Assert.assertFalse((boolean)parser.skip());
    }

    @Test
    public void shouldParseEmptyEntry() throws IOException {
        LogEntryParser parser = this.dispatcher.dispatch((byte)0);
        IdentifiableLogEntry logEntry = (IdentifiableLogEntry)parser.parse((byte)0, (ReadableLogChannel)new InMemoryLogChannel(), this.marker, (CommandReaderFactory)this.commandReaderFactory);
        Assert.assertNull((Object)logEntry);
        Assert.assertFalse((boolean)parser.skip());
    }

    @Test
    public void shouldParsePrepareEntry() throws IOException {
        int nextByte = 7;
        InMemoryLogChannel channel = new InMemoryLogChannel();
        channel.putInt(123);
        channel.putLong(456L);
        channel.put((byte)7);
        channel.getCurrentPosition(this.marker);
        LogEntryParser parser = this.dispatcher.dispatch((byte)2);
        IdentifiableLogEntry logEntry = (IdentifiableLogEntry)parser.parse((byte)0, (ReadableLogChannel)channel, this.marker, (CommandReaderFactory)this.commandReaderFactory);
        Assert.assertNull((Object)logEntry);
        Assert.assertTrue((boolean)parser.skip());
        Assert.assertEquals((long)7L, (long)channel.get());
    }

    @Test
    public void shouldParseDoneEntry() throws IOException {
        int nextByte = 7;
        InMemoryLogChannel channel = new InMemoryLogChannel();
        channel.putInt(123);
        channel.put((byte)7);
        channel.getCurrentPosition(this.marker);
        LogEntryParser parser = this.dispatcher.dispatch((byte)4);
        IdentifiableLogEntry logEntry = (IdentifiableLogEntry)parser.parse((byte)0, (ReadableLogChannel)channel, this.marker, (CommandReaderFactory)this.commandReaderFactory);
        Assert.assertNull((Object)logEntry);
        Assert.assertTrue((boolean)parser.skip());
        Assert.assertEquals((long)7L, (long)channel.get());
    }
}

