/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.transaction.log.entry;

import java.io.IOException;
import org.junit.Assert;
import org.junit.Test;
import org.neo4j.kernel.impl.transaction.command.Command;
import org.neo4j.kernel.impl.transaction.command.CommandReaderFactory;
import org.neo4j.kernel.impl.transaction.log.InMemoryLogChannel;
import org.neo4j.kernel.impl.transaction.log.LogPosition;
import org.neo4j.kernel.impl.transaction.log.LogPositionMarker;
import org.neo4j.kernel.impl.transaction.log.ReadableLogChannel;
import org.neo4j.kernel.impl.transaction.log.entry.LogEntry;
import org.neo4j.kernel.impl.transaction.log.entry.LogEntryCommand;
import org.neo4j.kernel.impl.transaction.log.entry.LogEntryParser;
import org.neo4j.kernel.impl.transaction.log.entry.LogEntryParserDispatcher;
import org.neo4j.kernel.impl.transaction.log.entry.LogEntryParsersV5;
import org.neo4j.kernel.impl.transaction.log.entry.LogEntryStart;
import org.neo4j.kernel.impl.transaction.log.entry.OnePhaseCommit;

public class LogEntryParserDispatcherV5Test {
    private final LogEntryParserDispatcher<LogEntryParsersV5> dispatcher = new LogEntryParserDispatcher((LogEntryParser[])LogEntryParsersV5.values());
    private final CommandReaderFactory.Default commandReaderFactory = new CommandReaderFactory.Default();
    private final byte version = (byte)-2;
    private final LogPositionMarker marker = new LogPositionMarker();
    private final LogPosition position = new LogPosition(0L, 29L);

    @Test
    public void shouldParserStartEntry() throws IOException {
        LogEntryStart start = new LogEntryStart(-2, 1, 2, 3L, 4L, new byte[]{5}, this.position);
        InMemoryLogChannel channel = new InMemoryLogChannel();
        channel.putInt(start.getMasterId());
        channel.putInt(start.getLocalId());
        channel.putLong(start.getTimeWritten());
        channel.putLong(start.getLastCommittedTxWhenTransactionStarted());
        channel.putInt(start.getAdditionalHeader().length);
        channel.put(start.getAdditionalHeader(), start.getAdditionalHeader().length);
        channel.getCurrentPosition(this.marker);
        LogEntryParser parser = this.dispatcher.dispatch((byte)1);
        LogEntry logEntry = parser.parse((byte)-2, (ReadableLogChannel)channel, this.marker, (CommandReaderFactory)this.commandReaderFactory);
        Assert.assertEquals((Object)start, (Object)logEntry);
        Assert.assertFalse((boolean)parser.skip());
    }

    @Test
    public void shouldParserOnePhaseCommitEntry() throws IOException {
        OnePhaseCommit commit = new OnePhaseCommit(-2, 42L, 21L);
        InMemoryLogChannel channel = new InMemoryLogChannel();
        channel.putLong(commit.getTxId());
        channel.putLong(commit.getTimeWritten());
        channel.getCurrentPosition(this.marker);
        LogEntryParser parser = this.dispatcher.dispatch((byte)5);
        LogEntry logEntry = parser.parse((byte)-2, (ReadableLogChannel)channel, this.marker, (CommandReaderFactory)this.commandReaderFactory);
        Assert.assertEquals((Object)commit, (Object)logEntry);
        Assert.assertFalse((boolean)parser.skip());
    }

    @Test
    public void shouldParserCommandsUsingAGivenFactory() throws IOException {
        Command.NodeCommand nodeCommand = new Command.NodeCommand();
        LogEntryCommand command = new LogEntryCommand(-2, (Command)nodeCommand);
        InMemoryLogChannel channel = new InMemoryLogChannel();
        channel.put((byte)1);
        channel.getCurrentPosition(this.marker);
        LogEntryParser parser = this.dispatcher.dispatch((byte)3);
        LogEntry logEntry = parser.parse((byte)-2, (ReadableLogChannel)channel, this.marker, (CommandReaderFactory)this.commandReaderFactory);
        Assert.assertEquals((Object)command, (Object)logEntry);
        Assert.assertFalse((boolean)parser.skip());
    }

    @Test
    public void shouldParseEmptyEntry() throws IOException {
        LogEntryParser parser = this.dispatcher.dispatch((byte)0);
        LogEntry logEntry = parser.parse((byte)-2, (ReadableLogChannel)new InMemoryLogChannel(), this.marker, (CommandReaderFactory)this.commandReaderFactory);
        Assert.assertNull((Object)logEntry);
        Assert.assertFalse((boolean)parser.skip());
    }

    @Test
    public void shouldThrowWhenParsingPrepareEntry() throws IOException {
        LogEntryParser parser = this.dispatcher.dispatch((byte)2);
        Assert.assertNull((Object)parser);
    }

    @Test
    public void shouldThrowWhenParsingTwoPhaseCommitEntry() throws IOException {
        LogEntryParser parser = this.dispatcher.dispatch((byte)6);
        Assert.assertNull((Object)parser);
    }

    @Test
    public void shouldThrowWhenParsingDoneEntry() throws IOException {
        LogEntryParser parser = this.dispatcher.dispatch((byte)4);
        Assert.assertNull((Object)parser);
    }
}

