/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.transaction.log.entry;

import java.io.IOException;
import org.junit.Assert;
import org.junit.Test;
import org.neo4j.kernel.impl.transaction.command.Command;
import org.neo4j.kernel.impl.transaction.command.CommandReaderFactory;
import org.neo4j.kernel.impl.transaction.log.InMemoryLogChannel;
import org.neo4j.kernel.impl.transaction.log.LogPosition;
import org.neo4j.kernel.impl.transaction.log.ReadableLogChannel;
import org.neo4j.kernel.impl.transaction.log.entry.DefaultLogEntryParserFactory;
import org.neo4j.kernel.impl.transaction.log.entry.IdentifiableLogEntry;
import org.neo4j.kernel.impl.transaction.log.entry.LogEntry;
import org.neo4j.kernel.impl.transaction.log.entry.LogEntryCommand;
import org.neo4j.kernel.impl.transaction.log.entry.LogEntryParserFactory;
import org.neo4j.kernel.impl.transaction.log.entry.LogEntryStart;
import org.neo4j.kernel.impl.transaction.log.entry.OnePhaseCommit;
import org.neo4j.kernel.impl.transaction.log.entry.VersionAwareLogEntryReader;

public class VersionAwareLogEntryReaderTest {
    private final LogEntryParserFactory logEntryParserFactory = new DefaultLogEntryParserFactory();
    private final CommandReaderFactory commandReaderFactory = new CommandReaderFactory.Default();
    private final VersionAwareLogEntryReader logEntryReader = new VersionAwareLogEntryReader(this.logEntryParserFactory, this.commandReaderFactory);
    private final byte version = (byte)-1;

    @Test
    public void shouldReadAStartLogEntry() throws IOException {
        LogEntryStart start = new LogEntryStart(-1, 1, 2, 3L, 4L, new byte[]{5}, new LogPosition(0L, 31L));
        InMemoryLogChannel channel = new InMemoryLogChannel();
        channel.put((byte)-1);
        channel.put((byte)1);
        channel.putInt(start.getMasterId());
        channel.putInt(start.getLocalId());
        channel.putLong(start.getTimeWritten());
        channel.putLong(start.getLastCommittedTxWhenTransactionStarted());
        channel.putInt(start.getAdditionalHeader().length);
        channel.put(start.getAdditionalHeader(), start.getAdditionalHeader().length);
        LogEntry logEntry = this.logEntryReader.readLogEntry((ReadableLogChannel)channel, (byte)5);
        Assert.assertEquals((Object)start, (Object)logEntry);
    }

    @Test
    public void shouldReadACommitLogEntry() throws IOException {
        OnePhaseCommit commit = new OnePhaseCommit(-1, 42L, 21L);
        InMemoryLogChannel channel = new InMemoryLogChannel();
        channel.put((byte)-1);
        channel.put((byte)5);
        channel.putLong(commit.getTxId());
        channel.putLong(commit.getTimeWritten());
        LogEntry logEntry = this.logEntryReader.readLogEntry((ReadableLogChannel)channel, (byte)5);
        Assert.assertEquals((Object)commit, (Object)logEntry);
    }

    @Test
    public void shouldReadACommandLogEntry() throws IOException {
        Command.NodeCommand nodeCommand = new Command.NodeCommand();
        LogEntryCommand command = new LogEntryCommand(-1, (Command)nodeCommand);
        InMemoryLogChannel channel = new InMemoryLogChannel();
        channel.put((byte)-1);
        channel.put((byte)3);
        channel.put((byte)1);
        LogEntry logEntry = this.logEntryReader.readLogEntry((ReadableLogChannel)channel, (byte)5);
        Assert.assertEquals((Object)command, (Object)logEntry);
    }

    @Test
    public void shouldReturnNullWhenThereIsNoCommand() throws IOException {
        InMemoryLogChannel channel = new InMemoryLogChannel();
        channel.put((byte)-1);
        channel.put((byte)3);
        channel.put((byte)0);
        LogEntry logEntry = this.logEntryReader.readLogEntry((ReadableLogChannel)channel, (byte)5);
        Assert.assertNull((Object)logEntry);
    }

    @Test
    public void shouldReturnNullWhenLogEntryIsEmpty() throws IOException {
        InMemoryLogChannel channel = new InMemoryLogChannel();
        channel.put((byte)-1);
        channel.put((byte)0);
        LogEntry logEntry = this.logEntryReader.readLogEntry((ReadableLogChannel)channel, (byte)5);
        Assert.assertNull((Object)logEntry);
    }

    @Test
    public void shouldReturnNullWhenNotEnoughDataInTheChannel() throws IOException {
        InMemoryLogChannel channel = new InMemoryLogChannel();
        LogEntry logEntry = this.logEntryReader.readLogEntry((ReadableLogChannel)channel, (byte)5);
        Assert.assertNull((Object)logEntry);
    }

    @Test
    public void shouldParseOldStartEntry() throws IOException {
        InMemoryLogChannel channel = new InMemoryLogChannel();
        LogEntryStart start = new LogEntryStart(1, 2, 3L, 4L, new byte[0], new LogPosition(0L, 37L));
        channel.put((byte)-1);
        channel.put((byte)1);
        channel.put((byte)1);
        channel.put((byte)0);
        channel.put(new byte[]{7}, 1);
        channel.put(new byte[0], 0);
        channel.putInt(123);
        channel.putInt(456);
        channel.putInt(start.getMasterId());
        channel.putInt(start.getLocalId());
        channel.putLong(start.getTimeWritten());
        channel.putLong(start.getLastCommittedTxWhenTransactionStarted());
        LogEntry logEntry = this.logEntryReader.readLogEntry((ReadableLogChannel)channel, (byte)4);
        Assert.assertTrue((boolean)(logEntry instanceof IdentifiableLogEntry));
        Assert.assertEquals((Object)start, (Object)((IdentifiableLogEntry)logEntry).getEntry());
    }

    @Test
    public void shouldParseOldOnePhaseCommit() throws IOException {
        InMemoryLogChannel channel = new InMemoryLogChannel();
        OnePhaseCommit commit = new OnePhaseCommit(42L, 456L);
        channel.put((byte)-1);
        channel.put((byte)5);
        channel.putInt(123);
        channel.putLong(commit.getTxId());
        channel.putLong(commit.getTimeWritten());
        LogEntry logEntry = this.logEntryReader.readLogEntry((ReadableLogChannel)channel, (byte)4);
        Assert.assertTrue((boolean)(logEntry instanceof IdentifiableLogEntry));
        Assert.assertEquals((Object)commit, (Object)((IdentifiableLogEntry)logEntry).getEntry());
    }

    @Test
    public void shouldParseOldTwoPhaseCommit() throws IOException {
        InMemoryLogChannel channel = new InMemoryLogChannel();
        OnePhaseCommit commit = new OnePhaseCommit(42L, 456L);
        channel.put((byte)-1);
        channel.put((byte)6);
        channel.putInt(123);
        channel.putLong(commit.getTxId());
        channel.putLong(commit.getTimeWritten());
        LogEntry logEntry = this.logEntryReader.readLogEntry((ReadableLogChannel)channel, (byte)4);
        Assert.assertTrue((boolean)(logEntry instanceof IdentifiableLogEntry));
        Assert.assertEquals((Object)commit, (Object)((IdentifiableLogEntry)logEntry).getEntry());
    }

    @Test
    public void shouldParseOldPrepareSkipItAndReadTheOneAfter() throws IOException {
        InMemoryLogChannel channel = new InMemoryLogChannel();
        OnePhaseCommit commit = new OnePhaseCommit(42L, 456L);
        channel.put((byte)-1);
        channel.put((byte)2);
        channel.putInt(123);
        channel.putLong(456L);
        channel.put((byte)-1);
        channel.put((byte)6);
        channel.putInt(123);
        channel.putLong(commit.getTxId());
        channel.putLong(commit.getTimeWritten());
        LogEntry logEntry = this.logEntryReader.readLogEntry((ReadableLogChannel)channel, (byte)4);
        Assert.assertTrue((boolean)(logEntry instanceof IdentifiableLogEntry));
        Assert.assertEquals((Object)commit, (Object)((IdentifiableLogEntry)logEntry).getEntry());
    }

    @Test
    public void shouldParseOldDoneSkipItAndReadTheOneAfter() throws IOException {
        InMemoryLogChannel channel = new InMemoryLogChannel();
        OnePhaseCommit commit = new OnePhaseCommit(42L, 456L);
        channel.put((byte)-1);
        channel.put((byte)4);
        channel.putInt(123);
        channel.put((byte)-1);
        channel.put((byte)6);
        channel.putInt(123);
        channel.putLong(commit.getTxId());
        channel.putLong(commit.getTimeWritten());
        LogEntry logEntry = this.logEntryReader.readLogEntry((ReadableLogChannel)channel, (byte)4);
        Assert.assertTrue((boolean)(logEntry instanceof IdentifiableLogEntry));
        Assert.assertEquals((Object)commit, (Object)((IdentifiableLogEntry)logEntry).getEntry());
    }

    @Test
    public void shouldParseAnOldCommandLogEntry() throws IOException {
        Command.NodeCommand nodeCommand = new Command.NodeCommand();
        LogEntryCommand command = new LogEntryCommand(-1, (Command)nodeCommand);
        InMemoryLogChannel channel = new InMemoryLogChannel();
        channel.put((byte)-1);
        channel.put((byte)3);
        channel.putInt(42);
        channel.put((byte)1);
        LogEntry logEntry = this.logEntryReader.readLogEntry((ReadableLogChannel)channel, (byte)4);
        Assert.assertTrue((boolean)(logEntry instanceof IdentifiableLogEntry));
        Assert.assertEquals((Object)command, (Object)((IdentifiableLogEntry)logEntry).getEntry());
    }

    @Test
    public void shouldReturnNullWhenThereIsNoCommandOldVersion() throws IOException {
        InMemoryLogChannel channel = new InMemoryLogChannel();
        channel.put((byte)-1);
        channel.put((byte)3);
        channel.put((byte)0);
        LogEntry logEntry = this.logEntryReader.readLogEntry((ReadableLogChannel)channel, (byte)4);
        Assert.assertNull((Object)logEntry);
    }

    @Test
    public void shouldParseOldLogEntryEmptyANdReturnNull() throws IOException {
        InMemoryLogChannel channel = new InMemoryLogChannel();
        channel.put((byte)-1);
        channel.put((byte)0);
        LogEntry logEntry = this.logEntryReader.readLogEntry((ReadableLogChannel)channel, (byte)4);
        Assert.assertNull((Object)logEntry);
    }

    @Test
    public void shouldReturnNullWhenNotEnoughDataInTheChannelOnOldFormatToo() throws IOException {
        InMemoryLogChannel channel = new InMemoryLogChannel();
        LogEntry logEntry = this.logEntryReader.readLogEntry((ReadableLogChannel)channel, (byte)4);
        Assert.assertNull((Object)logEntry);
    }
}

