/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.transaction.log.pruning;

import java.io.File;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;
import org.neo4j.kernel.impl.transaction.log.LogFileInformation;
import org.neo4j.kernel.impl.transaction.log.pruning.FileCountThreshold;

public class FileCountThresholdTest {
    private final File file = (File)Mockito.mock(File.class);
    private final long version = 1L;
    private final LogFileInformation source = (LogFileInformation)Mockito.mock(LogFileInformation.class);

    @Test
    public void shouldReturnFalseWhenTheMaxNonEmptyLogCountIsNotReached() {
        int maxNonEmptyLogCount = 2;
        FileCountThreshold threshold = new FileCountThreshold(2);
        threshold.init();
        boolean result = threshold.reached(this.file, 1L, this.source);
        Assert.assertFalse((boolean)result);
    }

    @Test
    public void shouldReturnTrueWhenTheMaxNonEmptyLogCountIsReached() {
        int maxNonEmptyLogCount = 2;
        FileCountThreshold threshold = new FileCountThreshold(2);
        threshold.init();
        threshold.reached(this.file, 1L, this.source);
        boolean result = threshold.reached(this.file, 1L, this.source);
        Assert.assertTrue((boolean)result);
    }

    @Test
    public void shouldResetTheCounterWhenInitIsCalled() {
        int maxNonEmptyLogCount = 2;
        FileCountThreshold threshold = new FileCountThreshold(2);
        threshold.init();
        threshold.reached(this.file, 1L, this.source);
        threshold.reached(this.file, 1L, this.source);
        threshold.init();
        boolean result = threshold.reached(this.file, 1L, this.source);
        Assert.assertFalse((boolean)result);
    }
}

