/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.transaction.log.pruning;

import java.io.File;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.kernel.impl.transaction.log.LogFileInformation;
import org.neo4j.kernel.impl.transaction.log.pruning.FileSizeThreshold;

public class FileSizeThresholdTest {
    private FileSystemAbstraction fs = (FileSystemAbstraction)Mockito.mock(FileSystemAbstraction.class);
    private final LogFileInformation source = (LogFileInformation)Mockito.mock(LogFileInformation.class);
    private final File file = (File)Mockito.mock(File.class);
    private final long version = 1L;

    @Test
    public void shouldReturnFalseWhenFileSizeIsLowerThanMaxSize() {
        long maxSize = 10L;
        FileSizeThreshold threshold = new FileSizeThreshold(this.fs, 10L);
        Mockito.when((Object)this.fs.getFileSize(this.file)).thenReturn((Object)5L);
        threshold.init();
        boolean result = threshold.reached(this.file, 1L, this.source);
        Assert.assertFalse((boolean)result);
    }

    @Test
    public void shouldReturnTrueWhenASingleFileSizeIsGreaterOrEqualThanMaxSize() {
        long maxSize = 10L;
        FileSizeThreshold threshold = new FileSizeThreshold(this.fs, 10L);
        Mockito.when((Object)this.fs.getFileSize(this.file)).thenReturn((Object)10L);
        threshold.init();
        boolean result = threshold.reached(this.file, 1L, this.source);
        Assert.assertTrue((boolean)result);
    }

    @Test
    public void shouldSumSizeWhenCalledMultipleTimes() {
        long maxSize = 10L;
        FileSizeThreshold threshold = new FileSizeThreshold(this.fs, 10L);
        Mockito.when((Object)this.fs.getFileSize(this.file)).thenReturn((Object)5L);
        threshold.init();
        threshold.reached(this.file, 1L, this.source);
        boolean result = threshold.reached(this.file, 1L, this.source);
        Assert.assertTrue((boolean)result);
    }

    @Test
    public void shouldForgetPreviousValuesAfterAInitCall() {
        long maxSize = 10L;
        FileSizeThreshold threshold = new FileSizeThreshold(this.fs, 10L);
        Mockito.when((Object)this.fs.getFileSize(this.file)).thenReturn((Object)5L);
        threshold.init();
        threshold.reached(this.file, 1L, this.source);
        threshold.reached(this.file, 1L, this.source);
        threshold.init();
        boolean result = threshold.reached(this.file, 1L, this.source);
        Assert.assertFalse((boolean)result);
    }
}

