/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.transaction.log.pruning;

import java.io.File;
import java.io.IOException;
import org.junit.After;
import org.junit.Assert;
import org.junit.Ignore;
import org.junit.Test;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.Transaction;
import org.neo4j.graphdb.factory.GraphDatabaseSettings;
import org.neo4j.graphdb.mockfs.EphemeralFileSystemAbstraction;
import org.neo4j.helpers.collection.MapUtil;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.io.fs.StoreChannel;
import org.neo4j.kernel.GraphDatabaseAPI;
import org.neo4j.kernel.impl.transaction.log.LogVersionBridge;
import org.neo4j.kernel.impl.transaction.log.LogVersionedStoreChannel;
import org.neo4j.kernel.impl.transaction.log.PhysicalLogFile;
import org.neo4j.kernel.impl.transaction.log.PhysicalLogFiles;
import org.neo4j.kernel.impl.transaction.log.PhysicalLogVersionedStoreChannel;
import org.neo4j.kernel.impl.transaction.log.PhysicalTransactionCursor;
import org.neo4j.kernel.impl.transaction.log.ReadAheadLogChannel;
import org.neo4j.kernel.impl.transaction.log.ReadableLogChannel;
import org.neo4j.kernel.impl.transaction.log.entry.LogEntryReaderFactory;
import org.neo4j.test.ImpermanentGraphDatabase;

public class TestLogPruning {
    private final int transactionLogSize = 358;
    private GraphDatabaseAPI db;
    private FileSystemAbstraction fs;
    private PhysicalLogFiles files;

    @After
    public void after() throws Exception {
        if (this.db != null) {
            this.db.shutdown();
        }
    }

    @Test
    public void noPruning() throws Exception {
        this.newDb("true", 716);
        for (int i = 0; i < 100; ++i) {
            this.doTransaction();
        }
        long currentVersion = this.files.getHighestLogVersion();
        for (long version = 0L; version < currentVersion; ++version) {
            Assert.assertTrue((String)("Version " + version + " has been unexpectedly pruned"), (boolean)this.fs.fileExists(this.files.getLogFileForVersion(version)));
        }
    }

    @Test
    public void pruneByFileSize() throws Exception {
        int size = 1050;
        int logThreshold = 1074;
        this.newDb(size + " size", logThreshold);
        for (int i = 0; i < 100; ++i) {
            this.doTransaction();
        }
        int logFileSize = this.logFileSize();
        Assert.assertTrue((logFileSize >= size - logThreshold && logFileSize <= size + logThreshold ? 1 : 0) != 0);
    }

    @Test
    public void pruneByFileCount() throws Exception {
        int logsToKeep = 5;
        this.newDb(logsToKeep + " files", 1074);
        for (int i = 0; i < 100; ++i) {
            this.doTransaction();
        }
        Assert.assertEquals((long)logsToKeep, (long)this.logCount());
    }

    @Test
    public void pruneByTransactionCount() throws Exception {
        int transactionsToKeep = 100;
        int transactionsPerLog = 3;
        this.newDb(transactionsToKeep + " txs", transactionsToKeep * transactionsPerLog);
        for (int i = 0; i < 100; ++i) {
            this.doTransaction();
        }
        int transactionCount = this.transactionCount();
        Assert.assertTrue((String)("Transaction count expected to be within " + transactionsToKeep + " <= txs <= " + (transactionsToKeep + transactionsPerLog) + ", but was " + transactionCount), (transactionCount >= transactionsToKeep && transactionCount <= transactionsToKeep + transactionsPerLog ? 1 : 0) != 0);
    }

    private GraphDatabaseAPI newDb(String logPruning, int rotateThreshold) {
        this.fs = new EphemeralFileSystemAbstraction();
        ImpermanentGraphDatabase db = new ImpermanentGraphDatabase(MapUtil.stringMap((String[])new String[]{GraphDatabaseSettings.keep_logical_logs.name(), logPruning, GraphDatabaseSettings.logical_log_rotation_threshold.name(), "" + rotateThreshold})){

            @Override
            protected FileSystemAbstraction createFileSystemAbstraction() {
                return TestLogPruning.this.fs;
            }
        };
        this.db = db;
        this.files = new PhysicalLogFiles(new File(db.getStoreDir()), "neostore.transaction.db", this.fs);
        return db;
    }

    private void doTransaction() {
        try (Transaction tx = this.db.beginTx();){
            Node node = this.db.createNode();
            node.setProperty("name", (Object)"a somewhat lengthy string of some sort, right?");
            tx.success();
        }
    }

    @Test
    @Ignore(value="Here as a helper to figure out the transaction size of the sample transaction on disk")
    public void figureOutSampleTransactionSizeBytes() {
        this.db = this.newDb("true", 716);
        this.doTransaction();
        this.db.shutdown();
        System.out.println(this.fs.getFileSize(this.files.getLogFileForVersion(0L)));
    }

    private int aggregateLogData(Extractor extractor) throws IOException {
        File versionFileName;
        int total = 0;
        for (long i = this.files.getHighestLogVersion(); i >= 0L && this.fs.fileExists(versionFileName = this.files.getLogFileForVersion(i)); --i) {
            total += extractor.extract(versionFileName);
        }
        return total;
    }

    private int logCount() throws IOException {
        return this.aggregateLogData(new Extractor(){

            @Override
            public int extract(File from) {
                return 1;
            }
        });
    }

    private int logFileSize() throws IOException {
        return this.aggregateLogData(new Extractor(){

            @Override
            public int extract(File from) {
                return (int)TestLogPruning.this.fs.getFileSize(from);
            }
        });
    }

    private int transactionCount() throws IOException {
        return this.aggregateLogData(new Extractor(){

            @Override
            public int extract(File from) throws IOException {
                int counter = 0;
                LogVersionBridge bridge = new LogVersionBridge(){

                    public LogVersionedStoreChannel next(LogVersionedStoreChannel channel) throws IOException {
                        return channel;
                    }
                };
                StoreChannel storeChannel = TestLogPruning.this.fs.open(from, "r");
                PhysicalLogVersionedStoreChannel versionedStoreChannel = PhysicalLogFile.openForVersion((PhysicalLogFiles)TestLogPruning.this.files, (FileSystemAbstraction)TestLogPruning.this.fs, (long)5L);
                new PhysicalLogVersionedStoreChannel(storeChannel, -1L, 5);
                try (ReadAheadLogChannel channel = new ReadAheadLogChannel((LogVersionedStoreChannel)versionedStoreChannel, bridge, 1000);
                     PhysicalTransactionCursor physicalTransactionCursor = new PhysicalTransactionCursor((ReadableLogChannel)channel, new LogEntryReaderFactory().versionable());){
                    while (physicalTransactionCursor.next()) {
                        ++counter;
                    }
                }
                return counter;
            }
        });
    }

    private static interface Extractor {
        public int extract(File var1) throws IOException;
    }
}

