/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.transaction.log.pruning;

import java.io.File;
import org.junit.Test;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.kernel.impl.transaction.log.LogFileInformation;
import org.neo4j.kernel.impl.transaction.log.LogVersionRepository;
import org.neo4j.kernel.impl.transaction.log.PhysicalLogFiles;
import org.neo4j.kernel.impl.transaction.log.pruning.Threshold;
import org.neo4j.kernel.impl.transaction.log.pruning.ThresholdBasedPruneStrategy;

public class ThresholdBasedPruneStrategyTest {
    private final FileSystemAbstraction fileSystem = (FileSystemAbstraction)Mockito.mock(FileSystemAbstraction.class);
    private final LogFileInformation logFileInfo = (LogFileInformation)Mockito.mock(LogFileInformation.class);
    private final PhysicalLogFiles files = (PhysicalLogFiles)Mockito.mock(PhysicalLogFiles.class);
    private final LogVersionRepository logVersionRepository = (LogVersionRepository)Mockito.mock(LogVersionRepository.class);
    private final Threshold threshold = (Threshold)Mockito.mock(Threshold.class);

    @Test
    public void shouldNotDeleteAnythingIfThresholdDoesNotAllow() throws Exception {
        Mockito.when((Object)this.logVersionRepository.getCurrentLogVersion()).thenReturn((Object)7L);
        File fileName1 = new File("logical.log.v1");
        File fileName2 = new File("logical.log.v2");
        File fileName3 = new File("logical.log.v3");
        File fileName4 = new File("logical.log.v4");
        File fileName5 = new File("logical.log.v5");
        File fileName6 = new File("logical.log.v6");
        Mockito.when((Object)this.files.getLogFileForVersion(6L)).thenReturn((Object)fileName6);
        Mockito.when((Object)this.files.getLogFileForVersion(5L)).thenReturn((Object)fileName5);
        Mockito.when((Object)this.files.getLogFileForVersion(4L)).thenReturn((Object)fileName4);
        Mockito.when((Object)this.files.getLogFileForVersion(3L)).thenReturn((Object)fileName3);
        Mockito.when((Object)this.files.getLogFileForVersion(2L)).thenReturn((Object)fileName2);
        Mockito.when((Object)this.files.getLogFileForVersion(1L)).thenReturn((Object)fileName1);
        Mockito.when((Object)this.fileSystem.fileExists(fileName6)).thenReturn((Object)true);
        Mockito.when((Object)this.fileSystem.fileExists(fileName5)).thenReturn((Object)true);
        Mockito.when((Object)this.fileSystem.fileExists(fileName4)).thenReturn((Object)true);
        Mockito.when((Object)this.fileSystem.fileExists(fileName3)).thenReturn((Object)true);
        Mockito.when((Object)this.fileSystem.fileExists(fileName2)).thenReturn((Object)true);
        Mockito.when((Object)this.fileSystem.fileExists(fileName1)).thenReturn((Object)true);
        Mockito.when((Object)this.fileSystem.getFileSize((File)Matchers.any())).thenReturn((Object)17L);
        Mockito.when((Object)this.threshold.reached((File)Matchers.any(), Matchers.anyLong(), (LogFileInformation)Matchers.any())).thenReturn((Object)false);
        ThresholdBasedPruneStrategy strategy = new ThresholdBasedPruneStrategy(this.fileSystem, this.logFileInfo, this.files, this.logVersionRepository, this.threshold);
        strategy.prune();
        ((Threshold)Mockito.verify((Object)this.threshold, (VerificationMode)Mockito.times((int)1))).init();
        ((FileSystemAbstraction)Mockito.verify((Object)this.fileSystem, (VerificationMode)Mockito.times((int)0))).deleteFile((File)Matchers.any());
    }

    @Test
    public void shouldDeleteJustWhatTheThresholdSays() throws Exception {
        Mockito.when((Object)this.threshold.reached((File)Matchers.any(), Matchers.eq((long)6L), (LogFileInformation)Matchers.any())).thenReturn((Object)false);
        Mockito.when((Object)this.threshold.reached((File)Matchers.any(), Matchers.eq((long)5L), (LogFileInformation)Matchers.any())).thenReturn((Object)false);
        Mockito.when((Object)this.threshold.reached((File)Matchers.any(), Matchers.eq((long)4L), (LogFileInformation)Matchers.any())).thenReturn((Object)false);
        Mockito.when((Object)this.threshold.reached((File)Matchers.any(), Matchers.eq((long)3L), (LogFileInformation)Matchers.any())).thenReturn((Object)true);
        File fileName1 = new File("logical.log.v1");
        File fileName2 = new File("logical.log.v2");
        File fileName3 = new File("logical.log.v3");
        File fileName4 = new File("logical.log.v4");
        File fileName5 = new File("logical.log.v5");
        File fileName6 = new File("logical.log.v6");
        Mockito.when((Object)this.files.getLogFileForVersion(6L)).thenReturn((Object)fileName6);
        Mockito.when((Object)this.files.getLogFileForVersion(5L)).thenReturn((Object)fileName5);
        Mockito.when((Object)this.files.getLogFileForVersion(4L)).thenReturn((Object)fileName4);
        Mockito.when((Object)this.files.getLogFileForVersion(3L)).thenReturn((Object)fileName3);
        Mockito.when((Object)this.files.getLogFileForVersion(2L)).thenReturn((Object)fileName2);
        Mockito.when((Object)this.files.getLogFileForVersion(1L)).thenReturn((Object)fileName1);
        Mockito.when((Object)this.fileSystem.fileExists(fileName6)).thenReturn((Object)true);
        Mockito.when((Object)this.fileSystem.fileExists(fileName5)).thenReturn((Object)true);
        Mockito.when((Object)this.fileSystem.fileExists(fileName4)).thenReturn((Object)true);
        Mockito.when((Object)this.fileSystem.fileExists(fileName3)).thenReturn((Object)true);
        Mockito.when((Object)this.fileSystem.fileExists(fileName2)).thenReturn((Object)true);
        Mockito.when((Object)this.fileSystem.fileExists(fileName1)).thenReturn((Object)true);
        Mockito.when((Object)this.fileSystem.getFileSize((File)Matchers.any())).thenReturn((Object)17L);
        Mockito.when((Object)this.logVersionRepository.getCurrentLogVersion()).thenReturn((Object)7L);
        ThresholdBasedPruneStrategy strategy = new ThresholdBasedPruneStrategy(this.fileSystem, this.logFileInfo, this.files, this.logVersionRepository, this.threshold);
        strategy.prune();
        ((Threshold)Mockito.verify((Object)this.threshold, (VerificationMode)Mockito.times((int)1))).init();
        ((FileSystemAbstraction)Mockito.verify((Object)this.fileSystem, (VerificationMode)Mockito.times((int)1))).deleteFile(fileName1);
        ((FileSystemAbstraction)Mockito.verify((Object)this.fileSystem, (VerificationMode)Mockito.times((int)1))).deleteFile(fileName2);
        ((FileSystemAbstraction)Mockito.verify((Object)this.fileSystem, (VerificationMode)Mockito.times((int)1))).deleteFile(fileName3);
    }
}

