/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.transaction.state;

import java.io.IOException;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import junit.framework.TestCase;
import org.junit.Assert;
import org.junit.Test;
import org.neo4j.helpers.collection.MapUtil;
import org.neo4j.kernel.api.index.SchemaIndexProvider;
import org.neo4j.kernel.impl.index.IndexCommand;
import org.neo4j.kernel.impl.index.IndexDefineCommand;
import org.neo4j.kernel.impl.index.IndexEntityType;
import org.neo4j.kernel.impl.store.record.DynamicRecord;
import org.neo4j.kernel.impl.store.record.IndexRule;
import org.neo4j.kernel.impl.store.record.LabelTokenRecord;
import org.neo4j.kernel.impl.store.record.NeoStoreRecord;
import org.neo4j.kernel.impl.store.record.NodeRecord;
import org.neo4j.kernel.impl.store.record.PrimitiveRecord;
import org.neo4j.kernel.impl.store.record.PropertyKeyTokenRecord;
import org.neo4j.kernel.impl.store.record.PropertyRecord;
import org.neo4j.kernel.impl.store.record.RelationshipRecord;
import org.neo4j.kernel.impl.store.record.RelationshipTypeTokenRecord;
import org.neo4j.kernel.impl.store.record.SchemaRule;
import org.neo4j.kernel.impl.store.record.TokenRecord;
import org.neo4j.kernel.impl.transaction.TransactionRepresentation;
import org.neo4j.kernel.impl.transaction.command.Command;
import org.neo4j.kernel.impl.transaction.command.NeoCommandHandler;
import org.neo4j.kernel.impl.transaction.log.CommandWriter;
import org.neo4j.kernel.impl.transaction.log.InMemoryLogChannel;
import org.neo4j.kernel.impl.transaction.log.PhysicalTransactionRepresentation;
import org.neo4j.kernel.impl.transaction.log.ReadableLogChannel;
import org.neo4j.kernel.impl.transaction.log.WritableLogChannel;
import org.neo4j.kernel.impl.transaction.log.entry.LogEntry;
import org.neo4j.kernel.impl.transaction.log.entry.LogEntryCommand;
import org.neo4j.kernel.impl.transaction.log.entry.LogEntryReader;
import org.neo4j.kernel.impl.transaction.log.entry.LogEntryReaderFactory;
import org.neo4j.kernel.impl.transaction.log.entry.LogEntryWriterv1;

public class LogTruncationTest {
    private final InMemoryLogChannel inMemoryChannel = new InMemoryLogChannel();
    private final LogEntryReader<ReadableLogChannel> logEntryReader = new LogEntryReaderFactory().create();
    private final CommandWriter serializer = new CommandWriter((WritableLogChannel)this.inMemoryChannel);
    private final LogEntryWriterv1 writer = new LogEntryWriterv1((WritableLogChannel)this.inMemoryChannel, (NeoCommandHandler)this.serializer);
    private final Map<Class<?>, Command[]> permutations = new HashMap();

    public LogTruncationTest() {
        this.permutations.put(Command.NeoStoreCommand.class, new Command[]{new Command.NeoStoreCommand().init(new NeoStoreRecord())});
        this.permutations.put(Command.NodeCommand.class, new Command[]{new Command.NodeCommand().init(new NodeRecord(12L, false, 13L, 13L), new NodeRecord(0L, false, 0L, 0L))});
        this.permutations.put(Command.RelationshipCommand.class, new Command[]{new Command.RelationshipCommand().init(new RelationshipRecord(1L, 2L, 3L, 4))});
        this.permutations.put(Command.PropertyCommand.class, new Command[]{new Command.PropertyCommand().init(new PropertyRecord(1L, (PrimitiveRecord)new NodeRecord(12L, false, 13L, 13L)), new PropertyRecord(1L, (PrimitiveRecord)new NodeRecord(12L, false, 13L, 13L)))});
        this.permutations.put(Command.RelationshipGroupCommand.class, new Command[]{new Command.LabelTokenCommand().init((TokenRecord)new LabelTokenRecord(1))});
        this.permutations.put(Command.SchemaRuleCommand.class, new Command[]{new Command.SchemaRuleCommand().init(Arrays.asList(DynamicRecord.dynamicRecord((long)1L, (boolean)false, (boolean)true, (long)-1L, (int)1, (byte[])"hello".getBytes())), Arrays.asList(DynamicRecord.dynamicRecord((long)1L, (boolean)true, (boolean)true, (long)-1L, (int)1, (byte[])"hello".getBytes())), (SchemaRule)new IndexRule(1L, 3, 4, new SchemaIndexProvider.Descriptor("1", "2"), null))});
        this.permutations.put(Command.RelationshipTypeTokenCommand.class, new Command[]{new Command.RelationshipTypeTokenCommand().init((TokenRecord)new RelationshipTypeTokenRecord(1))});
        this.permutations.put(Command.PropertyKeyTokenCommand.class, new Command[]{new Command.PropertyKeyTokenCommand().init((TokenRecord)new PropertyKeyTokenRecord(1))});
        this.permutations.put(Command.LabelTokenCommand.class, new Command[]{new Command.LabelTokenCommand().init((TokenRecord)new LabelTokenRecord(1))});
        IndexCommand.AddRelationshipCommand addRelationshipCommand = new IndexCommand.AddRelationshipCommand();
        addRelationshipCommand.init((byte)1, 1L, (byte)1, (Object)"some value", 1L, 1L);
        this.permutations.put(IndexCommand.AddRelationshipCommand.class, new Command[]{addRelationshipCommand});
        IndexCommand.CreateCommand createCommand = new IndexCommand.CreateCommand();
        createCommand.init((byte)1, IndexEntityType.Relationship.id(), MapUtil.stringMap((String[])new String[]{"string1", "string 2"}));
        this.permutations.put(IndexCommand.CreateCommand.class, new Command[]{createCommand});
        IndexCommand.AddNodeCommand addCommand = new IndexCommand.AddNodeCommand();
        addCommand.init((byte)1, 122L, (byte)2, (Object)"value");
        this.permutations.put(IndexCommand.AddNodeCommand.class, new Command[]{addCommand});
        IndexCommand.DeleteCommand deleteCommand = new IndexCommand.DeleteCommand();
        deleteCommand.init((byte)1, IndexEntityType.Relationship.id());
        this.permutations.put(IndexCommand.DeleteCommand.class, new Command[]{deleteCommand});
        IndexCommand.RemoveCommand removeCommand = new IndexCommand.RemoveCommand();
        removeCommand.init((byte)1, IndexEntityType.Node.id(), 126L, (byte)3, (Object)"the value");
        this.permutations.put(IndexCommand.RemoveCommand.class, new Command[]{removeCommand});
        IndexDefineCommand indexDefineCommand = new IndexDefineCommand();
        indexDefineCommand.init(MapUtil.genericMap((Object[])new Object[]{"string1", (byte)45, "key1", (byte)2}), MapUtil.genericMap((Object[])new Object[]{"string", (byte)2}));
        this.permutations.put(IndexDefineCommand.class, new Command[]{indexDefineCommand});
        Command.CountsCommand countsCommand = new Command.CountsCommand();
        countsCommand.init(17, 2, 13, -2L);
        this.permutations.put(Command.CountsCommand.class, new Command[]{countsCommand});
    }

    @Test
    public void testSerializationInFaceOfLogTruncation() throws Exception {
        for (Command cmd : this.enumerateCommands()) {
            this.assertHandlesLogTruncation(cmd);
        }
    }

    private Iterable<Command> enumerateCommands() {
        ArrayList<Command> commands = new ArrayList<Command>();
        for (Class<?> cmd : Command.class.getClasses()) {
            if (!Command.class.isAssignableFrom(cmd)) continue;
            if (this.permutations.containsKey(cmd)) {
                commands.addAll(Arrays.asList((Object[])this.permutations.get(cmd)));
                continue;
            }
            if (!Modifier.isAbstract(cmd.getModifiers())) {
                throw new AssertionError((Object)("Unknown command type: " + cmd + ", please add missing instantiation to " + "test serialization of this command."));
            }
        }
        for (Class<?> cmd : IndexCommand.class.getClasses()) {
            if (!Command.class.isAssignableFrom(cmd)) continue;
            if (this.permutations.containsKey(cmd)) {
                commands.addAll(Arrays.asList((Object[])this.permutations.get(cmd)));
                continue;
            }
            if (!Modifier.isAbstract(cmd.getModifiers())) {
                throw new AssertionError((Object)("Unknown command type: " + cmd + ", please add missing instantiation to " + "test serialization of this command."));
            }
        }
        return commands;
    }

    private void assertHandlesLogTruncation(Command cmd) throws IOException {
        this.inMemoryChannel.reset();
        this.writer.serialize((TransactionRepresentation)new PhysicalTransactionRepresentation(Arrays.asList(cmd)));
        int bytesSuccessfullyWritten = this.inMemoryChannel.writerPosition();
        try {
            LogEntry logEntry = this.logEntryReader.readLogEntry((ReadableLogChannel)this.inMemoryChannel);
            Command command = ((LogEntryCommand)logEntry).getXaCommand();
            Assert.assertEquals((Object)cmd, (Object)command);
        }
        catch (Exception e) {
            throw new AssertionError("Failed to deserialize " + cmd.toString() + ", because: ", e);
        }
        while (true) {
            int n = --bytesSuccessfullyWritten;
            --bytesSuccessfullyWritten;
            if (n <= 0) break;
            this.inMemoryChannel.reset();
            this.writer.serialize((TransactionRepresentation)new PhysicalTransactionRepresentation(Arrays.asList(cmd)));
            this.inMemoryChannel.truncateTo(bytesSuccessfullyWritten);
            LogEntry deserialized = this.logEntryReader.readLogEntry((ReadableLogChannel)this.inMemoryChannel);
            TestCase.assertNull((String)("Deserialization did not detect log truncation!Record: " + cmd + ", deserialized: " + deserialized), (Object)deserialized);
        }
    }

    @Test
    public void testInMemoryLogChannel() throws Exception {
        long i;
        int i2;
        InMemoryLogChannel channel = new InMemoryLogChannel();
        for (i2 = 0; i2 < 25; ++i2) {
            channel.putInt(i2);
        }
        for (i2 = 0; i2 < 25; ++i2) {
            Assert.assertEquals((long)i2, (long)channel.getInt());
        }
        channel.reset();
        for (i = 0L; i < 12L; ++i) {
            channel.putLong(i);
        }
        for (i = 0L; i < 12L; ++i) {
            Assert.assertEquals((long)i, (long)channel.getLong());
        }
        channel.reset();
        for (i = 0L; i < 8L; ++i) {
            channel.putLong(i);
            channel.putInt((int)i);
        }
        for (i = 0L; i < 8L; ++i) {
            Assert.assertEquals((long)i, (long)channel.getLong());
            Assert.assertEquals((long)i, (long)channel.getInt());
        }
        channel.close();
    }
}

