/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.transaction.state;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Set;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;
import org.neo4j.graphdb.ResourceIterator;
import org.neo4j.helpers.collection.IteratorUtil;
import org.neo4j.kernel.api.labelscan.LabelScanStore;
import org.neo4j.kernel.impl.api.LegacyIndexApplier;
import org.neo4j.kernel.impl.api.index.IndexingService;
import org.neo4j.kernel.impl.transaction.state.NeoStoreFileListing;

public class NeoStoreFileListingTest {
    private LabelScanStore labelScanStore;
    private IndexingService indexingService;
    private File storeDir;
    private LegacyIndexApplier.ProviderLookup legacyIndexes;
    private static final String[] STANDARD_STORE_DIR_FILES = new String[]{"lock", "messages.log", "neostore", "neostore.id", "neostore.counts.db.a", "neostore.counts.db.b", "neostore.labeltokenstore.db", "neostore.labeltokenstore.db.id", "neostore.labeltokenstore.db.names", "neostore.labeltokenstore.db.names.id", "neostore.nodestore.db", "neostore.nodestore.db.id", "neostore.nodestore.db.labels", "neostore.nodestore.db.labels.id", "neostore.propertystore.db", "neostore.propertystore.db.arrays", "neostore.propertystore.db.arrays.id", "neostore.propertystore.db.id", "neostore.propertystore.db.index", "neostore.propertystore.db.index.id", "neostore.propertystore.db.index.keys", "neostore.propertystore.db.index.keys.id", "neostore.propertystore.db.strings", "neostore.propertystore.db.strings.id", "neostore.relationshipstore.db", "neostore.relationshipstore.db.id", "neostore.relationshiptypestore.db", "neostore.relationshiptypestore.db.id", "neostore.relationshiptypestore.db.names", "neostore.relationshiptypestore.db.names.id", "neostore.schemastore.db", "neostore.schemastore.db.id", "neostore.transaction.db.active", "neostore.transaction.db.0", "neostore.transaction.db.1", "neostore.transaction.db.2", "store_lock"};
    private static final String[] STANDARD_STORE_DIR_DIRECTORIES = new String[]{"schema", "index", "branched"};

    @Before
    public void setUp() throws IOException {
        this.labelScanStore = (LabelScanStore)Mockito.mock(LabelScanStore.class);
        this.indexingService = (IndexingService)Mockito.mock(IndexingService.class);
        this.legacyIndexes = (LegacyIndexApplier.ProviderLookup)Mockito.mock(LegacyIndexApplier.ProviderLookup.class);
        Mockito.when((Object)this.legacyIndexes.providers()).thenReturn(Collections.emptyList());
        this.storeDir = (File)Mockito.mock(File.class);
    }

    @Test
    public void shouldOnlyListNeoStoreFiles() throws Exception {
        this.filesInStoreDirAre(STANDARD_STORE_DIR_FILES, STANDARD_STORE_DIR_DIRECTORIES);
        this.scanStoreFilesAre(new String[0]);
        this.indexFilesAre(new String[0]);
        NeoStoreFileListing fileListing = this.newFileListing();
        ResourceIterator result = fileListing.listStoreFiles();
        MatcherAssert.assertThat(this.asSetOfPaths((ResourceIterator<File>)result), (Matcher)Matchers.equalTo((Object)IteratorUtil.asSet((Object[])new String[]{"neostore.labeltokenstore.db", "neostore.labeltokenstore.db.names", "neostore.counts.db.a", "neostore.counts.db.b", "neostore.nodestore.db", "neostore.nodestore.db.labels", "neostore.propertystore.db", "neostore.propertystore.db.arrays", "neostore.propertystore.db.index", "neostore.propertystore.db.index.keys", "neostore.propertystore.db.strings", "neostore.relationshipstore.db", "neostore.relationshiptypestore.db", "neostore.relationshiptypestore.db.names", "neostore.schemastore.db", "neostore"})));
    }

    @Test
    public void shouldListNeoStoreFiles() throws Exception {
        this.filesInStoreDirAre(STANDARD_STORE_DIR_FILES, STANDARD_STORE_DIR_DIRECTORIES);
        this.scanStoreFilesAre(new String[0]);
        this.indexFilesAre(new String[0]);
        NeoStoreFileListing fileListing = this.newFileListing();
        ResourceIterator result = fileListing.listStoreFiles();
        Set<String> pathSet = this.asSetOfPaths((ResourceIterator<File>)result);
        MatcherAssert.assertThat(pathSet, (Matcher)Matchers.equalTo((Object)IteratorUtil.asSet((Object[])new String[]{"neostore.labeltokenstore.db", "neostore.labeltokenstore.db.names", "neostore.counts.db.a", "neostore.counts.db.b", "neostore.nodestore.db", "neostore.nodestore.db.labels", "neostore.propertystore.db", "neostore.propertystore.db.arrays", "neostore.propertystore.db.index", "neostore.propertystore.db.index.keys", "neostore.propertystore.db.strings", "neostore.relationshipstore.db", "neostore.relationshiptypestore.db", "neostore.relationshiptypestore.db.names", "neostore.schemastore.db", "neostore"})));
    }

    @Test
    public void shouldListNeoStoreFilesAndLogicalLogs() throws Exception {
        this.filesInStoreDirAre(STANDARD_STORE_DIR_FILES, STANDARD_STORE_DIR_DIRECTORIES);
        this.scanStoreFilesAre(new String[0]);
        this.indexFilesAre(new String[0]);
        NeoStoreFileListing fileListing = this.newFileListing();
        ResourceIterator result = fileListing.listStoreFiles();
        Set<String> pathSet = this.asSetOfPaths((ResourceIterator<File>)result);
        MatcherAssert.assertThat(pathSet, (Matcher)Matchers.equalTo((Object)IteratorUtil.asSet((Object[])new String[]{"neostore.labeltokenstore.db", "neostore.labeltokenstore.db.names", "neostore.counts.db.a", "neostore.counts.db.b", "neostore.nodestore.db", "neostore.nodestore.db.labels", "neostore.propertystore.db", "neostore.propertystore.db.arrays", "neostore.propertystore.db.index", "neostore.propertystore.db.index.keys", "neostore.propertystore.db.strings", "neostore.relationshipstore.db", "neostore.relationshiptypestore.db", "neostore.relationshiptypestore.db.names", "neostore.schemastore.db", "neostore"})));
    }

    @Test
    public void shouldListLabelScanStoreAndSchemaIndexes() throws Exception {
        this.filesInStoreDirAre(STANDARD_STORE_DIR_FILES, STANDARD_STORE_DIR_DIRECTORIES);
        this.scanStoreFilesAre(new String[]{"blah/scan.store", "scan.more"});
        this.indexFilesAre(new String[]{"schema/index/my.index", "schema/index/their.index"});
        NeoStoreFileListing fileListing = this.newFileListing();
        ResourceIterator result = fileListing.listStoreFiles();
        MatcherAssert.assertThat(this.asSetOfPaths((ResourceIterator<File>)result), (Matcher)Matchers.equalTo((Object)IteratorUtil.asSet((Object[])new String[]{"blah/scan.store", "scan.more", "schema/index/my.index", "schema/index/their.index", "neostore.labeltokenstore.db", "neostore.labeltokenstore.db.names", "neostore.counts.db.a", "neostore.counts.db.b", "neostore.nodestore.db", "neostore.nodestore.db.labels", "neostore.propertystore.db", "neostore.propertystore.db.arrays", "neostore.propertystore.db.index", "neostore.propertystore.db.index.keys", "neostore.propertystore.db.strings", "neostore.relationshipstore.db", "neostore.relationshiptypestore.db", "neostore.relationshiptypestore.db.names", "neostore.schemastore.db", "neostore"})));
    }

    @Test
    public void shouldCloseIndexAndLabelScanSnapshots() throws Exception {
        this.filesInStoreDirAre(STANDARD_STORE_DIR_FILES, STANDARD_STORE_DIR_DIRECTORIES);
        ResourceIterator<File> scanSnapshot = this.scanStoreFilesAre(new String[]{"blah/scan.store", "scan.more"});
        ResourceIterator<File> indexSnapshot = this.indexFilesAre(new String[]{"schema/index/my.index"});
        NeoStoreFileListing fileListing = this.newFileListing();
        ResourceIterator result = fileListing.listStoreFiles();
        result.close();
        ((ResourceIterator)Mockito.verify(scanSnapshot)).close();
        ((ResourceIterator)Mockito.verify(indexSnapshot)).close();
    }

    private NeoStoreFileListing newFileListing() {
        return new NeoStoreFileListing(this.storeDir, this.labelScanStore, this.indexingService, this.legacyIndexes);
    }

    private Set<String> asSetOfPaths(ResourceIterator<File> result) {
        ArrayList<String> fnames = new ArrayList<String>();
        while (result.hasNext()) {
            fnames.add(((File)result.next()).getPath());
        }
        return IteratorUtil.asUniqueSet(fnames);
    }

    private void filesInStoreDirAre(String[] filenames, String[] dirs) {
        ArrayList<File> files = new ArrayList<File>();
        this.mockFiles(filenames, files, false);
        this.mockFiles(dirs, files, true);
        Mockito.when((Object)this.storeDir.listFiles()).thenReturn((Object)files.toArray(new File[files.size()]));
    }

    private ResourceIterator<File> scanStoreFilesAre(String[] fileNames) throws IOException {
        ArrayList<File> files = new ArrayList<File>();
        this.mockFiles(fileNames, files, false);
        ResourceIterator snapshot = (ResourceIterator)Mockito.spy((Object)IteratorUtil.asResourceIterator(files.iterator()));
        Mockito.when((Object)this.labelScanStore.snapshotStoreFiles()).thenReturn((Object)snapshot);
        return snapshot;
    }

    private ResourceIterator<File> indexFilesAre(String[] fileNames) throws IOException {
        ArrayList<File> files = new ArrayList<File>();
        this.mockFiles(fileNames, files, false);
        ResourceIterator snapshot = (ResourceIterator)Mockito.spy((Object)IteratorUtil.asResourceIterator(files.iterator()));
        Mockito.when((Object)this.indexingService.snapshotStoreFiles()).thenReturn((Object)snapshot);
        return snapshot;
    }

    private void mockFiles(String[] filenames, ArrayList<File> files, boolean isDirectories) {
        for (String filename : filenames) {
            File file = (File)Mockito.mock(File.class);
            String[] fileNameParts = filename.split("/");
            Mockito.when((Object)file.getName()).thenReturn((Object)fileNameParts[fileNameParts.length - 1]);
            Mockito.when((Object)file.isFile()).thenReturn((Object)(!isDirectories ? 1 : 0));
            Mockito.when((Object)file.isDirectory()).thenReturn((Object)isDirectories);
            Mockito.when((Object)file.exists()).thenReturn((Object)true);
            Mockito.when((Object)file.getPath()).thenReturn((Object)filename);
            files.add(file);
        }
    }
}

