/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.transaction.state;

import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.core.IsEqual;
import org.junit.After;
import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.kernel.DefaultIdGeneratorFactory;
import org.neo4j.kernel.IdGeneratorFactory;
import org.neo4j.kernel.configuration.Config;
import org.neo4j.kernel.impl.store.DynamicNodeLabels;
import org.neo4j.kernel.impl.store.DynamicRecordAllocator;
import org.neo4j.kernel.impl.store.NodeLabels;
import org.neo4j.kernel.impl.store.NodeLabelsField;
import org.neo4j.kernel.impl.store.NodeStore;
import org.neo4j.kernel.impl.store.ShortArray;
import org.neo4j.kernel.impl.store.StoreFactory;
import org.neo4j.kernel.impl.store.record.DynamicRecord;
import org.neo4j.kernel.impl.store.record.NodeRecord;
import org.neo4j.kernel.impl.transaction.command.Command;
import org.neo4j.kernel.impl.transaction.command.CommandReader;
import org.neo4j.kernel.impl.transaction.command.NeoCommandHandler;
import org.neo4j.kernel.impl.transaction.command.PhysicalLogNeoCommandReaderV2;
import org.neo4j.kernel.impl.transaction.log.CommandWriter;
import org.neo4j.kernel.impl.transaction.log.InMemoryLogChannel;
import org.neo4j.kernel.impl.transaction.log.ReadableLogChannel;
import org.neo4j.kernel.impl.transaction.log.WritableLogChannel;
import org.neo4j.kernel.impl.util.IoPrimitiveUtils;
import org.neo4j.kernel.impl.util.StringLogger;
import org.neo4j.kernel.monitoring.Monitors;
import org.neo4j.test.EphemeralFileSystemRule;
import org.neo4j.test.PageCacheRule;

public class NodeCommandTest {
    @ClassRule
    public static PageCacheRule pageCacheRule = new PageCacheRule();
    private NodeStore nodeStore;
    InMemoryLogChannel channel = new InMemoryLogChannel();
    private final CommandReader commandReader = new PhysicalLogNeoCommandReaderV2();
    private final CommandWriter commandWriter = new CommandWriter((WritableLogChannel)this.channel);
    @Rule
    public EphemeralFileSystemRule fs = new EphemeralFileSystemRule();

    @Test
    public void shouldSerializeAndDeserializeUnusedRecords() throws Exception {
        NodeRecord before = new NodeRecord(12L, false, 1L, 2L);
        NodeRecord after = new NodeRecord(12L, false, 2L, 1L);
        Command.NodeCommand nodeCommand = new Command.NodeCommand();
        nodeCommand.init(before, after);
        this.assertSerializationWorksFor(nodeCommand);
    }

    @Test
    public void shouldSerializeCreatedRecord() throws Exception {
        NodeRecord before = new NodeRecord(12L, false, 1L, 2L);
        NodeRecord after = new NodeRecord(12L, false, 2L, 1L);
        after.setCreated();
        after.setInUse(true);
        Command.NodeCommand nodeCommand = new Command.NodeCommand();
        nodeCommand.init(before, after);
        this.assertSerializationWorksFor(nodeCommand);
    }

    @Test
    public void shouldSerializeUpdatedRecord() throws Exception {
        NodeRecord before = new NodeRecord(12L, false, 1L, 2L);
        before.setInUse(true);
        NodeRecord after = new NodeRecord(12L, false, 2L, 1L);
        after.setInUse(true);
        Command.NodeCommand nodeCommand = new Command.NodeCommand();
        nodeCommand.init(before, after);
        this.assertSerializationWorksFor(nodeCommand);
    }

    @Test
    public void shouldSerializeInlineLabels() throws Exception {
        NodeRecord before = new NodeRecord(12L, false, 1L, 2L);
        before.setInUse(true);
        NodeRecord after = new NodeRecord(12L, false, 2L, 1L);
        after.setInUse(true);
        NodeLabels nodeLabels = NodeLabelsField.parseLabelsField((NodeRecord)after);
        nodeLabels.add(1337L, this.nodeStore, (DynamicRecordAllocator)this.nodeStore.getDynamicLabelStore());
        Command.NodeCommand nodeCommand = new Command.NodeCommand();
        nodeCommand.init(before, after);
        this.assertSerializationWorksFor(nodeCommand);
    }

    @Test
    public void shouldSerializeDynamicRecordLabels() throws Exception {
        NodeRecord before = new NodeRecord(12L, false, 1L, 2L);
        before.setInUse(true);
        NodeRecord after = new NodeRecord(12L, false, 2L, 1L);
        after.setInUse(true);
        NodeLabels nodeLabels = NodeLabelsField.parseLabelsField((NodeRecord)after);
        for (int i = 10; i < 100; ++i) {
            nodeLabels.add((long)i, this.nodeStore, (DynamicRecordAllocator)this.nodeStore.getDynamicLabelStore());
        }
        Command.NodeCommand nodeCommand = new Command.NodeCommand();
        nodeCommand.init(before, after);
        this.assertSerializationWorksFor(nodeCommand);
    }

    @Test
    public void shouldSerializeDynamicRecordsRemoved() throws Exception {
        this.channel.reset();
        NodeRecord before = new NodeRecord(12L, false, 1L, 2L);
        before.setInUse(true);
        List<DynamicRecord> beforeDyn = Arrays.asList(DynamicRecord.dynamicRecord((long)0L, (boolean)true, (boolean)true, (long)-1L, (int)ShortArray.LONG.intValue(), (byte[])new byte[]{1, 2, 3, 4, 5, 6, 7, 8}));
        before.setLabelField(DynamicNodeLabels.dynamicPointer(beforeDyn), beforeDyn);
        NodeRecord after = new NodeRecord(12L, false, 2L, 1L);
        after.setInUse(true);
        List<DynamicRecord> dynamicRecords = Arrays.asList(DynamicRecord.dynamicRecord((long)0L, (boolean)false, (boolean)true, (long)-1L, (int)ShortArray.LONG.intValue(), (byte[])new byte[]{1, 2, 3, 4, 5, 6, 7, 8}));
        after.setLabelField(DynamicNodeLabels.dynamicPointer(dynamicRecords), dynamicRecords);
        Command.NodeCommand cmd = new Command.NodeCommand();
        cmd.init(before, after);
        cmd.handle((NeoCommandHandler)this.commandWriter);
        Command.NodeCommand result = (Command.NodeCommand)this.commandReader.read((ReadableLogChannel)this.channel);
        MatcherAssert.assertThat((Object)result, (Matcher)IsEqual.equalTo((Object)cmd));
        MatcherAssert.assertThat((Object)result.getMode(), (Matcher)IsEqual.equalTo((Object)cmd.getMode()));
        MatcherAssert.assertThat((Object)result.getBefore(), (Matcher)IsEqual.equalTo((Object)cmd.getBefore()));
        MatcherAssert.assertThat((Object)result.getAfter(), (Matcher)IsEqual.equalTo((Object)cmd.getAfter()));
        MatcherAssert.assertThat((Object)result.getBefore().getDynamicLabelRecords(), (Matcher)IsEqual.equalTo((Object)cmd.getBefore().getDynamicLabelRecords()));
        MatcherAssert.assertThat((Object)result.getAfter().getDynamicLabelRecords(), (Matcher)IsEqual.equalTo((Object)cmd.getAfter().getDynamicLabelRecords()));
    }

    private void assertSerializationWorksFor(Command.NodeCommand cmd) throws IOException {
        this.channel.reset();
        cmd.handle((NeoCommandHandler)this.commandWriter);
        Command.NodeCommand result = (Command.NodeCommand)this.commandReader.read((ReadableLogChannel)this.channel);
        MatcherAssert.assertThat((Object)result, (Matcher)IsEqual.equalTo((Object)cmd));
        MatcherAssert.assertThat((Object)result.getMode(), (Matcher)IsEqual.equalTo((Object)cmd.getMode()));
        MatcherAssert.assertThat((Object)result.getBefore(), (Matcher)IsEqual.equalTo((Object)cmd.getBefore()));
        MatcherAssert.assertThat((Object)result.getAfter(), (Matcher)IsEqual.equalTo((Object)cmd.getAfter()));
        MatcherAssert.assertThat(this.labels(result.getBefore()), (Matcher)IsEqual.equalTo(this.labels(cmd.getBefore())));
        MatcherAssert.assertThat(this.labels(result.getAfter()), (Matcher)IsEqual.equalTo(this.labels(cmd.getAfter())));
        MatcherAssert.assertThat((Object)result.getBefore().getDynamicLabelRecords(), (Matcher)IsEqual.equalTo((Object)result.getBefore().getDynamicLabelRecords()));
        MatcherAssert.assertThat((Object)result.getAfter().getDynamicLabelRecords(), (Matcher)IsEqual.equalTo((Object)result.getAfter().getDynamicLabelRecords()));
    }

    private Set<Integer> labels(NodeRecord record) {
        long[] rawLabels = NodeLabelsField.parseLabelsField((NodeRecord)record).get(this.nodeStore);
        HashSet<Integer> labels = new HashSet<Integer>(rawLabels.length);
        for (long label : rawLabels) {
            labels.add(IoPrimitiveUtils.safeCastLongToInt((long)label));
        }
        return labels;
    }

    @Before
    public void before() throws Exception {
        File dir = new File("dir");
        this.fs.get().mkdirs(dir);
        Config config = StoreFactory.configForStoreDir((Config)new Config(), (File)dir);
        Monitors monitors = new Monitors();
        StoreFactory storeFactory = new StoreFactory(config, (IdGeneratorFactory)new DefaultIdGeneratorFactory(), pageCacheRule.getPageCache((FileSystemAbstraction)this.fs.get()), (FileSystemAbstraction)this.fs.get(), StringLogger.DEV_NULL, monitors);
        storeFactory.createNodeStore();
        this.nodeStore = storeFactory.newNodeStore();
    }

    @After
    public void after() throws Exception {
        this.nodeStore.close();
    }
}

